/*
 *	Example program for TERMIOS
 *
 *	Udo Munk (udo@umunk.GUN.de)
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include "termios.h"

int main()
{
	struct termios	term;
	int		speed;

	if (tcgetattr(STDIN_FILENO, &term) < 0) {
		fprintf(stderr, "tcgetattr error");
		exit(EXIT_FAILURE);
	}

	speed = cfgetispeed(&term);
	printf("tty line input speed is ");

	if      (speed == B50)		printf("50 baud\n");
	else if (speed == B75)		printf("75 baud\n");
	else if (speed == B110)		printf("110 baud\n");
	else if (speed == B134)		printf("134 baud\n");
	else if (speed == B150)		printf("150 baud\n");
	else if (speed == B200)		printf("200 baud\n");
	else if (speed == B300)		printf("300 baud\n");
	else if (speed == B600)		printf("600 baud\n");
	else if (speed == B1200)	printf("1200 baud\n");
	else if (speed == B1800)	printf("1800 baud\n");
	else if (speed == B2400)	printf("2400 baud\n");
	else if (speed == B4800)	printf("4800 baud\n");
	else if (speed == B9600)	printf("9600 baud\n");
	else if (speed == B19200)	printf("19200 baud\n");
	else if (speed == B38400)	printf("38400 baud\n");
	else				printf("unknown speed\n");

	speed = cfgetospeed(&term);
	printf("tty line output speed is ");

	if      (speed == B50)		printf("50 baud\n");
	else if (speed == B75)		printf("75 baud\n");
	else if (speed == B110)		printf("110 baud\n");
	else if (speed == B134)		printf("134 baud\n");
	else if (speed == B150)		printf("150 baud\n");
	else if (speed == B200)		printf("200 baud\n");
	else if (speed == B300)		printf("300 baud\n");
	else if (speed == B600)		printf("600 baud\n");
	else if (speed == B1200)	printf("1200 baud\n");
	else if (speed == B1800)	printf("1800 baud\n");
	else if (speed == B2400)	printf("2400 baud\n");
	else if (speed == B4800)	printf("4800 baud\n");
	else if (speed == B9600)	printf("9600 baud\n");
	else if (speed == B19200)	printf("19200 baud\n");
	else if (speed == B38400)	printf("38400 baud\n");
	else				printf("unknown speed\n");

	exit(EXIT_SUCCESS);
}
