/*	xc.h -- header  file for XC
	This file uses 4-character tabstops
*/

/* Local preferences and modems */

/*	CAPTFILE
	This is the default name given to the capture buffer in terminal mode (and
	during script processing). You can always reset this while running the
	program.
*/
#define	CAPTFILE "capture.log"	/* Default capture file */

/*	LIBDIR
	This is the default name given to a directory where PHFILE, STARTUP, and
	any XC scripts might be found. XC will search for such files
		1st) in a path in a colon-separated list of directories in
			 XC_PATH, if such an environment variable exists,
		2nd) in the current directory,
		3rd) in your HOME directory, if HOME is an environment variable,
		4th) in LIBDIR.
*/
/* #define LIBDIR "/usr/lib/xc"	/* System wide storage of dot-files */
/* author's preference */
#define LIBDIR "/usr/local/lib/xc"

/*	PHFILE
	This is the default name given to the dialing directory.
*/
#define PHFILE ".phonelist"		/* Default phonelist file */

/*	STARTUP
	This is the default name of the startup script for XC. If this file is
	found it will be executed immediately on XC startup.
*/
#define STARTUP ".xc"			/* XC Startup Script */

/*	DIALSTR
	A format string to send a telephone number to the modem with the
	appropriate dialing command.
*/
#define DIALSTR "ATDP%s\r"		/* printf format for modem dial command */
/*#define DIALSTR "AAATDT%s\r"	/* printf format for older Telebits */

/* DTR_DROPS_CARRIER
	On some (most?) modems, dropping the DTR signal will instruct the modem
	to disconnect the phone line. On most (some?) Unix systems, setting a
	bit/second rate of 0 will drop carrier.

	If either of these conditions do NOT apply to your setup, set this value to
	0 and an alternate hangup function will be used. This alternate function
	sends the modem the ATTEN string, waits a few seconds, and then sends the
	HANGUP string, so check if those are correct for your modem.
*/
#define	DTR_DROPS_CARRIER	0	/* 1 if dropping DTR drops carrier */
#if !DTR_DROPS_CARRIER			/* If not, then we need the next two defines */
# define ATTEN "+++"			/* Modem "attention" signal */
# define HANGUP "ATH\r"			/* Modem "hang up" command */
#endif

/* Local Unix peculiarities */

/*	strchr and strrchr vs. index and rindex
	Some Berkely and Xenix systems have index() and rindex() which are
	functionally identical to the more standard strchr() and strrchr()
	functions. Include these defines if your Unix supports index and
	rindex INSTEAD of strchr and strrchr.
*/
/* #define strchr	index	/**/
/* #define strrchr	rindex	/**/

/*	DUP2
	dup2() is not included with all versions of Unix. If your implementation
	does not have dup2() (or if you are just not sure), define this as 0 and a
	functional equivalent will be included in the source code.
*/
#define DUP2	0			/* 0 if dup2() not available */

/*	STRSTR
	The draft Ansi C standard specifies the "strstr" function to return the
	position of a substring within a string. This is NOT included in many Unix
	systems, so code for this function is included unless you define this as 1.
*/
#define	STRSTR	1			/* 0 if strstr() not available */

/*	MEMSET
	This function is not on earlier implementations of Unix. Define this as 0
	if you don't have it; making it 1 will not include our equivalent code.
*/
#define MEMSET	0			/* 0 if memset() not available */

/*	STRDUP
	Again, a function not present on earlier versions of Unix, and again,
	defining this as 0 will thereby include our functional equivalent.
*/
#define STRDUP	0			/* 0 if strdup() not available */


/* The reader is kindly invited to leave the rest of this just as it is! */

#define SOH		0x1		/* ^A */
#define ETX		0x3		/* ^C */
#define EOT		0x4		/* ^D */
#define ENQ		0x5		/* ^E */
#define ACK		0x6		/* ^F */
#define DLE		0x10	/* ^P */
#define XON		0x11	/* ^Q */
#define XOFF	0x13	/* ^S */
#define NAK	 	0x15	/* ^U */
#define CAN		0x18	/* ^X */

#ifndef TRUE
# define TRUE	1
# define FALSE	0
#endif
# define SUCCESS	1
# define FAILURE	0

#define NEWMODE	0
#define SIGMODE	1
#define OLDMODE	2

#ifdef toupper
#undef toupper
#undef tolower
#endif

#define SM_BUFF	 256
#define LG_BUFF 2048
#define S		show(1,Msg)
#define S0(x)	show(0,x)
#define S1(x)	show(1,x)
#define S2(x)	show(2,x)

/*	I prefer this NIL macro to present a NIL pointer than most other
	variations that I have seen (eg, NULL, 0, or (cast) 0.
	Comme ci, comme ca. - larry gensch
*/
#ifndef NIL
#define	NIL(type)	(type *) 0
#endif

#ifdef DEBUG
# define fprintf Fprintf
# define fputc Fputc
# define fputs Fputs
#endif

/* globals in three or more files */

extern int	CO, LI, bitmask, my_escape, beep(), hangup(), cbaud;
extern short	capture, cismode, flowflag, linkflag, reterm;
extern char captfile[], ddsname[], phonefile[], *mport(), word[], *wptr,
			line[], Msg[], *lptr, Name[], *getenv(), *strstr(), *strcat(),
			*strncat(), *strcpy(),*strncpy(), *strchr(), *strrchr(), *strdup(),
			*unctrl();
extern unsigned mrate(), sleep();
extern unsigned char BS, LK;
extern unsigned short getuid(), getgid(), geteuid(), getegid();
extern void	cls(), cur_on(), cur_off(), default_bindings(), do_script(),
			drawline(), exit(), free(), getline(), getword(), mode(),
			lc_word(), msecs(), purge(), send_mbyte(), send_string(),
			sendbyte(), show(), show_abort(), show_bindings(), ttgoto(),
			xc_setflow();
extern FILE *tfp,			/* the local terminal */
			*openfile(), *QueryCreate();
extern struct termio oldmode, newmode, sigmode;

typedef enum {
    ENDCHAR = 128,		/* Higher than any valid keyboard code */
    CAPTYES,
    CAPTEND,
    DIVCHAR,
    DIALCHR,
    HUPCHAR,
    SCRPCHR,
    BRKCHAR,
    HLPCHAR,
    QUITCHR,
    EMITSTR,
    DOSCRPT,
    BADFUNC = 0
} bindfunc_t;
