/*	xcterm.c -- terminal modemodule for XC
	This file uses 4-character tabstops
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <signal.h>
#include <setjmp.h>
#include <termio.h>
#include "xc.h"

#define ENDCHAR	(('X' & 0x1f) + 128)	/* Exit terminal mode */
#define CAPTYES	(('Y' & 0x1f) + 128)	/* Open capture file */
#define CAPTEND	(('N' & 0x1f) + 128)	/* Close capture file */
#define DIVCHAR	(('F' & 0x1f) + 128)	/* Send file through modem */
#define DIALCHR	(('D' & 0x1f) + 128)	/* Dial from phonelist */
#define HUPCHAR	(('H' & 0x1f) + 128)	/* Hang up modem */
#define SCRPCHR	(('S' & 0x1f) + 128)	/* Execute script file */
#define BRKCHAR	(('B' & 0x1f) + 128)	/* modem BREAK character */
#define QUITCHR	(('Q' & 0x1f) + 128)	/* close and leave XC */

char captfile[SM_BUFF] = CAPTFILE,	/* capture file's name */
	 phonefile[SM_BUFF] = PHFILE;	/* phone number file's name */

FILE	*cfp;				/* capture file pointer */
static FILE	*fp;			/* file to transmit */

static	int	child_pid;		/* ID of child process */
static	short doneyet_dd;
static	jmp_buf rtm, stop;
static	void (*oldvec)();
char	ddsname[SM_BUFF];
short	s_flag, capture = FALSE;

extern char *strstr();
extern short autoflag, hdplxflag, nlmode;

/*  start capturing */
static void capt_on()
{
	if (capture)
		sprintf(Msg, "Already capturing to \"%s\"", captfile);
	else {
		if ((cfp = fopen(captfile, "a")) == NULLF)
			sprintf(Msg,"Can't open \"%s\" for capturing",captfile);
		else {
			capture = TRUE;
			sprintf(Msg,"Capturing to \"%s\"",captfile);
			setbuf(cfp, NULLS);
		}
	}
	S2(Msg);

	signal(SIGUSR1, capt_on);	/* set signal for next capt_on */
}

/*  stop capturing */
static void capt_off()
{
	if (!capture)
		sprintf(Msg,"Sorry, we haven't been capturing lately");
	if (capture){
		fclose(cfp);
		capture = FALSE;
		sprintf(Msg,"\"%s\" closed for capturing",captfile);
	}
	S2(Msg);

	signal(SIGUSR2, capt_off);	/* set signal for next capt_off */
}

/*	cleanup, flush and exit */
static void cleanup()
{
	if (capture){
		fclose(cfp);
		sprintf(Msg,"\"%s\" closed for capturing",captfile);
		S2(Msg);
	}

	exit(0);
}

static void cisbmode()
{
	cismode = 2;
	signal(SIGCLD, SIG_IGN);
	longjmp(rtm,1);
}

static void end_divert()
{
	show_abort();
	fclose(fp);
	signal(SIGINT, oldvec);
	longjmp(stop,1);
}

/*	Divert file into input stream, with delay after each newline. */
void divert(script)
short script;
{
	int c;
	long i = 0;

	if (!script){
		fputc('\t',tfp);
		show(-1,"File?");
		getline();
		getword();
	}
	if (word[0] == '\0')
		return;
	if ((fp = fopen(word, "r")) == NULLF){
		sprintf(Msg,"Can't access '%s'",word);
		S2(Msg);
		return;
	}

	oldvec = signal(SIGINT,end_divert);
	if (setjmp(stop))
		return;

	while ((c = getc(fp)) != EOF){
		if (c != '\n'){
			send_mbyte(c);
			i++;
		}
		else {
			i = (CBAUD-cbaud)*80 + 4*i + 50; /* season to taste... */
			send_mbyte(nlmode ? '\r' : '\n');
			if (script)
				k_waitfor(-i, "");
			else
				msecs(i);
			i = 0;
		}
	}
	fclose(fp);
	signal(SIGINT,oldvec);
}

/*	Select a script file. */
static get_script()
{
	fputc('\t',tfp);
	show(-1,"Enter script file:");
	getline();
	if (line[0] == '\0'){
		fputc('\r',tfp),
		fputc('\n',tfp);
		S1("Script file not specified");
		return FAILURE;
	}
	linkflag = FALSE;
	getword();
	sprintf(ddsname,"%s",word);
	return SUCCESS;
}

static getconchr()
{
	int c, tc;

	if ((c = fgetc(stdin)) == MY_ESC){
		switch (c = ((tc = fgetc(stdin)) & 0x1f) + 128){
		case ENDCHAR:
		case CAPTYES:
		case CAPTEND:
		case BRKCHAR:
		case DIVCHAR:
		case DIALCHR:
		case HUPCHAR:
		case SCRPCHR:
		case QUITCHR:
			break;

		default:
			c = tc;
		}
	}
	return c;
}

void terminal(todir)
short todir;
{
	register c;

	doneyet_dd = FALSE;
	isig(FALSE);
Reterm:
	if (setjmp(rtm) || doneyet_dd)
		return;

	s_flag = FALSE;		/* reset scripting flag */

	if (!todir)
		S1("Entering Terminal Mode");
	/* split into read and write processes */
	if ((child_pid = forkem()) == 0){
		/* child, read proc: read from port and write to tty */
		cfp = NULLF;
		if (autoflag && !todir)
			capt_on();
		signal(SIGUSR1, capt_on);
		signal(SIGUSR2, capt_off);
		signal(SIGTERM, cleanup);

		/*
		newmode.c_oflag = 0;
		isig(FALSE);
		*/

		while (1){
			while ((c = read_mbyte(0)) == -1)
				;
			if (cismode && c == ENQ)
				cleanup();

			fputc(c,tfp);

			if (capture && c != '\r')
				fputc(c,cfp);
		}
		/*NOTREACHED*/
	}
	/* parent, write proc: read from tty and write to port */
	signal(SIGCLD, cisbmode);

	if (todir) goto dialdir;
	do {
		switch (c = getconchr()){
		case CAPTYES:		/* signal child to open capture file */
			kill(child_pid, SIGUSR1);
			break;

		case CAPTEND:		/* signal child to close capture file */
			kill(child_pid, SIGUSR2);
			break;

		case DIVCHAR:		/* divert a file through modem port */
			isig(TRUE);
			divert(FALSE);
			isig(FALSE);
			break;
	
		case BRKCHAR:
			xmitbrk();
			break;

		case SCRPCHR:		/* execute a script file */
			if (get_script()==FAILURE)
				break;
			s_flag = TRUE;
			goto filicide;

		case DIALCHR:		/* select and dial a phone number */
dialdir:
			doneyet_dd = TRUE;
			if ((dial_dir()==FAILURE && todir) || s_flag)
				goto filicide;
			break;

		case ENDCHAR:		/* signal child to cleanup and exit */
filicide:
			c = ENDCHAR;
			signal(SIGCLD, SIG_IGN);
			kill(child_pid, SIGTERM);
			break;
		
		case QUITCHR:
			signal(SIGCLD, SIG_IGN);
			kill(child_pid, SIGTERM);
			s_exit();
			break;

		case HUPCHAR:		/* Hangup */
			hangup();
			break;

		case '\n':		/* See if NL translation in effect */
			if (nlmode)
				c = '\r';

		default:	/* just send the character to the port */
			send_mbyte(c);
			if (hdplxflag)
				fputc(c,tfp);
			break;
		}
		todir = FALSE;
	} while (c != ENDCHAR);

	while (wait((int *) 0) >= 0)	/* wait for the read process to die */
		;

	if (s_flag){
		do_script(ddsname);
		goto Reterm;
	}

	reterm = FALSE;
}
