/*
** default news poster
** If talking to an NNTP server, and there is a %s in this somewhere,
** the machine will be substituted at runtime
**
** LOC_POST only applies for NNTP.  It is the poster used in conjunction
** with the +l option or NULL for DEF_MACHINE, ie. when you are reading
** the local files directly instead of through NNTP.
*/
#define DEF_POST "/usr/lib/news/inews -h"
#define LOC_POST "/usr/lib/news/inews -h"

/*
** DEF_MACHINE
**
** this will affect only NNTP versions, and will have to differ from
** site to site.  shipped commented out so that you will be forced to set it
**
** NULL or empty string will result in direct reading of the local files
** rather than NNTP.
#define DEF_MACHINE "rtech"
*/

/*
** SHOW_FROM applies only to NNTP.  If defined, a FROM line will be
** placed in the user's file when posting followups.  FROM_CR_FORM
** is the format used for the From line, with arguments corresponding
** to the "From: " header, the user name, the machine name and the user's
** "gecos" string, in that order.
**
** This is distributed turned off, since the feature may encourage
** userid forgery.  If turned off, vn will prepend the user's article
** with the FROM line instead, effectively preventing the user from
** specifying one.  In the non-NNTP case, inews runs as the user,
** and constructs a FROM line if the user didn't
**
** If SHOW_FROM is not defined, REPLY_CR_FORM may be defined, which shows
** the user a "Reply-to" line to edit into a more appropriate mail reply path.
** If defined, REPLY_CR_FORM is the format used for the line with arguments
** corresponding to the "Reply-to: " header, the user name, and the machine
** name, in that order.
**
** An important point is that since the _FORM strings have the header as one
** of their arguments, they had better begin with "%s" to work right.
**
** The machine placed into these lines is the HOST machine, usually.
** If FROM_REAL is defined, the actual machine the user is logged into
** is used instead.  Using the host works well locally, since our news
** gateway also functions as a mail gateway.  If you ALSO define MACH_CONCAT,
** the machine placed into the from line will be <host>!<real>.  Using
** either of these alternatives may lead to problems since you are then
** displaying your internal machine names to the outside world, and the
** names are very likely conflict with some net site or another.
#define FROM_REAL
#define MACH_CONCAT
#define SHOW_FROM
#define REPLY_CR_FORM "%s%s@%s.UUCP"
*/
#define FROM_CR_FORM "%s%s@%s.UUCP (%s)"

/*
** default user .newsrc file
*/
#define DEF_NEWSRC ".newsrc"

/*
** If INLETTER is defined, the address line will be placed into the
** file editted by the user, and the mailer is assumed smart enough
** to understand about header lines in the file.  Otherwise the
** address is part of the mailer's command line.
**
** if MAILSMART is defined, The From: line will be used for mail replies,
** or overridden by a "Reply-to:" line if present - "Path:" will be used
** as a last resort.  If MAILSMART is not defined, "Path:" will simply be
** used.
**
** if MAILCHOOSE is defined, the user is prompted before edit with all
** of the address lines to choose from, or to input a new one.  MAILCHOOSE
** makes MAILSMART irrelevant, but the two are independent of INLETTER.
**
#define MAILCHOOSE
*/
#define MAILSMART
#define INLETTER

/*
** default mail sender.  If INLETTER, will be done as
** cat <file> | DEF_MAIL,  Otherwise, cat <file> | DEF_MAIL <address>
** user's MAILER variable will have to conform, too.
*/
#ifdef INLETTER
#define DEF_MAIL "/usr/lib/sendmail -t"
#else
#define DEF_MAIL "/bin/mail"
#endif

/*
** OLDRC defined for an apparently earlier news version which took unnamed
** command line options as synonyms for -n, and did not take ranges in
** the .newsrc file.  Probably useless, but kept in for historical reasons.
**
**#define OLDRC
*/

/*
** article spool directory
*/
#define SPOOLDIR "/usr/spool/news"

/*
** active file
*/
#define ACTFILE "/usr/lib/news/active"

/*
** maximum number of option lines in .newsrc
*/
#define OPTLINES 60

/*
** maximum number of filter options
*/
#define NUMFILTER 30

/*
** maximum number of file lines to search looking for header lines.
*/
#define HDR_LINES 36

/*
** When a newsgroup is scanned, we ignore articles less than <high spool> -
** MAXARTRANGE.  This is intended to prevent ridiculous numbers of article
** opening attempts the first time a user reads a new newsgroup which has a
** huge difference between the high and low spool numbers, perhaps due to
** some articles not getting expired.
*/
#define MAXARTRANGE 1600	/* about 2 weeks of soc.singles */

/*
** If we detect that the user has a higher number in .newsrc than the
** high article number, obviously the active file is out of synch with the
** .newsrc.  We set the user's number back to the low article number in
** this case, on the theory that it's better to repeat stuff than miss
** articles.  On such setbacks, we won't backdate the user by more than
** SYN_SETBACK articles, preventing floods of articles on large newsgroups
** if you don't define SYN_CHECK, the user's number won't be adjusted in
** this case, choosing to lose articles rather than show old ones.
*/
#define SYN_CHECK
#define SYN_SETBACK 60

/*
** Normally, unrecognized newsgroup names are silently removed from the
** user's .newsrc
**
** if KEEP_UNK is defined, unknown newsgroups will be left alone in
** the users .newsrc.  This is intended to allow the same .newsrc
** to be used against servers on different NNTP installations.  Of course,
** it works only if newsgroup names are unique across installations.
** Essentially, this is a hack for our local situation, which may come
** in handy for somebody else.  If this is defined, users will have to
** edit out bogus newsgroup names in their own .newsrc's if they wish
** to keep it accurate.
#define KEEP_UNK
*/
