/*

       @(#) FILE:	uutraf.h
       @(#) Release:	1.2
       @(#) Rel. Date:	2/2/90
       @(#) Author:     Greg Hackney (hack@texbell.swbt.com)

*/

#include <stdio.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
char *strtok();


/* these defines are part of the sort routine to figure out how
 * to sort the linked list 
 */
#define REVERSE  0x0001  /* reverse the order, least to most */
#define RECEIVED 0x0002  /* sort by received */
#define XMIT     0x0004  /* sort by xmit */
#define R_TIME   0x0010  /* sort by received time */
#define X_TIME   0x0020  /* sort by xmit time */
#define R_CPS    0x0100  /* sort by characters RECEIVED per second */
#define X_CPS    0x0200  /* sort by characters TRANSMITTED per second */
#define R_NUMB   0x1000  /* sort by number of RECEIVED transactions */
#define X_NUMB   0x2000  /* sort by number of TRANSMITTED transactions */

#ifdef BSD
#define OUT	"sent"
#define IN	"received"
#else		/* Most other BNU systems */
#define OUT	"->"  /*uucp flow direction indicator*/
#define IN	"<-"  /*uucp flow direction indicator*/
#endif

#ifdef pyr	/* UUCP via TCP/IP on an ATT Pyramid */
#define T_OUT	"t->"  /* t protocol outgoing */
#define T_IN	"t<-"  /* t protocol incoming */
#define F_OUT	"f->"  /* f protocol outgoing */
#define F_IN	"f<-"  /* f protocol incoming */
#endif

typedef struct link {
	struct link *prev;	/* pointer to the previous entry */
	struct link *next;	/* pointer to the next entry */
	float recv;		/* num of bytes rec'd from remote system */
	float recv_time; 	/* total seconds spent in receive */
	long recv_cnt;		/* total number of files received */
	float xmit;		/* num of bytes sent to remote system */
	float xmit_time; 	/* total seconds spent in transmit */
	long xmit_cnt;		/* total number of files sent */
	char sysname[10];	/* name of remote system org by 1, thw */
} LINK;


static
FILE	*logfile = (FILE *) NULL;  /* file pointer to the xferstats file */

static
LINK *record = (LINK *) NULL, *getslot();

static
char	*sys,		/* holds the name of the previous remote node name */
	flow[10],	/* holds the direction of uucp flow */
	buf[512],	/* general purpose */
	*string;	/* general purpose */

static
float	bytes,		/* number of bytes in the uucp xfer */
	seconds;	/* number of seconds the xfer took */

char	*malloc(), *optarg;
int optind;

char usage[]="\n\
-s       use standard input instead of default xferstats file\n\
-b[rxb]  sort by total bytes rec'd, xmit'ed, or both\n\
-c[rxb]  sort by chars per second rec'd, xmit'ed, or both\n\
-n[rxb]  sort by # of files rec'd, xmit'ed, or both\n\
-t[rxb]  sort by total clock time in rec, xmit, or both\n\
-a       sort in ascending vs. descending order\n";
