/*

       @(#) FILE:	uutraf.c
       @(#) Release:	1.2
       @(#) Rel. Date:	2/2/90
       @(#) Author:     Greg Hackney (hack@texbell.swbt.com)

*/

#ifdef SCCSID
static char sccsid[] = "@(#) file uutraf.c : rel 1.2 : mod 2/2/90";
#endif

#include "uutraf.h"
#include "defs.h"

static char
Log_name[1024]=STATFILE; /* name of uucp logging file, see defs.h */

static
float	bytes_recv, /* total bytes received */
	bytes_xmit, /* total bytes transmitted */
	sec_recv,  /* total seconds spent in receive */
	sec_xmit;  /* total seconds spent in transmit */

static
long
	num_recv,   /* total number of files received */
	num_xmit;   /* total number of files transmitted */

main(argc, argv)
int argc;
char *argv[];
{
	int how = 0;         /* default sort method, see defs.h  */
	register LINK *slot; /* pointer to element               */
	float bytes,	     /* number of bytes in the uucp xfer */
    	seconds;             /* number of seconds the xfer took  */
	int c;


	/*Check for options*/
	while(( c = getopt(argc,argv, "ab:c:n:t:s")) != EOF){
		switch(c) {
		case 'a':   /* sort in ascending vs. descending order */
			how |= REVERSE;
			break;
		case 'b':   /* sort by bytes xmitted and/or received */
			switch(*optarg) {
			case 'b':
				how |= (RECEIVED | XMIT);
				break;
			case 'r':
				how |= RECEIVED;
				break;
			case 'x':
				how |= XMIT;
				break;
			default:
				usage_err(argv[0]);
				break;
			}
			break;
		case 'c':   /* sort by xfer rate xmitted and/or received */
			switch(*optarg) {
			case 'b':
				how |= (R_CPS | X_CPS);
				break;
			case 'r':
				how |= R_CPS;
				break;
			case 'x':
				how |= X_CPS;
				break;
			default:
				usage_err(argv[0]);
				break;
			}
			break;
		case 'n':   /* number of transactions */
			switch(*optarg) {
			case 'b':
				how |= (R_NUMB | X_NUMB);
				break;
			case 'r':
				how |= R_NUMB;
				break;
			case 'x':
				how |= X_NUMB;
				break;
			default:
				usage_err(argv[0]);
				break;
			}
			break;
		case 't':   /* sort by clock time */
			switch(*optarg) {
			case 'b':
				how |= (R_TIME | X_TIME);
				break;
			case 'r':
				how |= R_TIME;
				break;
			case 'x':
				how |= X_TIME;
				break;
			default:
				usage_err(argv[0]);
				break;
			}
			break;
		case 's':   /* Use stdin instead of normal xferstat file */
			logfile = stdin;
			break;
		default:
			usage_err(argv[0]);
			break;
		}
	}

	/* Use default sorting method if none was chosen */
	if ((how == REVERSE) || !how)
		how |= DEFAULT;

	if(argc != optind) {	/*input from an optional file name*/
		if((argc - optind) > 1) /*more than 1 file*/
			usage_err(argv[0]);
		if(logfile != (FILE *)NULL) /* If stdin was already specified */
			usage_err(argv[0]);
		strcpy(Log_name, argv[--argc]);
		if((strcmp(Log_name,"-"))==0)
			logfile=stdin;
		}
	else {
		if(logfile == (FILE *)NULL)
			strcpy(Log_name,STATFILE);
		}
		
	/* See if specified file can be read */
	if (logfile == (FILE *) NULL){ /* not stdin */
		if((logfile=fopen(Log_name, "r"))==NULL){
			fprintf(stderr,"%s: Can't open the xferstat file %s for reading\n",argv[0],Log_name);
			exit(1);
			}
	}
	/* initialize the linked list */
	record = (LINK *) NULL;

	while (fgets(buf, 512, logfile) != NULL) {

		/* look for the node name */

#ifdef BSD
		if (((sys = strtok(buf, " ")) == NULL) ||
		    ((sys = strtok((char *)NULL, " ")) == NULL)){
#else
		if ((sys = strtok(buf, "!")) == NULL) {
#endif
			continue;
		}

		/* skip over unnecessary data */
#ifdef BSD
		if (((string = strtok((char *) NULL, " ")) == NULL) ||
		    ((string = strtok((char *) NULL, " ")) == NULL)) {
#else
		if ((string = strtok((char *) NULL, "]")) == NULL) {
#endif
			continue;
		}

		/* parse the remainder of the data string */
		if ((string = strtok((char *) NULL, "\n")) == NULL) {
			continue;
		}

		/* convert the information */
#ifdef BSD
		if (sscanf(string, "%s data %f bytes %f secs",
#else
		if (sscanf(string, "%s %f / %f",
#endif
		    flow, &bytes, &seconds) == EOF) {
			continue;
		}

		/* see if it's outgoing uucp */
#ifdef pyr
		if ((strcmp(flow, OUT) == 0) ||
		(strcmp(flow, T_OUT) == 0) ||
		(strcmp(flow, F_OUT) == 0)) {
#else
		if (strcmp(flow, OUT) == 0) { 
#endif
			/* assign an array slot for this node name */
			if ((slot = getslot(sys)) == (LINK *) NULL) {
				exit(1);
			}
			slot->xmit += bytes;
			slot->xmit_time += seconds;
			slot->xmit_cnt++;
			bytes_xmit += bytes; /* summary totals */
			sec_xmit += seconds;
			num_xmit++;
		} else if /* incoming uucp */
#ifdef pyr
			((strcmp(flow, IN) == 0) ||
			(strcmp(flow, T_IN) == 0) ||
			(strcmp(flow, F_IN) == 0)) { 
#else
			(strcmp(flow, IN) == 0) { 
#endif
			/* assign an array slot for this node name */
			if ((slot = getslot(sys)) == (LINK *) NULL) {
				exit(1);
			}
			slot->recv += bytes;
			slot->recv_time += seconds;
			slot->recv_cnt++;
			bytes_recv += bytes; /* summary totals */
			sec_recv += seconds;
			num_recv++;
		}
	}
	if (record != (LINK *) NULL)    /* if we got some data */
		sortrun(how);	/* sort it */
	printrun();	/* print it out */
	fclose(logfile);
	exit(0);
}

static LINK *
getslot(s)   /* returns an link struct to the system name specified. */
char *s;
{
	LINK *work, *last;

	work = record;
	if (work == (LINK *) NULL) { /* must be the first time thru */
		work = (LINK *) malloc(sizeof(LINK) + strlen(s));
		if (work == (LINK *) NULL) {
			perror("getslot() malloc() failed, returning NULL -- ");
			return(work);
		}
		zeroit(work);
		strcpy(work->sysname, s);
		record = work;
		return(work);
	}

	while (work != (LINK *) NULL){
		if (!strcmp(work->sysname, s)) {
			return(work);
		}
		last = work;
		work = work->next;
	}

	/* create a new link */
	if ((work = (LINK *) malloc(sizeof(LINK) + strlen(s))) ==
	    (LINK *) NULL) {
		perror("getslot() malloc() failed, returning NULL -- ");
		return(work);
	}

	zeroit(work);
	last->next = work;
	work->prev = last;
	strcpy(work->sysname, s);
	return(work);
}

static
zeroit(l)
LINK *l;
{
	/* added for portability vs. memset/bzero */
	l->prev		= (LINK *) NULL;
	l->next		= (LINK *) NULL;
	l->recv         = 0.0;
	l->recv_time    = 0.0;
	l->recv_cnt     = 0L;
	l->xmit		= 0.0;
	l->xmit_time    = 0.0;
	l->xmit_cnt     = 0L;
	l->sysname[0]	= '\0';
}

printrun()
{
	LINK *work;
	int count = 0;

	printf("%-8s ", "\nRemote  ");
	printf("%26s ", "-----------K-Bytes-----------");
	printf("%12s ", "----Hours----");
	printf("%10s ", "--Avg CPS--");
	printf("%8s ", "--Files--\n");

	printf("%-7s ", "Host   ");
	printf("%9s ", "Recv");
	printf("%9s ", "Sent");
	printf("%9s ", "Total");
	printf("%6s ", "Recv");
	printf("%6s ", "Sent");
	printf("%5s ", "Recv");
	printf("%5s ", "Sent");
	printf("%4s ", "Recv");
	printf("%4s\n", "Sent");

	printf("%s ", "------  ");
	printf("%s ", "---------");
	printf("%s ", "---------");
	printf("%s ", "---------");
	printf("%s ", "------");
	printf("%s ", "------");
	printf("%s ", "-----");
	printf("%s ", "-----");
	printf("%s ", "----");
	printf("%s\n", "----");

	for (work = record; work != (LINK *) NULL;) {
		count++;
		strncpy(buf, work->sysname, 9);
		buf[9]='\0';
		printf("%-9s", buf);
		sprintf(buf, "%.1f", work->recv / 1000);
		printf("%9s ", buf);
		sprintf(buf, "%.1f", work->xmit / 1000);
		printf("%9s ", buf);
		sprintf(buf, "%.1f", (work->xmit + work->recv) / 1000);
		printf("%9s ", buf);
		sprintf(buf, "%.1f", work->recv_time / 3600);
		printf("%6s ", buf);
		sprintf(buf, "%.1f", work->xmit_time / 3600);
		printf("%6s ", buf);
		if (work->recv_time != 0.0) { /* divide by zero ? */
			sprintf(buf, "%5.0f", work->recv / work->recv_time);
		} else {
			sprintf(buf, "0");
		}
		printf("%5s ", buf);
		if(work->xmit_time != 0.0) { /* divide by zero ? */
			sprintf(buf, "%5.0f", work->xmit / work->xmit_time);
		} else {
			sprintf(buf, "0");
		}
		printf("%5s ", buf);
		printf("%4d ", work->recv_cnt);
		printf("%4d\n", work->xmit_cnt);
		work = work->next;
	}
	/* summary statement at the end */
	printf("\n                   -------------SUMMARY-------------\n");
	printf("                   Total active uucp sites:");
	sprintf(buf,"%d",count); comma_fy();
	printf("%7s\n",buf);

	/* total files */
	printf("                   Total files recv:  ");
	sprintf(buf,"%ld",num_recv); comma_fy();
	printf("%12s\n",buf);
	printf("                   Total files sent:  ");
	sprintf(buf,"%ld",num_xmit); comma_fy();
	printf("%12s\n",buf);
	printf("                   Total files:       ");
	sprintf(buf,"%ld",num_xmit + num_recv); comma_fy();
	printf("%12s\n",buf);

	/* total time */
	printf("                   Total hours recv:    ");
	sprintf(buf,"%.1f",sec_recv / 3600);
	printf("%12s\n",buf);
	printf("                   Total hours sent:    ");
	sprintf(buf,"%.1f",sec_xmit / 3600);
	printf("%12s\n",buf);
	printf("                   Total hours:         ");
	sprintf(buf,"%.1f",(sec_recv + sec_xmit) / 3600);
	printf("%12s\n",buf);

	/* total bytes */
	printf("                   Total K-bytes recv:  ");
	sprintf(buf,"%.0f",bytes_recv / 1000); comma_fy();
	printf("%10s\n",buf);
	printf("                   Total K-bytes sent:  ");
	sprintf(buf,"%.0f",bytes_xmit / 1000); comma_fy();
	printf("%10s\n",buf);
	printf("                   Total K-bytes:       ");
	sprintf(buf,"%.0f",(bytes_xmit + bytes_recv) / 1000); comma_fy();
	printf("%10s\n\n",buf);

}

comma_fy()  /* put commas in long numeric strings contained in buf[] */
{
	int i, ii, cnt;
	char backw[25];

	/* put string backwards inserting commas */
	for(ii=0, cnt=0,i=strlen(buf) - 1; i >= 0 ; i--){
		backw[ii++] = buf[i];
		if(++cnt == 3){
			if(buf[i-1] != '\0')
				backw[ii++] = ',';
			cnt = 0;
		}
	}
	backw[ii] = '\0';

	/* put string forward */
	for(ii=0, cnt=0,i=strlen(backw) - 1; i >= 0 ; i--)
		buf[ii++] = backw[i];
	buf[ii]='\0';

}

sortrun(how) 
unsigned short how;
{
	LINK *work;
	int swapped;

	do {
		for (swapped = 0, work = record; work->next != (LINK *) NULL;) {
			if (do_test(work, work->next, how) < 0) {
				if (work->prev != (LINK *) NULL) {
					work->prev->next = work->next;
				} else {
					record = work->next;
				}
				work->next->prev = work->prev;
				work->prev = work->next;
				if (work->next->next != (LINK *) NULL) {
					work->next->next->prev = work;
				}
				work->next = work->next->next;
				/* this is the weird one */
				/* (work->prev was work->next) */
				work->prev->next = work;
				swapped = 1;
			} else {
				work = work->next;
			}
		}
	} while (swapped);
}

do_test(a, b, how)
LINK *a, *b;
unsigned short how;
{
	LINK *c;
	long aw = 0L, bw = 0L;

	/* reverse the sort, least to most */
	if (how & REVERSE) {
		/* swap the pointers around, faster than a complex if */
		c = a;
		a = b;
		b = c;
	}
	if (how & RECEIVED) {
		aw += a->recv;
		bw += b->recv;
	}
	if (how & XMIT) {
		aw += a->xmit;
		bw += b->xmit;
	}
	if (how & R_TIME) {
		aw += (long) a->recv_time;
		bw += (long) b->recv_time;
	}
	if (how & X_TIME) {
		aw += (long) a->xmit_time;
		bw += (long) b->xmit_time;
	}
	if (how & R_CPS) {
		if (a->recv_time != 0.0) {
			aw += (long) (a->recv / a->recv_time);
		}
		if (b->recv_time != 0.0) {
			bw += (long) (b->recv / b->recv_time);
		}
	}
	if (how & X_CPS) {
		if (a->xmit_time != 0.0) {
			aw += (long) (a->xmit / a->xmit_time);
		}
		if (b->xmit_time != 0.0) {
			bw += (long) (b->xmit / b->xmit_time);
		}
	}
	if (how & R_NUMB) {
		aw += a->recv_cnt;
		bw += b->recv_cnt;
	}
	if (how & X_NUMB) {
		aw += a->xmit_cnt;
		bw += b->xmit_cnt;
	}
	return(aw - bw);
}
usage_err(arg0)
char *arg0;
{
	fprintf(stderr,"Usage: %s [options] [xferstat_file | -]\n", arg0);
	fprintf(stderr,"%s\n",usage);
	exit(1);
}
