/*  File   : strtok.c
    Original Author : Richard A. O'Keefe.
    Dated: 11 April 1984
    Public domain

       @(#) FILE:	strtok.c
       @(#) Release:	1.1
       @(#) Rel. Date:	2/2/90
       @(#) By:     Greg Hackney (hack@texbell.swbt.com)

*/

#ifdef SCCSID
static char sccsid[] = "@(#) file strtok.c : rel 1.1 : mod 2/2/90";
#endif


static	char	*oldSrc = "";
int  _set_ctr = 127;
char _set_vec[128];

#ifdef BSD
char *strtok(src, set)
    register char *src;
    char *set;
    {
	char *save;

	_str2set(set);
	if (src == (char *)0) src = oldSrc;
	while (_set_vec[*src] == _set_ctr) src++;
	if (!*src) return (char *)0;
	save = src;
	while (_set_vec[*++src] != _set_ctr) ;
	*src++ = 0;
	oldSrc = src;
	return save;
    }

_str2set(set)
    register char *set;
    {
	if (set == (char *)0) return;
	if (++_set_ctr == 128) {
	    _set_ctr = 1;
	}
	while (*set) _set_vec[*set++] = _set_ctr;
    }
#endif

