/******************************************************************************
 * $Id: procsite.c,v 1.4 92/08/10 01:03:41 romel Exp Locker: romel $
 * Name:	ProcessSite
 * Proj:	uustat
 * Desc:	Searches for control files for the given system and calls
 *		ProcessCfile to perform the action specified by the given flags
 * Synop:	int ProcessSite (char * system, uuflags * uflags)
 * Entry:	system: the name of the current system
 *		uflags: struct containing the options given on the command line
 * Exit:	0 if successful, non-zero if not
 * Notes:	This function loops until all control files for the given system
 *		have been processed.
 * $Log:	procsite.c,v $
 * Revision 1.4  92/08/10  01:03:41  romel
 * fixed alignment problem with -q option
 * 
 * Revision 1.3  92/08/05  17:00:49  romel
 * Added changes for -q option
 * 
 * Revision 1.2  92/08/05  01:38:18  romel
 * minor changes
 * 
 * Revision 1.1  92/08/04  16:58:26  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include "uustat.h"


int ProcessSite (system, uflags)
char * system;
uuflags * uflags;
	{
	int ret, nCtrlFiles = 0;
	int nFileAge = 0;
	char * file;
	
	/* loop until no more control files are found */
	while ((file = GetCfile (system)) != NULL)
		{
		/* if file is not a control file, skip to next file */
		if (!IsCtrlFile (file))
			{ /* file is not a valid control file */
			continue;
			}
			
		/*
		*	check for -q option.  if so, count number of jobs for this
		*	system, and find the oldest file
		*	if not -q, call ProcessCfile to either display, kill or
		*	rejuvinate the file.
		*/	
		if (uflags->fq)
			{ /* count the control files and find oldest */
			int age;
			
			nCtrlFiles++;
			age = GetFileAge (file);
			if (age > nFileAge)
				nFileAge = age;
			} /* if uflags->fq */
		else
			{		
			/* call ProcessCfile to perform the action */	
			ret = ProcessCfile (system, uflags, file);
			/* return any errors */
			if (ret)
				{
				return ret;
				}
			} /* else -- if uflags->fq */
		} /* while */

	/*
	*	if processing -q option, display stats for the system, otherwise,
	*	just exit
	*/
	if (uflags->fq)
		{
		char szCurStat[40];
		char szCurDate[20];
		int ret;

		/* get info from the system's log file */
		ret = GetCurLogStatus (system, szCurStat, szCurDate);

		/* display */
		printf ("%-10s", system);

		/* if control files are present, display */
		if (nCtrlFiles)
			{
			printf (" %4dC", nCtrlFiles);
			if (nFileAge > 1)
				{
				printf ("(%d)", nFileAge);

				/* now align rest of line */
				printf ("    ");	
				if (nFileAge < 100)
					printf (" ");	
				if (nFileAge < 10)
					printf (" ");	
				} /* if nFileAge */
			else
				printf ("         ");	
			} /* if nCntrlFiles */	
		else
			/* fill up the space on the display line */
			printf ("               ");	
			
		/* if log file is not empty, display stats */
		if (!ret)
			{
			if ((*szCurDate == '\0')	|| (*szCurStat == '\0'))
				printf ("Empty log file\n");
			else	
				printf ("%s %s\n", szCurDate, szCurStat);	
			} /* if !ret */
		else
			{ /* log file is empty */
			printf ("**** Log File is Empty ****\n");
			}
		} /* if uflags->fq */
		
	return 0;	
	} /* ProcessSite  */



#ifdef TEST
#include <stdio.h>



main ()
	{
	}


#endif
