/******************************************************************************
 * $Id: perfact.c,v 1.1 92/08/04 16:57:56 romel Exp Locker: romel $
 * Name:	PerformAction
 * Proj:	uustat
 * Desc:	Perform action on a job.  Action is to kill the job or rejuvinate it.
 *		A job can consist of more than one file, but the control ('C.')
 *		file contains the names of all the files (in field 6).  
 *		The action to be performed on the file (and all it's related files)
 *		is given in the fields of the uflags structure.
 * Synop:	int PerformAction (char * system, char * file, uuflags * uflags)
 * Entry:	system: the name of the system
 *		file: the name of the file to perform the action on
 *		uflags: structure containing the options flags
 * Exit:	0 if successful, -1 if not.
 * Notes:	None
 * $Log:	perfact.c,v $
 * Revision 1.1  92/08/04  16:57:56  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include "uustat.h"


int PerformAction (system, file, uflags)
char * system;
char * file;
uuflags * uflags;
	{
	FILE * fp;
	static char line[LLEN+1], tmp[LLEN+1];
	char * dfile;

	/* open the control file */
	fp = fopen (file, "r");
	if (fp == NULL)
		{ /* error opening file */
		return -1;
		}	

	/* 
	   process the data files related to the job -- there is one
	   file per line in the control file.  the filename is contained in
	   field 6.  If the name in field 6 is "D.0" or "dummy", then no 
	   action is taken on that filename (it means the file is a user 
	   file or is non-existent).

	   at this point, the action is either to kill the job or rejuvinate it.
	   the possibility of conflicting options (i.e. both options given) has
	   been taken care of in main().
	*/   
	while (fgets (line, LLEN, fp) != NULL)
		{
		/* get the data file name */
		dfile = GetField (line, 6);

		/* process it */
		if ((!strncmp (dfile, "D.0", 3)) || (!strncmp (dfile, "dummy", 5)))
			/* it's a dummy file so do nothing */
			continue;
			
		else if (uflags->fkill)
			{
			makeuupath (tmp, system, dfile);
			if (unlink (tmp) == -1)
				return -1;
			}
		else if (uflags->frejuv)
			{
			makeuupath (tmp, system, dfile);
			if (TouchFile (tmp) == -1)
				return -1;
			}
		else
			/* flags are wrong, return with error */
			return -1;	
		} /* while */
		
	/* now process the control file */
	if (uflags->fkill)
		{ /* kill the file */
		char *p;
		
		/* if user is root and is not the owner of the file */
		rewind (fp);
		p = GetSender (fp);
		fclose (fp);
		if (unlink (file) == -1)
			return -1;
		if (strcmp (p, GetUname()))
			{ /* user doesn't own the file */
			/* if user is root, mail owner that job was deleted */
			if (getuid() == 0 || !strcmp ("uucp", GetELogName()))
				MailUser(p, file);
			}
		}	
	else if (uflags->frejuv)
		{ /* rejuvinate the file */
		fclose (fp);
		if (TouchFile (file) == -1)
			return -1;
		}
	return 0;	
	} /* PerformAction */
