/******************************************************************************
 * $Id: main.c,v 1.4 92/08/08 01:33:06 romel Exp Locker: romel $
 * Name:	main
 * Proj:	uustat
 * Desc:	main function for uustat.  Parses command line and determines whether
 *		each system should be checked or just one system.
 * Synop:	int main (int argc, char *argv[])
 * Notes:	None
 * $Log:	main.c,v $
 * Revision 1.4  92/08/08  01:33:06  romel
 * fixed return value with -n option
 * 
 * Revision 1.3  92/08/05  17:00:24  romel
 * Added changes for -q option
 * 
 * Revision 1.2  92/08/05  01:34:59  romel
 * new comments
 * 
 * Revision 1.1  92/08/04  16:57:26  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include "uustat.h"




main (argc, argv)
int argc;
char *argv[];
	{
	static uuflags uflags;
	char * system;				/* holds current system name */
	int ret = 0;

	/* initialize some variables */
	memset (uflags, 0, sizeof(uflags));
	uflags.fdispl = TRUE;
	uflags.count = 0;
	
	/* parse options */
	++argv, --argc;
	while (**argv == '-')		/* if the 1st letter is '-', its an option */
		{
		switch ( *((*argv)+1))	/* perform action according to next letter */
			{
			case 'a':
				uflags.fall = TRUE;
				uflags.fuser = FALSE;
				break;
				
			case 'j':
				uflags.fjobs = TRUE;	
				break;
				
			case 'k':
				uflags.fkill = TRUE;
				GetNextArg (uflags.jobid, *(argv)+2, *(argv+1), JOBIDLEN);
				/* if jobid was not given or rejuvinate flag also given,
				abort the program */
				if ((*uflags.jobid == '-') || (uflags.frejuv))
					{
					usage();
					exit (-1);
					}
				break;
				
			case 'q':
				uflags.fq = TRUE;
				break;
				
			case 'u':
				uflags.fuser = TRUE;
				uflags.fall = FALSE;
				GetNextArg (uflags.userid, *(argv)+2, *(argv+1), JOBIDLEN);
				if (*uflags.userid == '-')
					{
					usage();
					exit (-1);
					}
				break;
				
			case 'n':
				uflags.fdispl = FALSE;
				break;
				
			case 'r':
				uflags.frejuv = TRUE;
				GetNextArg (uflags.jobid, *(argv)+2, *(argv+1), JOBIDLEN);
				/* if jobid was not given or rejuvinate flag also given,
				abort the program */
				if ((*uflags.jobid == '-') || (uflags.fkill))
					{
					usage();
					exit (-1);
					}
				break;
				
			case 's':
				uflags.fsystem = TRUE;
				GetNextArg (uflags.system, *(argv)+2, *(argv+1), JOBIDLEN);
				if (*uflags.system == '-')
					{
					usage();
					exit (-1);
					}
				break;	
				
			default:
				usage();
				exit (-1);
			} /* switch */
		argv++;
		argc--;	
		} /* while */
		
	/* set user name if it wan't set on cmd-line */
	if (!uflags.fuser)
		strncpy (uflags.userid, GetUname(), UIDLEN);

	/* 
	*	if neither fuser nor fall are set, then default to fuser.
	*	the user id of user issuing this program has been set in the
	*	previous lines
	*/
	if (!uflags.fuser && !uflags.fall)
		uflags.fuser = TRUE;
	
	/*
	*	perform the action given
	*/
	if (uflags.fsystem)
		{ /* process only the given system.  display ALL jobs in the
		     queue, regardless of user who issued job. */
		uflags.fall = TRUE;
		ret = ProcessSite (uflags.system, &uflags);
		} /* if uflags.fsystem */
	else if (uflags.fall || uflags.fuser || uflags.fkill || uflags.frejuv || uflags.fq)
		{ /* process all queues for valid systems.  Decisions on whether
		     a job should be displayed is contained in the function
		     Display(). 
		  */
		while ((system = GetSystem()) != NULL)
			{
			ret = ProcessSite (system, &uflags);
			if (ret)
				break;
			} /* while */
		if (!ret && (uflags.fkill || uflags.frejuv) && (!uflags.count))	
			if (uflags.fdispl)
				printf ("job not found\n");
			else
				ret = -1;		/* return status instead */	
		} /* else if .. */
	else
		{
		usage();
		exit (-1);
		} /* else */	

	/* if job counting was specified, return with number of jobs found,
	   else return 0 to indicate success */
	if (uflags.fjobs)
		printf ("job count = %d\n", uflags.count);
		
	exit (ret);
	} /* main */
