/******************************************************************************
 * $Id: mailuser.c,v 1.1 92/08/04 16:57:19 romel Exp Locker: romel $
 * Name:	MailUser
 * Proj:	uustat
 * Desc:	Informs user that a job he/she created was deleted by uucp or root.
 *		This is done by sending mail to that user.
 * Synop:	int MailUser (char * user, char * file)
 * Entry:	user: login name of user to inform
 *		file: the name of the uucp control file that was deleted
 * Exit:	0 if successful, -1 if not.
 * Notes:	The command used to send mail to the user is defined by the constant
 *		MAILCMD in uustat.h.
 * $Log:	mailuser.c,v $
 * Revision 1.1  92/08/04  16:57:19  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include "uustat.h"

char * mktemp ();


int MailUser (user, file)
char * user;
char * file;
	{
	FILE *fp;
	static char cmd[80];
	char * tmpfile;
	time_t timevar;

	tmpfile = mktemp ("/tmp/uustatXXXXXX");

	/* create mail message in temp file */
	fp = fopen (tmpfile, "w");
	if (fp == NULL)
		return -1;

	timevar = time (NULL);
	fprintf (fp, "Subject: Your UUCP Job\n\n");
	fprintf (fp, "Your UUCP job: %s\n\n", GetJobId (file));
	fprintf (fp, "was killed by user %s on %s.\n", GetELogName(), ctime(&timevar));
	fclose (fp);

	sprintf (cmd, "%s %s < %s", MAILCMD, user, tmpfile);
	system (cmd);
	unlink (tmpfile);
	return 0;
	} /* MailUser */
