/******************************************************************************
 * $Id: getsend.c,v 1.1 92/08/04 16:56:27 romel Exp Locker: romel $
 * Name:	GetSender
 * Proj:	uustat
 * Desc:	Retrieves the name of the user that created the uucp job.
 * Synop:	char * GetSender (FILE * fp);
 * Entry:	filepointer of the control file for which this info is requested
 * Exit:	pointer to string containing name of user or NULL
 * Notes:	None
 * $Log:	getsend.c,v $
 * Revision 1.1  92/08/04  16:56:27  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include "uustat.h"


#define SENDER 4		/* the number of the sender field */

char * GetSender (fp)
FILE * fp;
	{
	static char line[LLEN];
	char * p;

	rewind (fp);
	if (fgets (line, LLEN, fp) == NULL)
		return NULL;
	
	p = GetField (line, SENDER);
	rewind (fp);
	return p;
	} /* GetSender */


#ifdef TESTSENDER

main (argc, argv)
int argc;
char *argv[];
	{
	FILE * fp;

	if (argc < 2)
		{
		printf ("\nargs");
		exit (1);
		}
		
	fp = fopen (*(argv+1), "r");
	if (fp == NULL)
		{
		printf ("open");
		exit (1);
		}

	printf ("sender: %s\n", GetSender (fp));
	}
#endif
