/******************************************************************************
 * $Id: getnarg.c,v 1.1 92/08/04 16:56:09 romel Exp Locker: romel $
 * Name:	GetNextArg
 * Proj:	uustat
 * Desc:	Checks the first character of string arg and if it is not
 *		'\0', copies the rest of the string into array s.  Otherwise,
 *		all of nextarg is copied into s.  The number of characters
 *		copied will not exceed n.
 * Synop:	int GetNextArg (char *s, char *arg, char *nextarg, int n)
 * Entry:	
 * Exit:	pointer to first char of the filename or NULL if file is 
 *		invalid.
 * Notes:	Purpose of this function is to retrieve the next argument on the
 *		command line.  Sometimes, when a command-line option requires a
 *		special argument to follow, it is placed immediately after the
 *		option flag with no space separating the two.  However, sometimes
 *		it is placed with a space preceeding it.  This function allows the
 *		program to retrieve the argument whichever way it is entered.
 * $Log:	getnarg.c,v $
 * Revision 1.1  92/08/04  16:56:09  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <string.h>




int GetNextArg (s, arg, nextarg, n)
char *s, *arg, *nextarg;
int n;
	{
	if (*arg)
		return strncpy (s, arg, n);
	else
		return strncpy (s, nextarg, n);	
	} /* GetNextArg */
