/******************************************************************************
 * $Id: getjid.c,v 1.1 92/08/04 16:55:55 romel Exp Locker: romel $
 * Name:	GetJobId
 * Proj:	uustat
 * Desc:	Retrieves the jobid portion of the control file pathname
 * Synop:	char * GetJobId (char * filename);
 * Entry:	filename: pathname of the control file
 * Exit:	pointer to the jobid of the control file of NULL if not found.
 * Notes:	None
 * $Log:	getjid.c,v $
 * Revision 1.1  92/08/04  16:55:55  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include <string.h>
#include "uustat.h"




char * GetJobId (filename)
char * filename;
	{
	char * s;
	
	/*
	*	remove any path included with the filename
	*	remove the "C." prefix from the file
	*	if the prefix does not exist, the filename is
	*	invalid
	*/
	/* remove path if any */
	s = strrchr (filename, '/');
	if (s == NULL)
		/* no path included */
		s = filename;
	else
		s++;						/* point past path */	
		
	/* check the prefix of the file */
	if (*s != 'C')
		return NULL;
		
	/* remove the prefix */	
	s = strchr (s, '.');
	if (s == NULL)
		{ /* file is invalid */
		return NULL;
		}
	else
		s++;		/* point past the prefix */	

	/* return the jobid string */
	return s;
	} /* GetJobId */	

