/******************************************************************************
 * $Id: getfield.c,v 1.1 92/08/04 16:55:38 romel Exp Locker: romel $
 * Name:	GetField
 * Proj:	uustat
 * Desc:	Returns a particular field in a line of records separated by
 *		spaces of tabs
 * Synop:	char * GetField (char * s, int field);
 * Entry:	s: pointer to the string
 *		field: the number of the field to retrieve
 * Exit:	pointer to the first char in the requested field of NULL of not
 *		found.
 * Notes:	None
 * $Log:	getfield.c,v $
 * Revision 1.1  92/08/04  16:55:38  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <string.h>
#include <stddef.h>


char * GetField (s, field)
char * s;
int field;		/* the field to retrieve: 1=first, 2=second, etc. */
	{
	char * delimiter = " \t";
	char * p, * q;
	static char t[255];

	strncpy (t,s,255);

	q = t;
	while (field--)
		{
		p = strtok (q, delimiter);
		if (p == NULL)
			{
			return NULL;
			}
		q = NULL;
		} /* while */
	return p;	
	} /* GetField */
	

#ifdef TEST

main ()
	{
	char *t="this is a sentence to parse for testing";
	int i;
	
	for (i=0; i< 5; i++)
		{
		printf ("\n%d) in: %s; out: %s\n", i, t, GetField (t, i));
		}
	}

#endif
