/******************************************************************************
 * $Id: getelname.c,v 1.1 92/08/04 16:55:25 romel Exp Locker: romel $
 * Name:	GetELogName
 * Proj:	uustat
 * Desc:	Returns the effective login name of user
 * Synop:	char *GetELogName()
 * Entry:	Nothing
 * Exit:	Pointer to the effective login name of the user
 * Notes:	Uses the getpwent() function
 * $Log:	getelname.c,v $
 * Revision 1.1  92/08/04  16:55:25  romel
 * Initial revision
 * 
 *****************************************************************************/

#include <stdio.h>
#include <pwd.h>


char *GetELogName()
	{
	int uid;
	static struct passwd *pwp = NULL;

	uid = getuid();
	setpwent();
	while ((pwp = getpwent()) != NULL)
		{
		if (pwp->pw_uid == uid)
			return pwp->pw_name;
		} /* while */
	return NULL;	
	} /* GetELogName */



#ifdef TEST

main ()
	{
	printf ("effective login name: %s\n", GetELogName());
	}

#endif
