/******************************************************************************
 * $Id: getcfile.c,v 1.1 92/08/04 16:55:06 romel Exp Locker: romel $
 * Name:	GetCfile
 * Proj:	uustat
 * Desc:	Retrieves the next control file for a system
 * Synop:	char * GetCfile (char * system);
 * Entry:	system: the system name
 * Exit:	pointer to an array containing the path of the control file or
 *		NULL if no more.
 * Notes:	Uses the directory access routines provided by Herb Alcorn.  See
 *		the file DIR-IO.C.
 * $Log:	getcfile.c,v $
 * Revision 1.1  92/08/04  16:55:06  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <sys/dir.h>
#include "uustat.h"


/* external references */
extern int opendir();
extern int closedir();
extern struct direct * readdir();

/* declarations */
struct directx {
	ino_t d_ino;
	char d_name[DIRSIZ+1];
	};


char * GetCfile (system)
char * system;
	{
	static struct directx dir;
	static int dfp = -1;
	static char sysptr[SYSLEN];
	static char directory[DIRLEN];

	/* initial settings */
	dir.d_name[DIRSIZ] = '\0';
	
	/* make sure system is not NULL */
	if (system == NULL)
		/* no good */
		return NULL;
		
	/*
	*	if sysptr is same as system, this is the first call, open
	*	the spool dir for system
	*/
	if (strcmp (sysptr, system))
		{ /* system is different from last call - reinitialize */
		/* if a previous directory is open, close it first */
		if (dfp != -1)
			{
			closedir (dfp);
			}
			
		/* open spool directory */
		sprintf (directory, "%s/%s", SPOOLDIR, system);
		dfp = opendir (directory);
		if (dfp < 0)
			{
			return NULL;
			}
			
		/* record current system */	
		strcpy (sysptr, system);
		} /* if */	
		
	/* search for the file and return pointer to it */
	dir.d_ino = 0;
	while (dir.d_ino == 0)
		{
		if (readdir (dfp, &dir) == NULL)
			{ /* no more files */
			closedir (dfp);
			return NULL;
			}
		} /* while dir.d_ino */
		
	/* 
	* append filename to directory to obtain fully qualified path
	* var directory is available for use since it is only used once
	* per system name
	*/
	makeuupath (directory, system, dir.d_name);

	/* return it */
	return directory;
	} /* GetCfile */



/* #define TEST */
#ifdef TEST
#include <stdio.h>


main (argc, argv)
int argc;
char *argv[];
	{
	char *p;
	
	if (argc < 2)
		exit (1);

	while ((p = GetCfile (*(argv+1))) != NULL) 
	} /* main */

#endif
