/*
 *      PAGE.H
 *      UTREE pager definitions.
 *      3.04-um klin, Sat May 23 17:08:46 1992, Initial version
 *
 *      Copyright (c) 1991/92 by Peter Klingebiel & UNIX Magazin Muenchen.
 *      For copying and distribution information see the file COPYRIGHT.
 */
#if     defined(_MAIN_) && !defined(lint)
static char sccsid_page[] = "@(#) utree 3.04-um (klin) May 23 1992 page.h";
#endif  /* _MAIN_ && !lint */

/*
 *      A page is a dynamically linked list of struct _plist.
 */

typedef struct _plist {
  glist list;                   /* Containing line and pointers         */
  int number;                   /* Line number on screen                */
  int lineno;                   /* Line number in page                  */
} plist;

#define PNULL   ((plist *) 0)   /* The plist NIL pointer                */

/*
 *      Access to entries in the page line list is done
 *      with macros to hide this record and for abbreviation.
 */

#define PLINE(p)        ((p)->list.string)
#define PPREV(p)        ((p)->list.prev)
#define PNEXT(p)        ((p)->list.next)
#define PLNUM(p)        ((p)->number)
#define PLLNO(p)        ((p)->lineno)

/* Access to character n in line string pointed to by p                 */
#define PCHAR(p, n)     ((p)->list.string[n])

/* Row of page line p on screen                                         */
#define PLROW(p)        ((p)->number-tplist->number+firstline)
