/****************************************************************/
/*								*/
/*	XChess V2.7: Stellung bewerten				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include "ch.h"			/* Def. des Schachspiels 	*/
#include "ph.h"			/* Def. der Spielphasen		*/

static long bewerte2();		/* Vorwaertsdeklaration		*/

/****************************************************************/
/*	Stellung bewerten					*/
/****************************************************************/
/*	Return:	Stellungwert					*/
/****************************************************************/

long bewerte(dat,pos)

SPDAT 	*dat;			/* Spieldaten	*/
BYTE	pos;			/* einzelne Position	*/
{
	BYTE		i,j;		/* Zaehler		*/
	long		wert=0L;	/* Wert der Position	*/

	if(!pos)		/* komplett berechnenen ?	*/
	for(j=0;j<8;j++)	/* alle Felder durchgehen	*/
		for(i=0;i<8;i++)
			wert += bewerte2(dat,i,j);	/* berechnen	*/
	else             	/* nur eine Position berechnen	*/
	{
		i=_xpos(pos);			/* Koordinaten best.	*/
		j=_ypos(pos);

		wert = bewerte2(dat,i,j);	/* berechnen	*/
	}

	return(wert);		/* Stellungswert zurueckgeben	*/
}

static long bewerte2(dat,i,j)

SPDAT 	*dat;			/* Spieldaten	*/
BYTE	i,j;			/* zu bewertende Position	*/
{
	static long fig_wert[]=	/* Wert der Figuren	*/
	{0L,100L,100L,300L,300L,500L,500L,900L,MATT,MATT};

	BYTE	fig;			/* Figur		*/
	long	wert=0;			/* Wert der Position	*/
	BYTE	pos;			/* Position		*/

	pos=ZLEN*(j+RAND)+i+RAND;	/* Position berechnen	*/

	fig=dat->brett[pos];		/* Figur bestimmen	*/

	wert = fig_wert[_figur(fig)];	/* Wert der Figur 	*/

	if(phase==EROEFF)		/* Eroeffnungsphase ?	*/
	{
		/**** Postionsboni Eroeffnung ****/
		static long bau_add[][8]=
		{
		0L,	0L,	0L,	0L,	0L,	0L,	0L,	0L,
		0L,	0L,	0L,	0L,	0L,	0L,	0L,	0L,
		0L,	0L,	20L,	20L,	20L,	20L,	0L,	0L,
		0L,	0L,	20L,	50L,	50L,	20L,	0L,	0L,
		0L,	0L,	20L,	50L,	50L,	20L,	0L,	0L,
		0L,	0L,	20L,	20L,	20L,	20L,	0L,	0L,
		0L,	0L,	0L,	0L,	0L,	0L,	0L,	0L,
		0L,	0L,	0L,	0L,	0L,	0L,	0L,	0L,
		};

		static long spr_add[][8]=
		{
		-50L,	0L,	0L,	0L,	0L,	0L,	0L,	-50L,
		-20L,	0L,	0L,	0L,	0L,	0L,	0L,	-20L,
		-20L,	0L,	0L,	50L,	50L,	0L,	0L,	-20L,
		-20L,	10L,	40L,	50L,	50L,	40L,	10L,	-20L,
		-20L,	10L,	30L,	50L,	50L,	30L,	10L,	-20L,
		-20L,	0L,	30L,	10L,	10L,	30L,	0L,	-20L,
		-20L,	0L,	0L,	0L,	0L,	0L,	0L,	-20L,
		-50L,	0L,	0L,	0L,	0L,	0L,	0L,	-50L,
		};

		static long lae_add[][8]=
		{
		0L,	0L,	0L,	0L,	0L,	0L,	0L,	0L,
		0L,	0L,	0L,	0L,	0L,	0L,	0L,	0L,
		0L,	0L,	0L,	0L,	0L,	0L,	0L,	0L,
		0L,	50L,	0L,	0L,	0L,	0L,	20L,	0L,
		10L,	0L,	10L,	0L,	0L,	10L,	0L,	10L,
		0L,	0L,	0L,	20L,	20L,	0L,	0L,	0L,
		0L,	0L,	50L,	0L,	10L,	0L,	0L,	0L,
		0L,	0L,	0L,	0L,	0L,	0L,	0L,	0L,
		};	

		static long koe_add[][8]=
		{
		-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,
		-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,
		-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,
		-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,
		-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,
		-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,
		-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,	-20L,
		-20L,	 60L,	 60L,	  0L,	-10L,	  0L,	 60L,	-20L,
		};

		switch(_figur(fig))		/* Positionsboni	*/
		{
		case BAU:			/* Bauer		*/
		case XBAU:
			wert += bau_add[_farbe(fig)==SCH?j:7-j][i];
			break;

		case SPR:			/* Springer		*/
			wert += spr_add[_farbe(fig)==SCH?j:7-j][i];
			break;

		case LAE:			/* Laeufer		*/
			wert += lae_add[_farbe(fig)==SCH?j:7-j][i];
			break;

		case KOE:			/* Koenig		*/
		case XKOE:
			wert += koe_add[_farbe(fig)==SCH?j:7-j][i];
			break;
		}
	}
	else if(phase==MITTEL)			/* Mittelspiel ?	*/
	{
		/*** Reihenboni Mittelspiel	(gilt fuer Turm)	***/
		static long add[]={0L,5L,10L,15L,20L,25L,40L,50L};

		if(!_istkoe(fig))
			wert += (fig_wert[_figur(fig)]*
			add[_farbe(fig)==WEI ? j:7-j])/fig_wert[TUR];
	}
	else if(phase==ENDSPI || phase==WKOEOO || phase==SKOEOO)	
	{					/* Endspiel ?		*/
		/*** Positionsboni fuer Koenig				***/
		static long koe_add[][8]=
		{
		-80L,	-60L,	-30L,	-30L,	-30L,	-30L,	-60L,	-80L,
		-60L,	-30L,	-10L,	-10L,	-10L,	-10L,	-30L,	-60L,
		-30L,	-10L,	  0L,	  0L,	  0L,	  0L,	-10L,	-30L,
		-30L,	-10L,	  0L,	  0L,	  0L,	  0L,	-10L,	-30L,
		-30L,	-10L,	  0L,	  0L,	  0L,	  0L,	-10L,	-30L,
		-30L,	-10L,	  0L,	  0L,	  0L,	  0L,	-10L,	-30L,
		-60L,	-30L,	-10L,	-10L,	-10L,	-10L,	-30L,	-30L,
		-80L,	-60L,	-30L,	-30L,	-30L,	-30L,	-60L,	-60L,
		};

		/*** Reihenboni Endspiel fuer Bauer			***/
		static long add[]={0L,5L,10L,15L,20L,25L,30L,35L};

		if(_istbau(fig))			/* Bauern vor 	*/
			wert += add[_farbe(fig)==WEI ? j:7-j];

		if(phase==WKOEOO || phase==SKOEOO)	/* Koe. o. Offiziere*/
		if(_istkoe(fig))
		{
			int 	abstand;

			abstand=abs((int)(_xpos(dat->wkpos)-_xpos(dat->skpos)))
			       +abs((int)(_ypos(dat->wkpos)-_ypos(dat->skpos)));

			if(_istwei(fig))
			{
			if(phase==WKOEOO)	/* nicht an den Rand	*/
				wert+= koe_add[_farbe(fig)==SCH?j:7-j][i];
			else			/* Koenig in Opposition	*/
				wert-= abstand * 10;
			}
			else if(_istsch(fig))
			{
			if(phase==SKOEOO)	/* nicht an den Rand	*/
				wert+= koe_add[_farbe(fig)==SCH?j:7-j][i];
			else			/* Koenig in Opposition	*/
				wert-= abstand * 10;
			}
		}
	}

	wert *= _farbe(fig) == WEI ? 1L:-1L;	/* Vorzeichen		*/

	return(wert);
}
