/****************************************************************/
/*								*/
/*	XChess V2.7: Bedrohung testen				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include "ch.h"			/* Def. des Schachspiels */

/****************************************************************/
/*	Feld auf Bedrohung testen				*/
/*	Testet nicht auf e.p.					*/
/****************************************************************/
/*	Return:	1: bedroht	0: nicht bedroht		*/
/****************************************************************/

int	bedrohung(dat,pos)

SPDAT	*dat;				/* Spieldaten	*/
BYTE	pos;				/* Position	*/
{
	static short wbed[][12] =	/* Bedrohung durch Weiss	*/
	{
		/* Bedrohung durch Bauer */
		{-11,-13,0},
		/* Bedrohung durch Springer	*/
		{14,25,23,10,-14,-25,-23,-10,0},
		/* Bedrohung durch Laeufer Dame und Koenig	*/
		{13,11,-13,-11,0},
		/* Bedrohung durch Turm, Dame und Koenig	*/
		{1,12,-1,-12,0},
	};

	static short sbed[][12] =	/* Bedrohung durch Schwarz	*/
	{
		/* Bedrohung durch Bauer */
		{11,13,0},
		/* Bedrohung durch Springer	*/
		{14,25,23,10,-14,-25,-23,-10,0},
		/* Bedrohung durch Laeufer Dame und Koenig	*/
		{13,11,-13,-11,0},
		/* Bedrohung durch Turm, Dame und Koenig	*/
		{1,12,-1,-12,0},
	};

	register short	(*bed)[12];	/* effektive Bedrohungsliste	*/
	register BYTE	k;		/* Zaehler			*/
	register BYTE	pos2;		/* Position des Bedrohers	*/
	register short	zug;		/* aktueller Zug		*/
	register BYTE	fa;		/* Farbe			*/

	if(_istlee(dat->brett[pos]))   	/* Farbe bestimmen	*/
		fa=dat->farbe;
	else
		fa=_farbe(dat->brett[pos]);

	if(fa==WEI)			/* eff. Bedrl. best.*/
		bed=sbed;
	else
		bed=wbed;

	for(k=0;zug=bed[2][k];k++)	/* LAEUFER, DAME, KOENIG	*/
					/* alle Zuege durchg.		*/
	{
		pos2=(BYTE)((short)pos+zug);

		if(_istkoe(dat->brett[pos2]) && fa!=_farbe(dat->brett[pos2]))
			return(1);	/* Bedrohung gefunden	*/

		while(_istlee(dat->brett[pos2]))	/* suchen	*/
			pos2= (BYTE)((short)pos2+zug);

		if((_istlae(dat->brett[pos2]) ||
		    _istdam(dat->brett[pos2])) &&
		     fa!=_farbe(dat->brett[pos2]))
				return(1);	/* Bedrohung gefunden	*/
	}

	for(k=0;zug=bed[3][k];k++)	/* TURM, DAME, KOENIG	*/
					/* alle Zuege durchg.	*/
	{
		pos2=(BYTE)((short)pos+zug);

		if(_istkoe(dat->brett[pos2]) && fa!=_farbe(dat->brett[pos2]))
			return(1);	/* Bedrohung gefunden	*/

		while(_istlee(dat->brett[pos2]))	/* suchen	*/
			pos2= (BYTE)((short)pos2+zug);

		if((_isttur(dat->brett[pos2]) ||
		    _istdam(dat->brett[pos2])) &&
		     fa!=_farbe(dat->brett[pos2]))
				return(1);	/* Bedrohung gefunden	*/
	}

	for(k=0;zug=bed[0][k];k++)	/* BAUER		*/
					/* alle Zuege durchg.	*/
	{
		pos2=(BYTE)((short)pos+zug);
		if(_istbau(dat->brett[pos2]) && fa!=_farbe(dat->brett[pos2]))
			return(1);	/* Bedrohung gefunden	*/
	}

	for(k=0;zug=bed[1][k];k++)	/* SPRINGER		*/
					/* alle Zuege durchg.	*/
	{
		pos2=(BYTE)((short)pos+zug);
		if(_istspr(dat->brett[pos2]) && fa!=_farbe(dat->brett[pos2]))
			return(1);	/* Bedrohung gefunden	*/
	}

	return(0);			/* keine Bedrohung gefunden	*/
}
