/****************************************************************/
/*								*/
/*	XChess V2.7: Eroeffnung und Spielphase			*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include <math.h>
#include <stdio.h>
#include "ch.h"			/* Def. des Schachspiels 	*/
#include "ph.h"			/* Def. der Spielphasen		*/

static	WORD	op_zug();

/****************************************************************/
/*	effektive Stufe einstellen und Spielphase erkennen	*/
/****************************************************************/

void	eff_stufe(dat)

SPDAT 	*dat;				/* Spieldaten			*/
{
	double	wanz,sanz;		/* Anzahl der Figurenbew.	*/
	int	w_b,w_sl,w_td;		/* Anzahl der weissen Figuren	*/
	int	s_b,s_sl,s_td;		/* Anzahl der schwarzen Figuren	*/
	WORD	pos;
	static	double bew[]=		/* Bewgungsfreiheit		*/
					/* unter opt. Bedingungen	*/
	{BWLEE,BWBAU,BWXBAU,BWSPR,BWLAE,BWTUR,BWXTUR,BWDAM,BWKOE,BWXKOE};
	static	double maxanz=		/* Bewegunsfreiheit am Anfang	*/
	2* (8*BWXBAU + 2*BWSPR + 2*BWLAE + 2*BWXTUR + BWDAM + BWXKOE);

	wanz=0.; sanz=0.;		/* loeschen	*/
	w_b=0; w_sl=0; w_td=0;
	s_b=0; s_sl=0; s_td=0;

	for(pos=RAND*ZLEN,wanz=0.,sanz=0.;pos<GROE-RAND*ZLEN;pos++)
		if(_istwei(dat->brett[pos]))
		{
			wanz+=bew[_figur(dat->brett[pos])];
			switch(_figur(dat->brett[pos]))
			{
			case BAU:		/* Anzahl der Figuren	*/
			case XBAU:		/* bestimmen		*/
				w_b++;
				break;
			case SPR:
			case LAE:
				w_sl++;
				break;
			case TUR:
			case XTUR:
			case DAM:
				w_td++;
				break;
			}
		}
		else if(_istsch(dat->brett[pos]))
		{
			sanz+=bew[_figur(dat->brett[pos])];
			switch(_figur(dat->brett[pos]))
			{
			case BAU:		/* Anzahl der Figuren	*/
			case XBAU:		/* bestimmen		*/
				s_b++;
				break;
			case SPR:
			case LAE:
				s_sl++;
				break;
			case TUR:
			case XTUR:
			case DAM:
				s_td++;
				break;
			}
		}

	/*** Phasenerkennung ********************************************/

	/* Bei Spielbeginn gibt es 16 Bauern und 14 Offiziere		*/

	if(s_b+s_sl+s_td+w_b+w_sl+w_td == 0)	/* Remis ?		*/
		phase=REMIS;
	else if(!w_sl && !w_td)	/* Weisser Koenig ohne Offiziere ?	*/
		phase=WKOEOO;
	else if(!s_sl && !s_td)	/* Schwarzer Koenig ohne Offiziere ?	*/
		phase=SKOEOO;
	else if(w_b+s_b<=8 || w_sl+w_td+s_sl+s_td<=7)
		phase=ENDSPI;		/* Endspiel			*/
	else if(w_b+s_b<=12 || w_sl+w_td+s_sl+s_td<=12)
		phase=MITTEL;		/* Mittelspiel			*/
	else
		phase=EROEFF;		/* Eroeffnung			*/

	/*** Ende Phasenerkennung ***************************************/

	if(mode&8 && wanz != 0 && sanz != 0)	/* Stufenanpassung ?	*/
	{
		dat->minstufe=		/* Rechentiefen		*/
		(int) ((double)mintiefe[stufe]*log(maxanz)/log(wanz+sanz)+.5);
		dat->maxstufe=
		(int) ((double)maxtiefe[stufe]*log(maxanz)/log(wanz+sanz)+.5);
		if(dat->maxstufe%2 != 0)
			dat->maxstufe--;

		/* Maximal doppelt	*/

		if(dat->minstufe>mintiefe[stufe]*2)
			dat->minstufe=mintiefe[stufe]*2;

		if(dat->maxstufe>maxtiefe[stufe]*2)
			dat->maxstufe=maxtiefe[stufe]*2;
	}
	else
	{
		dat->minstufe=mintiefe[stufe];
		dat->maxstufe=maxtiefe[stufe];
	}
}

/****************************************************************/
/*	Zug aus Bibliothek suchen				*/
/****************************************************************/
/*	Return:	Zug oder 0 falls keiner gefunden		*/
/****************************************************************/

WORD bib_zug()

{
	int 	j,i,anz=0;
	int	mgl[MAXOP];		/* Liste mit mgl. Eroeffnungen	*/
	WORD	ko[MAXSP];		/* Kombination		*/

	if(!(mode&32) || noop<=0) 	/* Bibliothek aus ? 	*/
		return((WORD)0);

	noop--;				/* Bibl.zaehler erniedrigen	*/

	if(mode&64)		/* bestimmte Eroeffnung nehmen	*/
	{
		i=testopnr;

		for(j=0;j<spdat.zuege && op[i][j]!=(WORD)0;j++)
			if(archiv[j+1]->lzug!=op[i][j])
				break;	/* passt nicht		*/

		if(j==spdat.zuege && op[i][j]!=(WORD)0)
		{			/* passt		*/
			mgl[anz++]=i;
			noop=OPTRYS;	/* Bibl. wieder oeffnen	*/
		}
	}
	else
		for(i=0;i<opnr;i++)		/* Eroeffnungen testen	*/
		{
			for(j=0;j<spdat.zuege;j++) /* Komb. erstellen	*/
				ko[j]=archiv[j+1]->lzug;

			ko[j]=(WORD)0;		/* beenden	*/


			if(op_zug(ko,&op[i][0]) != (WORD)0)
			{			/* Zug gefunden		*/
				if(op_fa[i] & spdat.farbe)
					mgl[anz++]=i;
				/* Eroeffnung fuer die richtige Farbe	*/
				
				noop=OPTRYS;	/* Bibl. wieder oeffnen	*/
				/* ^ Wichtig ! Die Bib. muss auch er-	*/
				/* oeffnet werden, wenn die Farbe nicht	*/
				/* stimmt, da sonst beim naechsten Zug	*/
				/* fuer die andere Farbe nicht mehr 	*/
				/* nachgesehen wird.			*/
			}
		}

	if(anz == 0)
		return((WORD)0);	/* nix gefunden		*/

	i=rand();   	   		/* zufaellig beginnen	*/
	while(i>=anz)
		i -= anz;

#ifdef	ANALYSE		/* einfache Analyse ein ?	*/
	if(mode & 128)
	{
		WORD komb[2];				/* Kombination	*/
		char str[STRLEN];

		komb[0]=op[mgl[i]][spdat.zuege];	/* eintragen	*/
		komb[1]=(WORD)0;			/* beenden	*/

		strcpy(str,kombination(&spdat,komb));
		strcat(str," (Library)");
		ANALYSE(str);
	}
#endif

	return(op[mgl[i]][spdat.zuege]);	/* gefunden	*/
}

static	WORD	op_zug(ko,er)

WORD	*ko,*er;	/* Kombination, Eroeffnung	*/
{
	int	len,i,j;
	WORD	ek[MAXSP];	/* Kopie der Eroeffnung	*/

	len=spdat.zuege;	/* Laenge der Kombination feststellen */

	for(i=0;i<len+1;i++)	/* er in ek kopieren	*/
	{
		if(er[i]==(WORD)0)	 /* Kombination laenger als 	*/
			return((WORD)0); /* Eroeffnung			*/

		ek[i]=er[i];
	}

	ek[len]=(WORD)0;	/* beenden	*/

	for(i=0;i<len;i += 2)	/* Weisse Zuege durchsuchen	*/
	{
		for(j=0;j<len;j += 2)
			if(ek[j]==ko[i])	/* Zug gefunden	*/
			{
				ek[j]=(WORD)0;	/* streichen	*/
				break;
			}

		if(j>=len)	/* Zug nicht gefunden	*/
			return((WORD)0);
	}

	for(i=1;i<len;i += 2)	/* Schwarze Zuege durchsuchen	*/
	{
		for(j=1;j<len;j += 2)
			if(ek[j]==ko[i])	/* Zug gefunden	*/
			{
				ek[j]=(WORD)0;	/* streichen	*/
				break;
			}

		if(j>=len)	/* Zug nicht gefunden	*/
			return((WORD)0);
	}

	return(er[len]);	/* Zug als Ergebnis	*/
}

/****************************************************************/
/*	Eroeffungen aus Bibliothek testen			*/
/****************************************************************/
/*	Return:	1: alles ok	0: Fehler			*/
/****************************************************************/

int 	bib_test()

{
	FILE	*fp2,*fp=(FILE *)0;	/* Filepointer		*/
	int	zug;			/* Zugnummer		*/
	int	mode2;
	char	str[200*5];
	int	i;

	mode2 = mode;			/* retten		*/

	mode &= !(1+128);		/* Analyse aus		*/
	mode |=	32+64;			/* Eroeffnungstest ein	*/

	init(&spdat,1);			/* Initialisierungen	*/

	testopnr=0;			/* Eroeffungsnummer	*/

	if((fp2=fopen("chess.op","r"))==(FILE *)0)	/* oeffnen	*/
		exit(1);                                /* Fehler 	*/

	while(testopnr<opnr)
	{
		while(!feof(fp2))	/* Eroeffnung suchen	*/
	       	{
			fgets(str,999,fp2);      /* einlesen 	*/

        	        i=0;
			while(str[i]!='#' && str[i]!='\n' && str[i]!=0)
				i++;

			str[i]=0;               /* beenden 	*/

			if(strlen(str))	/* Keine Leerzeile  ?	*/
				break;
		}

		zug=0;			/* erster Zug		*/

fprintf(stderr,"%d/%d\n",testopnr+1,opnr);

		while((spdat.bzug=bib_zug())!=(WORD)0)	/* Zug in Bib. ?*/
		{
			if(zug_test(&spdat,spdat.bzug))	/* Testen	*/
			{
				ziehe(&spdat,spdat.bzug);/* ziehen	*/
				archiviere(&spdat);	/* speichern	*/
				zug++;
			}
			else				/* Fehler !	*/
			{
				/* Fehlerfile oeffnen	*/
				if(fp==(FILE *)0)
					fp=fopen("error.op","w");

				fprintf(fp,"%d%c%d/%d:\n%s\n",
				testopnr+1,TAB,zug/2+1,zug%2+1,str);
				break;
			}
		}
	
		testopnr++;		/* naechste Eroeffung	*/

		init(&spdat,1);		/* Initialisierungen	*/
	}

	mode=mode2;		/* wieder herstellen	*/
	
	fclose(fp2);

	if(fp!=(FILE *)0)	/* Fehler gefunden ?	*/
	{
		fclose(fp);	/* schliessen 	*/
		return(0);	/* Fehler !	*/
	}
	else
		return(1);	/* alles ok	*/
}
