/****************************************************************/
/*								*/
/*	XChess V2.7: Hauptprogramm				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include <string.h>
#include "ch.h"			/* Def. des Schachspiels 	*/

int	opnr;			/* Anzahl der Eroeffnungen	*/
int	testopnr;		/* Eroeffnungsnummer zum testen */
WORD	*op[MAXOP];		/* Zeiger auf die Eroeffnungen	*/
BYTE	op_fa[MAXOP];		/* Farbe fuer die Eroeff. gilt	*/
int	noop;			/* 1-Keine Eroeffnungsbib. mehr	*/
SPDAT	spdat;			/* Alle Spieldaten 		*/
ARCHIV	*archiv[MAXSP];		/* Archiv der Positionen	*/
int	phase;			/* Spielphase			*/
int	zaehler;		/* Antwortzaehler		*/
int	compzuege;		/* Computerzuege		*/
long	varianten;		/* Zaehler fuer die Varianten	*/
long	zeit;			/* Dauer des letzten Zuges	*/
long	varprosek;		/* Varianten pro Sekunde	*/
int	stufe=0;		/* Spielstufe			*/
int	beende;			/* Falls 1 Denkvorgang beenden	*/
WORD	best_so_far;		/* Bester Zug bis jetzt		*/

int	mode=2+4+8+32+128;	/* Modus			*/
				/* 1   :Analyse	ausfuehrlich	*/
				/* 2   :Alpha-Beta-Abschneidung	*/
				/* 4   :Vorsortieren		*/
				/* 8   :Stufenanpassung		*/
				/* 16  :Koenigsbedrohung immer	*/
				/*      ueberpruefen		*/
				/* 32  :Eroeffnungsbib. ein	*/
				/* 64  :Eroeffnungsnr = testopnr*/
				/* 128 :Analyse einfach		*/

				/* Status des letzten Zuges:	*/
int	schlag;			/* falls 1 wurde geschlagen	*/
				/* oder befoerdert		*/
int	gabel;			/* Bauernspiess oder		*/
				/* Springergabel		*/

				/* maximal und minimale Rechentiefe	*/
int	mintiefe[]={2,2,  3,3,  4,4,  5,5,   6,6 };
int	maxtiefe[]={4,6,  6,8,  6,8,  8,10,  8,10};

extern	long	time();
extern	char	*malloc();
extern	char	*memcpy();
extern	void	free();

/****************************************************************/
/*	Hauptprogramm						*/
/****************************************************************/
/*	Return: Anzahl der Antworten in ret			*/
/****************************************************************/

schach(str,ret)

char *str;					/* Kommandostring	*/
char *ret[];					/* Antworten		*/
{
	char cmd[STRLEN];			/* Kommando		*/

	zaehler=0;				/* noch keine Antwort	*/
	beende=0;				/* nicht beenden	*/
	best_so_far=(WORD)0;			/* noch kein Zug	*/

	sscanf(str,"%s",cmd);			/* Kommando einlesen	*/

	strcpy(ret[zaehler],"ok");		/* loeschen		*/

	if(!strcmp(cmd,"init"))
		init(&spdat,1);			/* Initialisierungen	*/
	else if(!strcmp(cmd,"loeschen"))
		init(&spdat,0);			/* Brett loeschen	*/
	else if(!strcmp(cmd,"brett"))
		brett_aus(&spdat,ret);		/* Brett zeigen		*/
	else if(!strcmp(cmd,"info"))
		info_aus(&spdat,ret);   	/* Informationen	*/
	else if(!strcmp(cmd,"status"))
		status_aus(&spdat,ret);  	/* Statusinformationen	*/
	else if(!strcmp(cmd,"weiss"))
	{
		spdat.farbe=WEI;	  	/* Weiss am Zug		*/
		noop=0;
	}
	else if(!strcmp(cmd,"schwarz"))
	{
		spdat.farbe=SCH;	  	/* Schwarz am Zug	*/
		noop=0;
	}
	else if(!strcmp(cmd,"testbib"))		/* Bibl. testen		*/
	{
		if(!bib_test())
			strcpy(ret[zaehler++],"?");	/* Fehler	*/
	}
	else if(!strcmp(cmd,"zurueck"))   	/* Zug zurueck		*/
	{
		if(!hole_zurueck(&spdat,spdat.zuege-1))
			strcpy(ret[zaehler++],"?");	/* Fehler	*/
		else
		{
			free(archiv[spdat.zuege+1]);	/* freigeben	*/
			archiv[spdat.zuege+1]=(ARCHIV *)0;

			noop=OPTRYS;		/* Eroeffnungsbibl. ein	*/
			varianten=0;		/* Keine Varianten	*/
		}
	}
	else if(!strcmp(cmd,"zliste"))
	{
		zugliste(&spdat,(BYTE)0);	/* Zugliste erstellen	*/
		zugliste_aus(&spdat,0,ret);	/* Zugliste zeigen	*/
	}
	else if(!strcmp(cmd,"spiel"))
	{
		int i;

		for(i=1;i<=spdat.zuege;i++)	/* alle Zuege durchgehen*/
			sprintf(ret[zaehler++],"%3d: %s",i
			,wandle(_apos(archiv[i]->lzug)
			,_npos(archiv[i]->lzug)));
	}
	else if(!strcmp(cmd,"save"))
	{
		char name[STRLEN];

		name[0]=0;				/* loeschen	*/
		strcpy(name,str+strlen(cmd));		/* kopieren	*/

		if(name[0]==0)				/* kein Name ?	*/
			strcpy(ret[zaehler++],"?");	/* Fehler	*/
		else if(!save_game(name))		/* Speichern	*/
			strcpy(ret[zaehler++],"?");	/* Fehler	*/
	}
	else if(!strcmp(cmd,"load"))
	{
		char name[STRLEN];

		name[0]=0;				/* loeschen	*/
		strcpy(name,str+strlen(cmd));		/* kopieren	*/

		if(name[0]==0)				/* kein Name ?	*/
			strcpy(ret[zaehler++],"?");	/* Fehler	*/
		else if(!load_game(name))		/* Laden	*/
			strcpy(ret[zaehler++],"?");	/* Fehler	*/
	}
	else if(!strcmp(cmd,"loadinfo"))
	{
		SPDAT	dat;			/* Spieldaten		*/
		char 	name[STRLEN];

		name[0]=0;				/* loeschen	*/
		strcpy(name,str+strlen(cmd));		/* kopieren	*/

		if(name[0]==0)				/* kein Name ?	*/
			strcpy(ret[zaehler++],"?");	/* Fehler	*/
		else
		{
			if(!load_spdat(name,&dat))	/* Laden	*/
				strcpy(ret[zaehler++],"?");/* Fehler	*/
			else
				info_aus(&dat,ret);   	/* Informationen*/
		}
	}
	else if(!strcmp(cmd,"ziehe"))
	{
		WORD zug;

		if(!(zug=wandle_inv(str+strlen(cmd))))
			strcpy(ret[zaehler++],"?");	/* Fehler	*/
		else if(!zug_test(&spdat,zug))		/* Testen	*/
			strcpy(ret[zaehler++],"?");	/* Fehler	*/
		else
		{
			ziehe(&spdat,zug);		/* ziehen	*/
			archiviere(&spdat);		/* speichern	*/
		}
	}
	else if(!strcmp(cmd,"setze"))
	{
		BYTE pos;				/* Position	*/
		char *str2;
		BYTE fig;                            	/* Figur	*/

		str2=str+strlen(cmd);
		while(*str2==' ')
			str2++;

		if((fig=wandle_fig(*str2))==0)		/* Figur holen	*/
			strcpy(ret[zaehler++],"?");	/* Fehler	*/
		else
		{
			str2++;

			if(!(pos=(BYTE)wandle_inv(str2)))
				strcpy(ret[zaehler++],"?");/* Fehler	*/
			else
			{
			if(	/* Keine 2 Koenige !		*/
			(_istkoe(fig) && _istwei(fig)
			&& spdat.wkpos!=(BYTE)0) ||
			(_istkoe(fig) && _istsch(fig)
			&& spdat.skpos!=(BYTE)0))
					strcpy(ret[zaehler++],"?");/* Fehler */
			else
			{
				spdat.brett[pos]=fig;	/* setzen	*/
				noop=0;		/* Bib. schliessen	*/

				if(pos==spdat.wkpos) /* Koenig loeschen ? */
					spdat.wkpos=(BYTE)0;

				if(pos==spdat.skpos) /* Koenig loeschen ? */
					spdat.skpos=(BYTE)0;

				if(_istkoe(fig)) 	/* Koenig ?	*/
				{ 	/* Positionen eintragen	*/
					if(_istwei(fig))
						spdat.wkpos=pos;

					if(_istsch(fig))
						spdat.skpos=pos;
				}
			}
			}
		}
	}
	else if(!strcmp(cmd,"comp"))
	{
		WORD	bzug[MAXTIEFE];	/* Beste Zugkombination		*/

		varianten=0;
		zeit=time((long *)0);			/* Zeit merken	*/

		spdat.wert=bewerte(&spdat,0);		/* Stellungswert*/
		eff_stufe(&spdat);			/* Rechentiefe	*/

		if((spdat.bzug=bib_zug())==(WORD)0)/* Kein Zug in Bib. ?*/
		{
			comp_zug(&spdat,spdat.farbe==WEI ? MATT:-MATT,
			bzug);				/* besten Zug 	*/
		}

		if(zug_test(&spdat,spdat.bzug))		/* Testen	*/
		{
			ziehe(&spdat,spdat.bzug);	/* ziehen	*/
			archiviere(&spdat);		/* speichern	*/

			zeit=time((long *)0)-zeit;	/* Zeitdifferenz*/
			if(varianten>0)			/* Computerzug ?*/
			if(++compzuege<=50)		/* Kein Ueberlauf */
			varprosek+=varianten/((long)zeit>0 ? (long)zeit:1L);
		}
		else	/* Fehler, z.B. in der Bibliothek ?	*/
			noop=0;	/* schliessen	*/
	}
	else if(!strcmp(cmd,"bliste"))
	{
		WORD	bzug[MAXTIEFE];	/* Beste Zugkombination		*/
		varianten=0;

		zeit=time((long *)0);			/* Zeit merken	*/
		spdat.wert=bewerte(&spdat,0);		/* Stellungswert*/
		eff_stufe(&spdat);			/* Rechentiefe	*/
		comp_zug(&spdat,spdat.farbe==
		WEI ? MATT:-MATT,bzug);			/* besten Zug 	*/
		zeit=time((long *)0)-zeit;		/* Zeitdifferenz*/
		if(varianten>0)				/* Computerzug ?*/
		if(++compzuege<=50)			/* Kein Ueberlauf */
		varprosek+=varianten/((long)zeit>0 ? (long)zeit:1L);
		zugliste_aus(&spdat,1,ret);		/* Zugliste zeigen*/
	}
	else if(!strcmp(cmd,"modus"))	/* Modus einstellen	*/
		sscanf(str+strlen(cmd),"%d",&mode);
	else if(!strcmp(cmd,"stufe"))	/* Stufe einstellen	*/
	{
		sscanf(str+strlen(cmd),"%d",&stufe);
		eff_stufe(&spdat);	/* Rechentiefe	*/
	}
	else if(!strcmp(cmd,"wert"))
		sprintf(ret[zaehler++],"%ld",bewerte(&spdat,0));
	else
		strcpy(ret[zaehler++],"?");

	return(zaehler);		/* Anzahl der Antworten zurueck	*/
}
