/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Utilities				*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <fcntl.h>
#include <pwd.h>
#include "ad.h"

static char ad_convert();	/* Vorwaerstdeklaration		*/

/****************************************************************/
/*	Brett aufbauen						*/
/****************************************************************/

void	ad_brett()

{
	int	x=0,y=0;		/* Koordinaten	*/
	int	ch;
	int	i;
	static	char fig[]="KDTTLLSSBBBBBBBB";	/* Figuren	*/
	int	wfig[16];			/* schw. Fig.	*/
	int	sfig[16];			/* wei. Fig	*/

	schach("brett",ptr);		/* ausfuehren	*/

	for(i=0;i<16;i++)		/* loeschen	*/
	{
		wfig[i]=(int)ad_convert(tolower(fig[i]))|A_BOLD;
		sfig[i]=(int)ad_convert(fig[i])|A_REVERSE;
	}

	for(y=0;y<8;y++)		/* Koordinaten durchgehen	*/
	for(x=0;x<8;x++)
	{
		ch=(int)ant[y][x*2];

		if(islower(ch))			/* weiss ?	*/
		{
			for(i=0;i<16;i++)	/* durchsuchen	*/
				if((char)wfig[i]==ad_convert((char)ch))
				{		/* eintragen	*/
					wfig[i]=(int)ad_convert('.');
					break;
				}

			ch = (int)ad_convert((char)ch)|A_BOLD;
						/* hell		*/
		}
		else if(isupper(ch))		/* schwarz ?	*/
		{
			for(i=0;i<16;i++)	/* durchsuchen	*/
				if((char)sfig[i]==ad_convert((char)ch))
				{		/* eintragen	*/
					sfig[i]=(int)ad_convert('.');
					break;
				}

			ch = (int)ad_convert((char)ch)|A_REVERSE;
						/* invers	*/
		}
		else if(ch==(int)'.')		/* leer ?	*/
		{
			ch = (int)ad_convert((char)ch);
			if(!(x%2 ^ y%2))	/* schwarzes Feld ?	*/
				ch |= A_REVERSE|A_BOLD;
			else
				ch |= A_BOLD;
		}

		mvaddch(y*3+1,x*5+3,ch);	/* eintragen	*/
	}

	move(20,8*5+3);		/* geschl. schw. Fig ausgeben	*/
	for(i=0;i<16;i++)
	{
		addch(sfig[i]);
		addch((int)' ');
	}
	move(21,8*5+3);		/* geschl. weisse Fig ausgeben	*/
	for(i=0;i<16;i++)
	{
		addch(wfig[i]);
		addch((int)' ');
	}

	ad_status();		/* Status ausgeben	*/
}

static char ad_convert(ch)	/* Figur umwandeln	*/

char ch;
{
	char ret;

	ret=ch;			/* Returnwert	*/

	switch(ch)
	{
	case 'b':		/* Bauer	*/
		ret=figtab[0];
		break;
	case 's':		/* Springer	*/
		ret=figtab[1];
		break;
	case 'l':		/* Laeufer	*/
		ret=figtab[2];
		break;
	case 't':		/* Turm		*/
		ret=figtab[3];
		break;
	case 'd':		/* Dame		*/
		ret=figtab[4];
		break;
	case 'k':		/* Koenig	*/
		ret=figtab[5];
		break;
	case 'B':		/* Bauer	*/
		ret=figtab[6];
		break;
	case 'S':		/* Springer	*/
		ret=figtab[7];
		break;
	case 'L':		/* Laeufer	*/
		ret=figtab[8];
		break;
	case 'T':		/* Turm		*/
		ret=figtab[9];
		break;
	case 'D':		/* Dame		*/
		ret=figtab[10];
		break;
	case 'K':		/* Koenig	*/
		ret=figtab[11];
		break;
	case '.':		/* Koenig	*/
		ret=figtab[12];
		break;
	}

	return(ret);
}

/****************************************************************/
/*	Status ausgeben						*/
/****************************************************************/

void	ad_status()

{
	int  i;

	attrset(0);		/* Alle Attribute aus	*/

	schach("status",ptr);	/* ausfuehren		*/
	ende=0;
	move(3,MPOS);

	if(!strcmp(ptr[0],"p"))	/* Patt			*/
	{
		addstr(patt);
		ende=PATT;
	}
	else if(!strcmp(ptr[0],"r"))	/* Remis		*/
	{
		addstr(patt);
		ende=PATT;
	}
	else if(!strcmp(ptr[0],"mw"))	/* Matt Weiss		*/
	{
		addstr(w_mate);
		ende=W_MATT;
	}
	else if(!strcmp(ptr[0],"ms"))	/* Matt Schwarz		*/
	{
		addstr(b_mate);
		ende=S_MATT;
	}
	else if(!strcmp(ptr[0],"w"))	/* Schach Weiss		*/
		addstr(w_chess);
	else if(!strcmp(ptr[0],"s"))	/* Schach Schwarz	*/
		addstr(b_chess);
	else if(!strcmp(ptr[0],"3"))	/* Dreifache Wiederholung	*/
	{
		addstr(remis_3);
		ende=1;
	}

	for(i=stdscr->_curx;i<79;i++)	/* Rest der Zeile loeschen	*/
		mvaddch(stdscr->_cury,i,(int)' ');

	move(23,79);
}

/****************************************************************/
/*	Eigenes read()						*/
/****************************************************************/

int	ad_read(fd,buf,num)

int	fd;	/* Filedeskriptor	*/
char	*buf;	/* Buffer		*/
int	num;	/* Anzahl der Zeichen	*/

{
	int ret;	/* Returnwert	*/

	do
	{
		inter=0;		/* Interrupt ruecksetzen	*/
		ret=read(fd,buf,num);	/* Zeichen lesen 	  	*/
	} while(inter==1);

	return(ret);
}

/****************************************************************/
/*	Eingabebuffer leeren					*/
/****************************************************************/

void	ad_flush()
{
	int 	flags;				/* Flags fuer read() 	*/
	char	c;

	flags=fcntl(0,F_GETFL,0);		/* flags retten 	*/

	/* Buffer leeren	*/
	fcntl(0,F_SETFL,flags | O_NDELAY);	/* blockierung aus 	*/
	while(read(0,&c,1));			/* Zeichen lesen   	*/
	fcntl(0,F_SETFL,flags & ~O_NDELAY);	/* blockierung ein 	*/
}
