/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Uebungsspiel				*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/types.h>
#include "ad.h"

/****************************************************************/
/*	Uebungsspiel						*/
/****************************************************************/

void	ad_tr_game()

{
	char 	ch='\0';	/* Eingabe		*/
	char	s[STRLEN];	/* String		*/
	int	ret;		/* Return von domenu	*/

	sprintf(stdname,"training/%s.std",ad_id(getlogin()));

	ad_lock();
	sprintf(s,"load %s",stdname);
	schach(s,ptr);		/* Laden		*/
	ad_unlock();

	schach("info",ptr);	/* Info holen		*/
	modus = atoi(ptr[9]);	/* merken		*/
	farbe = ptr[0][0];
	level = atoi(ptr[6]);

	if(farbe=='w')	/* Farbe einst.		*/
	{
		wei=0;
		sch=1;
	}
	else
	{
		sch=0;
		wei=1;
	}

	ad_menu();		/* Menue ausgeben	*/
	ad_brett();		/* Brett aufbauen	*/
	refresh();		/* ausgeben		*/

	while(1)
	{
		/*--- Computer -----------------------------------------*/
		if(!ende && ((farbe=='w' && wei) || (farbe=='s' && sch)))
		{	/* Computerzug	*/
			int	x;

			mvaddstr(2,MPOS,thinking);/* Status ausgeben	*/
			move(23,79);
			refresh();

			schach("comp",ptr);	/* Zug holen	*/

			ad_brett();		/* Brett aufbauen	*/

			schach("info",ptr);	/* Info holen	*/
			farbe=ptr[0][0];	/* Farbe am Zug	*/

			move(2,MPOS);		/* Meldung loeschen	*/
			for(x=stdscr->_curx;x<79;x++)	/* loeschen	*/
				mvaddch(stdscr->_cury,x,(int)' ');
		}
		else
		/*--- Spieler ------------------------------------------*/
		{
			if(ch=='\0')
				ad_read(0,&ch,1);/* einlesen	*/

			if(isupper(ch))		/* gross ?	*/
				ch=tolower(ch);

			ad_flush();	/* restliche Zeichen wegwerfen	*/

			ret=ad_domenu(ch);	/* auswerten		*/
			
			if(ret==0)		/* Ende ?		*/
			{
				ad_lock();
				sprintf(s,"save %s",stdname);
				schach(s,ptr);	/* Speichern		*/
				ad_unlock();
				break;
			}
			else if(ret==2)		/* Neustart ?		*/
			{
				if(ad_sure('s'))
					ad_new();
			}
		}

		ch='\0';

		/*--- Abbruch der Demo ---------------------------------*/

		if(wei && sch)			/* Demo ? 		*/
		{
			int 	flags;		/* Flags fuer ad_read()	*/
			int	ret;

			flags=fcntl(0,F_GETFL,0);	/* flags retten */

			fcntl(0,F_SETFL,flags | O_NDELAY); /* block aus	*/
			ret=ad_read(0,&ch,1);		   /* einlesen	*/
			fcntl(0,F_SETFL,flags & ~O_NDELAY);/* block ein */

			ad_flush();	/* restliche Zeichen wegwerfen	*/
			if(ret>0 || ende)		/* stopp ? 	*/
			{
				if(farbe=='w')
					wei=0;
				else
					sch=0;

				ad_menu();
			}
			else
				ch='\0';
		}

		/*--- alles ausgeben ---------------------------*/

		move(23,79);		/* Cursor weg		*/
		refresh();		/* ausgeben		*/
	}

	stdname[0]='\0';	/* Kein Standardname	*/
}
