/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Spielmenue				*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>

#include "ad.h"

/****************************************************************/
/*	Turnierspiel gegen ext. Gegner				*/
/****************************************************************/

void	ad_tu_game()

{
	char 	ch='\0';	/* Eingabe		*/
	char	s[STRLEN];	/* String		*/
	int	ret;		/* Return von domenu	*/

	/* Pfad zum Speichern	*/
	sprintf(stdname,"save/%s",wei==0 ? ad_id(getlogin()):
	ad_id(gegner));
	sprintf(stdname+strlen(stdname),".%s", sch==0 ?
	ad_id(getlogin()):ad_id(gegner));

	ad_lock();
	sprintf(s,"load %s",stdname);
	schach(s,ptr);		/* Laden		*/

	if(ptr[0][0]=='?')	/* existiert noch nicht ?	*/
	{
		sprintf(s,"save %s",stdname);
		schach(s,ptr);		/* Laden		*/
	}

	ad_unlock();

	schach("info",ptr);	/* Info holen		*/
	modus = atoi(ptr[9]);	/* merken		*/
	farbe = ptr[0][0];
	level = atoi(ptr[6]);

	ad_menu();		/* Menue ausgeben	*/
	ad_brett();		/* Brett aufbauen	*/
	refresh();		/* ausgeben		*/

	while(1)
	{
		/*--- Spielendeueberpruefung ---------------------------*/
		if(ende)		/* Spiel zu Ende ?	*/
		{
			switch(ende)
			{
			case W_AUFG:	/* Weiss gibt auf	*/
			case W_MATT: 	/* Weiss ist matt	*/
				mvaddstr(2,MPOS,press_key);
				move(23,79);
				refresh();
				ad_read(0,&ch,1);/* einlesen	*/

				if((farbe=='w' && W_IS_USER())
				|| (farbe=='s' && B_IS_USER()))
				{	/* wer am Zug ist, traegt ein	*/
					ad_remove();
					ad_addscore('B');/* Score 	*/
				}

				break;

			case S_AUFG:	/* Schwarz gibt auf	*/
			case S_MATT: 	/* Schwarz ist matt	*/
				mvaddstr(2,MPOS,press_key);
				move(23,79);
				refresh();
				ad_read(0,&ch,1);/* einlesen	*/

				if((farbe=='w' && W_IS_USER())
				|| (farbe=='s' && B_IS_USER()))
				{	/* wer am Zug ist, traegt ein	*/
					ad_remove();
					ad_addscore('W');/* Score 	*/
				}

				break;

			case PATT:	/* Unentschieden	*/
				mvaddstr(2,MPOS,press_key);
				move(23,79);
				refresh();
				ad_read(0,&ch,1);/* einlesen	*/

				if((farbe=='w' && W_IS_USER())
				|| (farbe=='s' && B_IS_USER()))
				{	/* wer am Zug ist, traegt ein	*/
					ad_remove();
					ad_addscore('-');/* Score 	*/
				}

				break;
			}

			break;		/* Ende 		*/
		}
		/*--- Externer Gegner -----------------------------------*/
		else if((farbe=='w' && W_IS_OPP())
		     || (farbe=='s' && B_IS_OPP()))
		{
			int 	flags;	/* Flags fuer ad_read() */
			int	ret;
			int 	x;
			char	str[STRLEN];

			sprintf(str,"%s %s",gegner,is_thinking);
			mvaddstr(2,MPOS,str);	/* Status ausgeben*/
			move(23,79);
			refresh();
			ad_extzug();

			move(2,MPOS);	/* Meldung loeschen	*/
			for(x=stdscr->_curx;x<79;x++)	/* loeschen*/
				mvaddch(stdscr->_cury,x,(int)' ');

			move(23,79);
			refresh();

			/*--- Benutzereingabe 1 ----------------*/

			flags=fcntl(0,F_GETFL,0);/* flags retten */

			fcntl(0,F_SETFL,flags | O_NDELAY);
			ret=ad_read(0,&ch,1);	 /* einlesen	*/
			fcntl(0,F_SETFL,flags & ~O_NDELAY);

			if(ret==0)
				ch=' ';
		}

		/*--- Benutzereingabe 2 ------------------------*/
		{
			if(ch=='\0')
				ad_read(0,&ch,1);/* einlesen	*/

			if(isupper(ch))		/* gross ?	*/
				ch=tolower(ch);

			ad_flush();	/* restliche Zeichen wegwerfen	*/

			ret=ad_domenu(ch);	/* auswerten		*/

			if(ret==0)		/* Ende ?		*/
				break;
			else if(ret==2)
			{
				if((farbe=='w' && wei) || (farbe=='s' && sch))
					ad_error(not_allowed);
				else if(ad_sure('a'))
				{
					move(3,MPOS);

					addstr(wei==0 ? w_up:b_up);
					ende = wei==0 ? W_AUFG:S_AUFG;
				}
			}
		}

		ch='\0';

		/*--- alles ausgeben ---------------------------*/

		move(23,79);		/* Cursor weg		*/
		refresh();		/* ausgeben		*/
	}

	stdname[0]='\0';	/* Kein Standardname	*/
}
