/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Setup					*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "ad.h"

static	void	ad_piece();

/****************************************************************/
/*	Setupmenue						*/
/****************************************************************/

void	ad_setup()

{
	int 	i;			/* Zeile		*/
	char	ch;

	if(TURNIER())	/* Turnierspiel ?	*/
	{
		ad_error(not_allowed);
		return;
	}

	setupwin=newwin(11,27,11,50);		/* neues setupwindow	*/
	box(setupwin,0,0);			/* mit Rahmen		*/

	for(i=0;i<5;i++)
	{
		wmove(setupwin,i+2,2);		/* positionieren	*/
		waddstr(setupwin,smenu[i]+1);	/* ausgeben		*/
	}

	wrefresh(setupwin);			/* ausgeben		*/

	do
	{
		touchwin(stdscr);
		wnoutrefresh(stdscr);

		touchwin(setupwin);

		wmove(setupwin,5,1+strlen(smenu[3]));	/* Farbe am Zug	*/
		for(i=1+strlen(smenu[3]);i<26;i++)
			waddstr(setupwin," ");		/* loschen	*/

		wmove(setupwin,5,1+strlen(smenu[3]));

		if(farbe=='w')
			waddstr(setupwin,white);
		else
			waddstr(setupwin,black);

		wnoutrefresh(setupwin);
		doupdate();

		move(23,79);
		refresh();

		ad_read(0,&ch,1);	/* einlesen	*/

		if(isupper(ch))		/* gross ?	*/
			ch=tolower(ch);

		ad_flush();	/* restliche Zeichen wegwerfen	*/

		if(ch<='h' && ch>='a')
			ad_piece(ch);
		else if(ch == smenu[0][0])	/*** Laden	***/
			ad_load();
		else if(ch == smenu[1][0])	/*** Save	***/
			ad_save();
		else if(ch == smenu[2][0])	/*** Loeschen	***/
		{
			schach("loeschen",ptr);
			ad_brett();
		}
		else if(ch == smenu[3][0])	/*** Farbe wechseln ***/
		{
			if(farbe == 'w')	/* Weiss ?	*/
			{
				farbe = 's';	/* aendern	*/
				schach("schwarz",ptr);
			}
			else			/* Schwarz	*/
			{
				farbe = 'w';	/* aendern	*/
				schach("weiss",ptr);
			}
		}
		else if(ch != smenu[4][0])
			beep();
	}
	while(ch != smenu[4][0]);	/* Ende ?		*/

	delwin(setupwin);		/* Fenster aus		*/
	setupwin=(WINDOW *)0;
	touchwin(stdscr);
}

static	void	ad_piece(ch)

char	ch;
{
	char	str[STRLEN],str2[STRLEN];	/* String	*/
	int	i;
	static	char	*ofigtab="bsltdkBSLTDK.";

	wmove(setupwin,9,2);		/* in Position			*/
	strcpy(str2,figtab);		/* Space durch Punkt ersetzen	*/
	str2[strlen(str2)-1]='.';
	waddstr(setupwin,str2);		/* Figurenliste	*/

	strcpy(str,"setze ");		/* aufbereiten	*/

	wmove(setupwin,8,2);		/* in Position	*/
	waddstr(setupwin,doset);	/* Meldung	*/
	waddch(setupwin,ch|A_UNDERLINE);		/* ausgeben	*/
	sprintf(str+strlen(str),"%%c%c",(char)ch);	/* aufbereiten	*/
	wrefresh(setupwin);

l1:	ad_read(0,&ch,1);	/* einlesen	*/
	if(ch=='\b')		/* zurueck ?	*/
	{
		waddstr(setupwin,"\b \b");
		str[strlen(str)-1]=0;
		wrefresh(setupwin);
		goto l5;
	}
	if(ch<(int)'1' || ch>(int)'8')
	{
		beep();
		goto l1;
	}
	waddch(setupwin,ch|A_UNDERLINE);	/* ausgeben	*/
	sprintf(str+strlen(str),"%c",(char)ch);	/* aufbereiten	*/
	waddch(setupwin,(int)'='|A_UNDERLINE);
	wrefresh(setupwin);
	
l2:	ad_read(0,&ch,1);		/* einlesen	*/
	if(ch=='\b')		/* zurueck ?	*/
	{
		waddstr(setupwin,"\b \b");
		str[strlen(str)-1]=0;
		waddstr(setupwin,"\b \b");
		str[strlen(str)-1]=0;
		wrefresh(setupwin);
		goto l1;
	}

	for(i=0;str2[i]!='\0';i++)
		if(str2[i]==ch)
			break;

	if(figtab[i]=='\0')	/* nicht gefunden	*/
	{
		beep();
		goto l2;
	}
	waddch(setupwin,ch|A_UNDERLINE);	/* ausgeben	*/
	sprintf(str2,str,ofigtab[i]);		/* aufbereiten	*/
	wrefresh(setupwin);

	schach(str2,ptr);	/* ziehen	*/
	if(ptr[0][0]!='?')	/* zug ok ?	*/
		ad_brett();
	else			/* falscheingabe	*/
		beep();

l5:	wmove(setupwin,8,2);		/* in Position	*/
	for(i=0;i<16;i++)		/* loschen	*/
		waddstr(setupwin," ");

	wmove(setupwin,9,2);		/* in Position	*/
	for(i=0;i<16;i++)		/* loschen	*/
		waddstr(setupwin," ");
	wrefresh(setupwin);
}
