/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Bildschirmaufbau			*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>

#include "ad.h"
#include "patchlevel.h"

/****************************************************************/
/*	Spielmenue-Screen					*/
/****************************************************************/

void	ad_game_screen()

{
	int 	x,y;
	int	ch;

	attrset(0);			/* Alle Attribute aus	*/
	erase();			/* loeschen		*/

	for(x=0;x<8*5;x++)		/* Alle Felder aufbauen	*/
	for(y=0;y<8*3;y++)
	{				/* schwarz oder weiss ? */
		if(y==0 || y==23)	/* oberste o. unterste	*/
		{			/* Reihe ?		*/
			if(!((x-2)%5))	/* Beschriftung ?	*/
				ch=(x+2)/5+(int)'a'|A_REVERSE;
			else		/* Keine Beschriftung	*/
				ch=(int)' '|A_REVERSE;
		}
		else
  			ch=(int)' '|A_BOLD;	/* Normales Feld	*/
	
		if(!((x/5)%2) ^ ((y/3)%2))	/* schw. Feld ?	*/
			ch |= A_REVERSE;

		mvaddch(y,x+1,ch);	/* eintragen		*/
	}

	for(y=0;y<8*3;y++)		/* Linie ziehen		*/
	{
		if(!((y-1)%3))	/* Beschriftung ?	*/
			ch=7-(y+1)/3+(int)'1'|A_REVERSE;
		else		/* Keine Beschriftung	*/
			ch=(int)' '|A_REVERSE;

		mvaddch(y,8*5+1,ch);
		mvaddch(y,0,ch);
	}

 	attrset(A_REVERSE);	/* Invers ein		*/
  	mvaddstr(0 ,2+5*8,"UNIX-Chess V2.7 (c) 1991 by M.Laukien ");
	attrset(0);

	attrset(A_REVERSE);	/* Invers ein		*/
	mvaddstr(18,2+5*8,"       ");
	addstr(figlist);	/* Geschlagene Figuren	*/
	for(x=stdscr->_curx;x<79;x++)
		addstr(" ");
	attrset(0);

	for(y=0;y<23;y++)	/* Rand			*/
		mvaddch(y,79,(int)' '|A_REVERSE);

	for(x=2+5*8;x<79;x++)	/* Rand			*/
		mvaddch(23,x,(int)' '|A_REVERSE);
}

/****************************************************************/
/*	Spielmenue ausgeben					*/
/****************************************************************/

void	ad_menu()

{
	int y=4;			/* Koordinaten	*/
	int x;
	char str[STRLEN];		/* String	*/
	char c1=' ',c2=' ';

	attrset(0);			/* Alle Attribute aus	*/

	if(TURNIER())			/* Turnierspiel	?	*/
		c1='*';

	sprintf(str,"%c%s%d",c1,menu[0]+1,level+1);/* LEVEL	*/
	mvaddstr(++y,MPOS-1,str);
	for(x=stdscr->_curx;x<79;x++)	/* Rest der Zeile loeschen	*/
		mvaddch(y,x,(int)' ');
	sprintf(str,"%c%s%s",c1,menu[1]+1,wei ?
	(TURNGEG() ? gegner:comp) :getlogin());
	mvaddstr(++y,MPOS-1,str);	/* WEISS		*/
	for(x=stdscr->_curx;x<79;x++)	/* Rest der Zeile loeschen	*/
		mvaddch(y,x,(int)' ');
	sprintf(str,"%c%s%s",c1,menu[2]+1,sch ?
	(TURNGEG() ? gegner:comp) :getlogin());
	mvaddstr(++y,MPOS-1,str);	/* SCHWARZ		*/
	for(x=stdscr->_curx;x<79;x++)	/* Rest der Zeile loeschen	*/
		mvaddch(y,x,(int)' ');
	if(TURNGEG())
	sprintf(str,"%c%s%s",c1,menu[3]+1,modus & 128 ? ison:isoff);
	else
	sprintf(str,"%c%s%s%c",' ',menu[3]+1,modus & 128 ? ison:isoff,' ');
	mvaddstr(++y,MPOS-1,str);	/* ANALYSE		*/
	for(x=stdscr->_curx;x<79;x++)	/* Rest der Zeile loeschen	*/
		mvaddch(y,x,(int)' ');
	sprintf(str,"%c%s",c1,menu[4]+1);
	mvaddstr(++y,MPOS-1,str);		/* SETUP		*/
	sprintf(str,"%c%s",c1,menu[5]+1);
	mvaddstr(++y,MPOS-1,str);		/* ZURUECK		*/
	sprintf(str," %s ",menu[6]+1);
	mvaddstr(++y,MPOS-1,str);		/* INFO			*/
	sprintf(str," %s ",menu[7]+1);
	mvaddstr(++y,MPOS-1,str);		/* NEUSTART		*/
	sprintf(str," %s ",menu[8]+1);
	mvaddstr(++y,MPOS-1,str);		/* ENDE			*/
	sprintf(str,"%c%s",c1,menu[9]+1);
	mvaddstr(++y,MPOS-1,str);		/* BREAK		*/

}

/****************************************************************/
/*	Adm.-Menue-Screen					*/
/****************************************************************/

void	ad_admin_screen()

{
	int 	x,y;
	char	*header1=
"UNIX-Chess V2.7 PL%-2d      (c) 1991 by Marc Laukien     ";
	char	*header2=
"Opening-Library           (c) 1990 by Christoph Thommes";
	char	str[STRLEN];

	sprintf(str,header1,PATCHLEVEL);/* aufbereiten		*/

	attrset(0);			/* Alle Attribute aus	*/
	erase();			/* loeschen		*/

	for(x=0;x<79;x++)		/* Bildschirmrand aufb.	*/
	{
		mvaddch(0,x,(int)' '|A_REVERSE);
		mvaddch(1,x,(int)' '|A_REVERSE);
		mvaddch(23,x,(int)' '|A_REVERSE);
	}

	for(y=0;y<23;y++)		/* Bildschirmrand aufb.	*/
	{
		mvaddch(y,0,(int)' '|A_REVERSE);
		mvaddch(y,79,(int)' '|A_REVERSE);
	}

 	attrset(A_REVERSE);		/* Invers ein		*/
  	mvaddstr(0 ,ADM_RAND,str);
  	mvaddstr(1 ,ADM_RAND,header2);
}

/****************************************************************/
/*	Adm.-Menue ausgeben					*/
/****************************************************************/

void	ad_amenu()

{
	int 	x,y=3;			/* Koordinaten		*/
	char	str[STRLEN];

	attrset(A_BOLD);		/* Hell ein		*/

	sprintf(str,"%s",amenu[0]+1);
	mvaddstr(y,ADM_RAND,str);		/* TRAINING		*/
	sprintf(str,"%s",amenu[1]+1);
	mvaddstr(++y,ADM_RAND,str);		/* ZEIGE TRAININGSSP.	*/
	sprintf(str,"%s",amenu[2]+1);
	mvaddstr(++y,ADM_RAND,str);		/* LOESCHE TRAININGSSP.	*/

	attrset(A_NORMAL);		/* Hell aus		*/

	y+=2;
	for(x=1;x<79;x++)			/* Trennstrich aufb.	*/
		mvaddch(y,x,(int)'-'|A_NORMAL);

	attrset(A_BOLD);		/* Hell ein		*/

	sprintf(str,"%s",amenu[3]+1);
	mvaddstr(y+=2,ADM_RAND,str);		/* TURNIER WEISS COMP	*/
	sprintf(str,"%s",amenu[4]+1);
	mvaddstr(++y,ADM_RAND,str);		/* TURNIER SCHWARZ COMP	*/
	sprintf(str,"%s",amenu[5]+1);
	mvaddstr(y+=2,ADM_RAND,str);		/* TURNIER WEISS	*/
	sprintf(str,"%s",amenu[6]+1);
	mvaddstr(++y,ADM_RAND,str);		/* TURNIER SCHWARZ	*/
	sprintf(str,"%s",amenu[7]+1);
	mvaddstr(y+=2,ADM_RAND,str);		/* ZEIGE TURNIERSP.	*/
	sprintf(str,"%s",amenu[8]+1);
	mvaddstr(++y,ADM_RAND,str);		/* ZEIGE HIGHSCORE	*/

	attrset(A_NORMAL);		/* Hell aus		*/

	y+=2;
	for(x=1;x<79;x++)			/* Trennstrich aufb.	*/
		mvaddch(y,x,(int)'-'|A_NORMAL);

	attrset(A_BOLD);		/* Hell ein		*/

	sprintf(str,"%s",amenu[9]+1);
	mvaddstr(y+=2,ADM_RAND,str);		/* ENDE			*/
}


