/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Highscore				*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include "ad.h"

/****************************************************************/
/*	Highscoreeintrag anhaengen				*/
/****************************************************************/

void	ad_addscore(stat)

char	stat;	/* Status	*/
{
	FILE 	*fp;
	long	ti;

	ad_locksc();	/* locken	*/

	if((fp=fopen("score.list","a"))==(FILE *)0)	/* oeffnen	*/
	{
		ad_error("");
		return;
	}

	ti=time((long *)0);

	fprintf(fp,"%c	%s	",
	stat,
	wei==0 ? ad_id(getlogin()):ad_id(gegner));

	fprintf(fp,"%s	",
	sch==0 ? ad_id(getlogin()):ad_id(gegner));

	fprintf(fp,"# %s vs. %s	%s",
	wei==0 ? getlogin(): gegner[0]=='~' ? comp:gegner,
	sch==0 ? getlogin(): gegner[0]=='~' ? comp:gegner,
	ctime(&ti));	/* Datum	*/

	fclose(fp);		/* schliessen	*/

	ad_unlocksc();		/* unlocken	*/
}

/****************************************************************/
/*	Highscoreeintrag anhaengen fuer expire			*/
/****************************************************************/

void	ad_addscore_expire(stat,white,black)

char	stat;		/* Status	*/
char	*white,*black;	/* Spieler	*/
{
	FILE 	*fp;
	long	ti;

	ad_locksc();	/* locken	*/

	if((fp=fopen("score.list","a"))==(FILE *)0)	/* oeffnen	*/
	{
		ad_error("");
		return;
	}

	ti=time((long *)0);

	fprintf(fp,"%c	%s	",stat,ad_id(white));
	fprintf(fp,"%s	",ad_id(black));

	fprintf(fp,"# (exp) %s vs. %s	%s",white,black,ctime(&ti));
				/* Kommentar */

	fclose(fp);		/* schliessen	*/

	ad_unlocksc();		/* unlocken	*/
}

/****************************************************************/
/*	Highscore ausgeben					*/
/****************************************************************/

void	ad_showscore()

{
	FILE	*fp;
	char	c,s1[STRLEN],s2[STRLEN],str[STRLEN];
	int	i,j,y=2,nr=0;
	char	*my_id;

	struct
	{
		char	id[7];	/* User-ID			*/
		double	score;	/* Punkte			*/
		int	nr;	/* Anzahl der Spiele		*/
		int	comp;	/* Davon gegen den Computer	*/
	} score[1000],copy;

	if((fp=fopen("score.list","r"))==(FILE *)0)	/* oeffnen	*/
	{
		ad_error("");
		return;
	}

	while(!feof(fp) && nr<1000)	/* Dateiende ?	*/
	{
		if(fgets(str,STRLEN,fp)==(char *)0)	/* einlesen 	*/
			continue;
		sscanf(str,"%c %s %s",&c,s1,s2);

		for(i=0;i<nr;i++)	/* Spieler 1 suchen		*/
			if(!strcmp(score[i].id,s1))
				break;

		if(i==nr)	/* Neueintrag ?		*/
		{
			strcpy(score[i].id,s1);	/* Name kopieren	*/
			score[i].score=1000.0;	/* Punkte		*/
			score[i].nr=0;
			score[i].comp=0;
			nr++;
		}

		for(j=0;j<nr;j++)	/* Spieler 2 suchen		*/
			if(!strcmp(score[j].id,s2))
				break;

		if(j==nr)	/* Neueintrag ?		*/
		{
			strcpy(score[j].id,s2);	/* Name kopieren	*/
			score[j].score=1000.0;	/* Punkte		*/
			score[j].nr=0;
			score[j].comp=0;
			nr++;
		}
		
		score[i].nr++;	/* Ein Spiel mehr	*/
		score[j].nr++;

		if(s1[0] == '~')	/* Computer ?	*/
			score[j].comp++;
		if(s2[0] == '~')
			score[i].comp++;

		switch(c)	/* Score veraendern	*/
		{
		case 'w':	/* Gewinn Weiss	*/
		case 'W':
			score[i].score += score[j].score/4;
			score[j].score -= score[j].score/4;
			break;

		case 'b':	/* Gewinn Schwarz	*/
		case 'B':
			score[j].score += score[i].score/4;
			score[i].score -= score[i].score/4;
			break;
		}	
	}

	fclose(fp);

	ad_admin_screen();	/* Bildaufbau			*/
	attrset(A_UNDERLINE|A_BOLD);	/* Unterstreichen und Hell	*/
	mvaddstr(y,1,scorelist);
	attrset(0);			/* Attribute aus		*/

	for(i=0  ;i<nr-1;i++)			/* sortieren		*/
	for(j=i+1;j<nr  ;j++)
		if(score[i].score < score[j].score)
		{
		memcpy((char *)&copy,(char *)&score[i],sizeof(copy));
		memcpy((char *)&score[i],(char *)&score[j],sizeof(copy));
		memcpy((char *)&score[j],(char *)&copy,sizeof(copy));
		}

	my_id=ad_id(getlogin());	/* ID des Benutzers	*/

	for(i=0;i<nr;i++)
	{
		if(y==21)		/* Bildschirmende ?	*/
		{
			attrset(A_BOLD);/* Hell */
			mvaddstr(++y,ADM_RAND,press_key);	/* TASTE */
			move(23,79);
			refresh();		/* ausgeben	*/

			ad_read(0,&c,1);	/* auf Taste warten */

			ad_admin_screen();	/* Bildaufbau	*/

			y=2;
			attrset(A_UNDERLINE|A_BOLD);
			mvaddstr(y,1,scorelist);
			attrset(0);		/* Attribute aus */
		}

		sprintf(s1,"%6.0lf",score[i].score);
		sprintf(s2,"%d",score[i].nr);
		sprintf(str,"%d",score[i].comp);

		if(!strcmp(my_id,score[i].id))
			attrset(A_BLINK);	/* Blinken */
		else if(i<3)	/* Top 3 ?	*/
			attrset(A_BOLD);	/* Hell */
		else
			attrset(0);		/* Normal */

		mvaddstr(++y,ADM_RAND,ad_revid(score[i].id));
		mvaddstr(y,ADM_RAND+15,s2);
		mvaddstr(y,ADM_RAND+30,str);
		mvaddstr(y,ADM_RAND+45,s1);	/* ausgeben	*/
	}

	fclose(fp);
	
	attrset(A_BOLD);			/* Hell 		*/
	mvaddstr(++y,ADM_RAND,press_key);	/* TASTE		*/
	move(23,79);
	refresh();			/* ausgeben		*/

	ad_read(0,&c,1);		/* auf Taste warten	*/
}

