/*----------------------------------------------------------------------*/
/*									*/
/*	Name:			Chess V2.7				*/
/*	                                                                */
/*	Programmteil:		externe Strings einlesen		*/
/*									*/
/*	Library:		UNIX V	+ lex				*/
/*									*/
/*	Autor:			Marc Laukien				*/
/*									*/
/*----------------------------------------------------------------------*/

%{
#include	<string.h>
#include	<ctype.h>

extern	char	*malloc();
extern	void	exit();

extern	char	*pname;			/* Programmname		*/
extern	char	def[];			/* Definitionfile	*/
extern 	int	errno;			/* Fehlernummer 	*/
extern 	char	*sys_errlist[];		/* Fehlertexte 		*/

extern	int	atoi();

void	lex();
static	void	insert();
static	int	getnr();

static	char 	str[100];		/* String 		*/

char	*amenu[10];			/* Adm.menuestrings	*/
char	*menu[10];			/* Menuestrings		*/
char	*smenu[5];			/* Setup-Menuestrings	*/
char	*info[10];			/* Infostrings		*/
char	*tr_lv;				/* Trainingslevel	*/
char	*to_lv;				/* Turnierlevel		*/
char	*press_key;			/* <Taste>		*/
char	*tlist;				/* Ueberschrift Turnier	*/
char	*ulist;				/* Ueberschrift Training*/
char	*scorelist;			/* Ueberschrift Score	*/
char	*sure;				/* Sicherheitsabfrage	*/
char	*give_up;			/* Aufg. Abfrage	*/
char	*figtab;			/* Figurentab.		*/
char	*comp;				/* Computername		*/
char	*white,*black;			/* Farben		*/
char	*domove;			/* Zug			*/
char	*doset;				/* Setup		*/
char	*enter;				/* Namen eing.		*/
char	*opponent;			/* Gegner eing.		*/
char	*error;				/* Fehler		*/
char	*not_allowed;			/* nicht erlaubt	*/
char	*no_user;			/* kein User		*/
char	*figlist;			/* geschl. Fig.		*/
char	*ison,*isoff;			/* Ein/Aus		*/
char	*thinking;			/* Comp. denkt		*/
char	*is_thinking;			/* Gegner denkt		*/
char	*load_lib;			/* Lade Eroeffnungen	*/
char	*startcmd;			/* Startkommando	*/
char	*patt,*w_mate,*b_mate;		/* Status		*/
char	*w_up,*b_up;
char	*w_chess,*b_chess;
char	*remis_3;

%}

T	[ \t]
S	\".*\"
N	"["[0-9]*"]"
%%
#.*\n			{ ;	/* Kommentar */		}
"amenu"{N}{T}*{S}	{	insert(&amenu[getnr()]);}
"menu"{N}{T}*{S}	{	insert(&menu[getnr()]);	}
"smenu"{N}{T}*{S}	{	insert(&smenu[getnr()]);}
"info"{N}{T}*{S}	{	insert(&info[getnr()]);	}
"tr_lv"{T}*{S}		{	insert(&tr_lv);		}
"to_lv"{T}*{S}		{	insert(&to_lv);		}
"press_key"{T}*{S}	{	insert(&press_key);	}
"tlist"{T}*{S}		{	insert(&tlist);		}
"ulist"{T}*{S}		{	insert(&ulist);		}
"scorelist"{T}*{S}	{	insert(&scorelist);	}
"sure"{T}*{S}		{	insert(&sure);		}
"give_up"{T}*{S}	{	insert(&give_up);	}
"comp"{T}*{S}		{	insert(&comp);		}
"figtab"{T}*{S}		{	insert(&figtab);	}
"white"{T}*{S}		{	insert(&white);		}
"black"{T}*{S}		{	insert(&black);		}
"domove"{T}*{S}		{	insert(&domove);	}
"doset"{T}*{S}		{	insert(&doset);		}
"enter"{T}*{S}		{	insert(&enter);		}
"opponent"{T}*{S}	{	insert(&opponent);	}
"error"{T}*{S}		{	insert(&error);		}
"not_allowed"{T}*{S}	{	insert(&not_allowed);	}
"no_user"{T}*{S}	{	insert(&no_user);	}
"figlist"{T}*{S}	{	insert(&figlist);	}
"ison"{T}*{S}		{	insert(&ison);		}
"isoff"{T}*{S}		{	insert(&isoff);		}
"thinking"{T}*{S}	{	insert(&thinking);	}
"is_thinking"{T}*{S}	{	insert(&is_thinking);	}
"load_lib"{T}*{S}	{	insert(&load_lib);	}
"startcmd"{T}*{S}	{	insert(&startcmd);	}
"patt"{T}*{S}		{	insert(&patt);		}
"w_mate"{T}*{S}		{	insert(&w_mate);	}
"b_mate"{T}*{S}		{	insert(&b_mate);	}
"w_up"{T}*{S}		{	insert(&w_up);		}
"b_up"{T}*{S}		{	insert(&b_up);		}
"w_chess"{T}*{S}	{	insert(&w_chess);	}
"b_chess"{T}*{S}	{	insert(&b_chess);	}
"remis_3"{T}*{S}	{	insert(&remis_3);	}

[ \t\n]			{ ;	/* Leerstellen, Tabs und Newline ignorieren */	}
.			{ 	fprintf(stderr,
				"%s: syntax error in %s at line %d\n"
				,pname,str,yylineno);
				ad_deinit();
				exit(1);
			}	/* Fehler */
%%

void	lex()
{
	FILE *fp;				/* Filepointer 		*/

	sprintf(str,"def.%s",def);		/* aufbereiten */
	if((fp=fopen(str,"r"))==(FILE *)0)	/* oeffnen */
	{
		fprintf(stderr,"%s: %s\n",pname,sys_errlist[errno]);
		ad_deinit();
		exit(1);
	}

	yyin = fp;		/* Input setzen */

	yylex();

	fclose(fp);		/* schliessen */
}

static	void	insert(pt)	/* String einfuegen */
char 	**pt;
{
	char st[100];
	char *s;
	int i;

	s=st;

	strcpy(s,yytext);
	while(*s != '"')
		s++;
	s++;

	i=0;
	while(s[i] != '"')
		i++;
	s[i]=0;

	*pt=(char *)malloc((unsigned)(strlen(s)+1));
	strcpy(*pt,s);
}

static	int	getnr()		/* Stringnummer holen */
{
	char st[100];
	char *s;
	int i;

	s=st;

	strcpy(s,yytext);
	while(!isdigit(*s))
		s++;

	i=0;
	while(isdigit(s[i]))
		i++;
	s[i]=0;

	return(atoi(s));
}

