/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Administrationsmenue			*/
/*								*/
/****************************************************************/

#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <curses.h>
#include <stdio.h>
#include <ctype.h>

#include "ad.h"

/****************************************************************/
/*	Menueeingabe						*/
/****************************************************************/

void	ad_admin()

{
	char	ch;		/* Zeichen zum Einlesen		*/

	ad_admin_screen();	/* Bildaufbau			*/
	ad_amenu();
	move(23,79);
	refresh();		/* ausgeben			*/

	while(1)
	{
		ad_read(0,&ch,1);		/* einlesen	*/
		if(isupper(ch))			/* gross ?	*/
			ch=tolower(ch);

		ad_flush();	/* restliche Zeichen wegwerfen	*/


		if(ch==amenu[0][0])		/*** Uebungsspiel	***/
		{
			gegner[0]=0;		/* Computer ist Gegner	*/
			ad_game();

			ad_admin_screen();	/* Bildaufbau		*/
			ad_amenu();
			move(23,79);
			refresh();		/* ausgeben		*/
		}
		else if(ch==amenu[1][0])	/*** Trainingssp. zeigen ***/
		{
			ad_uliste();

			ad_admin_screen();	/* Bildaufbau		*/
			ad_amenu();
			move(23,79);
			refresh();		/* ausgeben		*/
		}
		else if(ch==amenu[2][0])	/*** Trainingssp. loeschen ***/
		{
			char	*s;
			char	str[STRLEN*2];

			s=ad_name('f');

			sprintf(str,"%s.ch",s);
			if(unlink(str) == -1)	/* loeschen		*/
				ad_error("");

			ad_admin_screen();	/* Bildaufbau		*/
			ad_amenu();
			move(23,79);
			refresh();		/* ausgeben		*/
		}
		else if(ch==amenu[3][0])	/*** Weiss gegen Comp. ***/
		{
			strcpy(gegner,"~");
			wei=0;
			sch=1;
			ad_game();

			ad_admin_screen();	/* Bildaufbau		*/
			ad_amenu();
			move(23,79);
			refresh();		/* ausgeben		*/
		}
		else if(ch==amenu[4][0])	/*** Schw. gegen Comp. ***/
		{
			strcpy(gegner,"~");
			wei=1;
			sch=0;
			ad_game();

			ad_admin_screen();	/* Bildaufbau		*/
			ad_amenu();
			move(23,79);
			refresh();		/* ausgeben		*/
		}
		else if(ch==amenu[5][0])	/*** Weiss gegen Spieler ***/
		{
			strcpy(gegner,ad_name('g'));
			if(gegner[0]=='\0')	/* Kein Gegner ?	*/
				continue;
			wei=0;
			sch=1;
			ad_game();

			ad_admin_screen();	/* Bildaufbau		*/
			ad_amenu();
			move(23,79);
			refresh();		/* ausgeben		*/
		}
		else if(ch==amenu[6][0])	/*** Schw. gegen Spieler ***/
		{
			strcpy(gegner,ad_name('g'));
			if(gegner[0]=='\0')	/* Kein Gegner ?	*/
				continue;
			wei=1;
			sch=0;
			ad_game();

			ad_admin_screen();	/* Bildaufbau		*/
			ad_amenu();
			move(23,79);
			refresh();		/* ausgeben		*/
		}
		else if(ch==amenu[7][0])	/*** Turniersp. zeigen ***/
		{
			ad_tliste();

			ad_admin_screen();	/* Bildaufbau		*/
			ad_amenu();
			move(23,79);
			refresh();		/* ausgeben		*/
		}
		else if(ch==amenu[8][0])	/*** Highscoreliste zeigen ***/
		{
			ad_showscore();

			ad_admin_screen();	/* Bildaufbau		*/
			ad_amenu();
			move(23,79);
			refresh();		/* ausgeben		*/
		}
		else if(ch==amenu[9][0])	/*** Ende	***/
		{
			if(ad_sure('s'))
				break;
		}
		else if(ch!=' ')		/* Space wird ign.	*/
			beep();			/*** Fehler	***/
	}
}

/****************************************************************/
/*	Turnierspielliste					*/
/****************************************************************/

void	ad_tliste()

{
	char	c;
	int	i,j,y=2;
	DIR	*dir;		/* Directory - Pointer		*/
	struct	dirent	*dp;	/* Pointer auf Eintrag		*/
	char	str[STRLEN],str2[STRLEN];	/* String	*/
	char	*s[3];

	ad_admin_screen();	/* Bildaufbau			*/
	attrset(A_UNDERLINE|A_BOLD);	/* Unterstreichen und Hell	*/
	mvaddstr(y,1,tlist);
	attrset(0);			/* Attribute aus		*/

	if( (dir=opendir("save"))==(DIR *)0 )	/* oeffnen	*/
	{
		ad_error("");		/* Fehler		*/
		return;
	}

	while( (dp=readdir(dir)) != (struct dirent *)0 )  /* Ende ?	*/
	{
		strcpy(str,dp->d_name);	/* kopieren		*/

		i=0;
		j=0;
		s[j++]=str;
		while(str[i]!='\0')		/* String aufbereiten	*/
		{
			if(str[i]=='.')
			{
				str[i++]='\0';	/* beenden	*/
				s[j++]=str+i;
			}

			if(j>=3)
				break;

			i++;
		}

		if(j==3)			/* Spiel gefunden ?	*/
		{
			if(y==21)		/* Bildschirmende ?	*/
			{
				attrset(A_BOLD);/* Hell */
				mvaddstr(++y,ADM_RAND,press_key);	/* TASTE */
				move(23,79);
				refresh();		/* ausgeben	*/

				ad_read(0,&c,1);	/* auf Taste warten */

				ad_admin_screen();	/* Bildaufbau	*/

				y=2;
				attrset(A_UNDERLINE|A_BOLD);
				mvaddstr(y,1,tlist);
				attrset(0);		/* Attribute aus */
			}

			if(!strcmp(ad_id(getlogin()),s[0]))
				attrset(A_BOLD);	/* Hell		*/
			else
				attrset(0);		/* Normal	*/
			mvaddstr(++y,ADM_RAND,ad_revid(s[0]));
							/* ausgeben	*/

			if(!strcmp(ad_id(getlogin()),s[1]))
				attrset(A_BOLD);	/* Hell		*/
			else
				attrset(0);		/* Normal	*/
			mvaddstr(y,ADM_RAND+15,ad_revid(s[1]));
							/* ausgeben	*/

			sprintf(str2,"loadinfo save/%s.%s",s[0],s[1]);
						/* Kommandostring 	*/
			schach(str2,ptr);	/* Info anfordern 	*/

			if(!strcmp(ad_id(getlogin()),ptr[0][0]=='w' ? s[0]:s[1]))
				attrset(A_BOLD|A_BLINK);/* Hell & Blink	*/
			else
				attrset(0);		/* Normal	*/

			mvaddstr(y,ADM_RAND+30,ptr[1]);	/* Zuege	*/
							/* Farbe	*/
			mvaddstr(y,ADM_RAND+45,ptr[0][0]=='w' ? white:black);

			refresh();
		}
	}

	closedir(dir);
	
	attrset(A_BOLD);			/* Hell 		*/
	mvaddstr(++y,ADM_RAND,press_key);	/* TASTE		*/
	move(23,79);
	refresh();			/* ausgeben		*/

	ad_read(0,&c,1);		/* auf Taste warten	*/
}

/****************************************************************/
/*	Trainingsspielliste					*/
/****************************************************************/

void	ad_uliste()

{
	char	c;
	int	i,j,y=2;
	DIR	*dir;		/* Directory - Pointer		*/
	struct	dirent	*dp;	/* Pointer auf Eintrag		*/
	char	str[STRLEN],str2[STRLEN];	/* String	*/
	char	*s[3];

	ad_admin_screen();	/* Bildaufbau			*/
	attrset(A_UNDERLINE|A_BOLD);	/* Unterstreichen und Hell	*/
	mvaddstr(y,1,ulist);
	attrset(0);			/* Attribute aus		*/

	if( (dir=opendir("training"))==(DIR *)0 )	/* oeffnen	*/
	{
		ad_error("");		/* Fehler		*/
		return;
	}

	while( (dp=readdir(dir)) != (struct dirent *)0 )  /* Ende ?	*/
	{
		strcpy(str,dp->d_name);	/* kopieren		*/

		i=0;
		j=0;
		s[j++]=str;
		while(str[i]!='\0')		/* String aufbereiten	*/
		{
			if(str[i]=='.')
			{
				str[i++]='\0';	/* beenden	*/
				s[j++]=str+i;
			}

			if(j>=3)
				break;

			i++;
		}

		if(j==3)			/* Spiel gefunden ?	*/
		{
			if(y==21)		/* Bildschirmende ?	*/
			{
				attrset(A_BOLD);/* Hell */
				mvaddstr(++y,ADM_RAND,press_key);	/* TASTE */
				move(23,79);
				refresh();		/* ausgeben	*/

				ad_read(0,&c,1);	/* auf Taste warten */

				ad_admin_screen();	/* Bildaufbau	*/

				y=2;
				attrset(A_UNDERLINE|A_BOLD);
				mvaddstr(y,1,ulist);
				attrset(0);		/* Attribute aus */
			}

			attrset(0);			/* Attribute aus */

			if(strcmp(s[0],ad_id(getlogin())))
						/* Anderer Spieler ? 	*/
				continue;

			mvaddstr(++y,ADM_RAND,ad_revid(s[0]));
			mvaddstr(y,ADM_RAND+15,s[1]);	/* ausgeben	*/

			sprintf(str2,"loadinfo training/%s.%s",s[0],s[1]);
						/* Kommandostring 	*/
			schach(str2,ptr);	/* Info anfordern 	*/

			mvaddstr(y,ADM_RAND+30,ptr[1]);	/* Zuege	*/
							/* Farbe	*/
			mvaddstr(y,ADM_RAND+45,ptr[0][0]=='w' ? white:black);

			refresh();
		}
	}

	closedir(dir);
	
	attrset(A_BOLD);			/* Hell 		*/
	mvaddstr(++y,ADM_RAND,press_key);	/* TASTE		*/
	move(23,79);
	refresh();			/* ausgeben		*/

	ad_read(0,&c,1);		/* auf Taste warten	*/
}

