#ifndef LINT
static char COPYRIGHT[]="\
  COPYRIGHT --- COPYRIGHT --- COPYRIGHT --- COPYRIGHT \n\
  This program is copyright 1989 Nils McCarthy. This \
  program may be distributed if it is impossible for \
  the distributor to get a more up-to-date-version of \
  it. \n\
  COPYRIGHT --- COPYRIGHT --- COPYRIGHT --- COPYRIGHT \n\
  ";
static char AUTHOR[]="Copyright 1989 Nils McCarthy";
#endif /* LINT */

#include "unidraw.h"
mapkey(name,key)
 char *name;
 char key;
{
   if(!strcmp(name,"up"))
      up=key;
   else if(!strcmp(name,"down"))
      down=key;
   else if(!strcmp(name,"right"))
      right=key;
   else if(!strcmp(name,"left"))
      up_left=key;
   else if(!strcmp(name,"up_left"))
      up_right=key;
   else if(!strcmp(name,"up_right"))
      down_left=key;
   else if(!strcmp(name,"down_left"))
      down_right=key;
   else if(!strcmp(name,"down_right"))
      down_right=key;
   else if(!strcmp(name,"pentoggle"))
      pentoggle=key;
   else if(!strcmp(name,"penkey"))
      penkey=key;
   else if(!strcmp(name,"special"))
      special=key;
   else if(!strcmp(name,"brk"))
      brk=key;
   else if(!strcmp(name,"suspend"))
      suspend=key;
   else {
      fprintf(stderr,"setenv misformat: %s=%c\n",name,key);
      sleep(5);
   }
}


keymaps()
{
   char *beginname,*endname;
   char name[80];
   if(vi) {
      up='k';
      down='j';
      right='l';
      left='h';
      up_right='u';
      up_left='y';
      down_right='n';
      down_left='b';
   } else {
      up='8';
      down='2';
      right='6';
      left='4';
      up_right='9';
      up_left='7';
      down_right='3';
      down_left='1';
   }
   suspend=25;
   pentoggle='p';
   penkey='\\';
   brk=3;
   redr='';
   special='>';
   if(getenv("UNIDRAW")==NULL)
      return;
   beginname=(char *) getenv("UNIDRAW");
   endname=beginname; /* so if it isn't setenv'd to anything... */
   while(*beginname!=NULL) {
      name[0]=NULL;
      for(endname=beginname;*endname!='=';endname++) {
	 name[strlen(name)+1]=NULL;
	 name[strlen(name)]= (*endname);
      }
      if(*(endname+2)!=',' && *(endname+2)!=NULL) {
	 fprintf(stderr,"environment misusage.\n");
	 exit(-1);
      }
      mapkey(name,*(endname+1));
      beginname=endname+3;
      if(*(endname+2)=NULL)
	 beginname--;
   }
}

