/* $Id: usertree.c,v 3.3 1991/09/01 14:02:51 piggy Rel $
 * Users list maintenance. Users are kept in a binary tree.
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * int	InsertUser(char * user);
 *      Look for user in the users tree: if it is already there, return a
 *      pointer to it, otherwise make an entry and reset its info.
 *
 * void EnquiryUser(void (*funct)(userrep_t user))
 *      For each node in the tree, process it using the funct function with
 *      the userrep_t struct as parameter. It is a void function.
 *
 * void KillUser(char * user);
 *	Make user a phantom user,do not display its info in any of the report.
 */

#include    <stdio.h>
#include    "mem.h"
#include    <string.h>
#include    "hdbstat.h"

typedef struct usertree
{
  userrep_t Node;
  struct usertree *L;
  struct usertree *R;
} usertree_t;

#define	TNULL	(usertree_t *) NULL

static FlistHead UserFlist =
{
  0, 0, 0
};

static usertree_t *Root = TNULL;

static userrep_t *
UserTree (tree, user)
     usertree_t **tree;
     char *user;

{
  int cmpres;

  if (*tree == TNULL)
    {
      register userrep_t *sr;

      if (UserFlist.size == 0)
	MemInit (&UserFlist, sizeof (struct usertree), 20, 10);
      *tree = (usertree_t *) new (&UserFlist);
      (*tree)->L = (*tree)->R = TNULL;
      sr = &((*tree)->Node);
      sr->User = strdup (user);
      sr->Killed = FALSE;
      sr->Commands = (Tcommrep_t) NULL;
      return (&(*tree)->Node);
    }
  else if ((cmpres = strcmp (user, (*tree)->Node.User)) < 0)
    return UserTree (&(*tree)->L, user);
  else if (cmpres > 0)
    return UserTree (&(*tree)->R, user);
  else
    return (&(*tree)->Node);
}

userrep_t *
InsertUser (user)
     char *user;

{
  return UserTree (&Root, user);
}

void 
KillUser (user)
     char *user;

{
  UserTree (&Root, user)->Killed = TRUE;
}

static void 
ProcUserTree (tree, funct)
     usertree_t *tree;
     void (*funct) ();

{
  if (tree != TNULL)
    {
      ProcUserTree (tree->L, funct);
      if (!(tree->Node.Killed))
	(*funct) (tree->Node);
      ProcUserTree (tree->R, funct);
    }
}

void 
EnquiryUser (funct)
     void (*funct) ();

{
  ProcUserTree (Root, funct);
}
