/* $Id: tmparse.c,v 3.3 1991/09/01 14:03:32 piggy Rel $
 * 
 * @(#)tmparse.c   1.2.piggy 	91/03/29	parse a time specification
 * Written by Mike Stefanik
 *
 * Since it would be rather ridiculous to copyright (or copyleft) this
 * little snippit of code, it is released into the public domain.  Use
 * as you will.
 *
 * tmparse(3) will parse a date specification, and return the time in
 * natural format (the number of seconds since Jan 1, 1970 00:00)
 *
 * The buffer can contain the date portion (ie: 3/29/91), the time portion
 * (ie: 14:00:34), or both.   If no time is entered, the default is the
 * current time; if no date is entered, the default is the current date.
 *
 */

/*
 * Modified to deal with fixed format as the uucico's one: mm/dd-hh:mm:ss
 * Since those silly logs are missing the year, I have to compare the
 * month and the day with the current one: if they are greater, clearly
 * they refer to the last year...
 *
 * Changed tmparse(buf,when) to get_date(buf) for compatibility with the
 * rest of TUA.
 * 
 * piggy@idea.sublink.org - 6 Apr 1991
 */


#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#define ONE_DAY		86400L	/* number of seconds in a day */
#define ONE_YEAR	31536000L	/* number of seconds in a year */

int mdays[12] =
{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

time_t
get_date (buf)
     char *buf;
{
  long date;
  static long now = -1L;
  static int current_year, current_month, current_day;
  int year, month = 0, day = 0;
  int hours, mins, secs, count;
  struct tm *lt;

  if (now == -1L)               /* Is it the first time that they call you? */
    {
      time (&now);
      lt = localtime (&now);
      current_year = lt->tm_year + 1900;
      current_month = lt->tm_mon;
      current_day = lt->tm_mday - 1;
    }
  
  sscanf(buf, "%d/%d-%d:%d:%d", &month, &day, &hours, &mins, &secs);
  month--;
  day--;
  
  /*
   * Check the day vs current_day and month vs current_month to if their
   * year was last year or the current one.
   * Thanx to all uucico engineers!
   */
  
  if (current_month < month || (current_month == month && current_day < day))
    year = current_year-1;
  else
    year = current_year;
  
  /* count the number of seconds up to the specified year */

  date = 0L;
  for (count = 1970; count < year; count++)
    {
      date += ONE_YEAR;

#if 0     /* reduntant: if (count % 400) == 0 then also (count % 4) == 0)! */
      if (count % 4 == 0 || count % 400 == 0)
	date += ONE_DAY;
#else
      if (count % 4 == 0)
        date += ONE_DAY;
#endif      
    }

  /* adjust for timezone differences */

  date += timezone;

  /* count the number of seconds from the start of the year to
     the specified day */

  for (count = 0; count < month; count++)
    {
      date += mdays[count] * ONE_DAY;
#if 0                           /* Bad leap year check! */
      if (count == 1 && (year % 4 == 0 || year % 400 == 0))
	date += ONE_DAY;
#else
      if (count == 1 && (year%4 == 0 && (year%100 != 0 || year%400 == 0)))
        date += ONE_DAY;
#endif    
    }

  /* adjust for the specified time */

  date += (day * ONE_DAY) + secs + (mins * 60) + (hours * 3600);

  lt = localtime (&date);
  date += (hours - lt->tm_hour) * 3600;

  return (date);
}

#ifdef MAIN

main ()
{
  char buf[64];
  long when;
  extern long tmparse ();

  while (gets (buf) != NULL)
    {
      tmparse (buf, &when);
      printf ("%s", ctime (&when));
    }
}

#endif

