/* $Id: systree.c,v 3.3 1991/09/01 14:02:47 piggy Rel $
 * Systems tree management.
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * sysrep_t * InsertSys(char * sys);
 *      Look for sys in the tree. If it is already there, return a pointer
 *      to its info. Otherwise make a new entry and initialize it.
 *
 * void EnquirySys(void (*funct)(sysrep_t sys))
 *      For each node in the tree, process its info through funct.
 *
 * void KillSys(char * sys);
 *      Do not show the system in any of the reports
 *
 * sysrep_t * CheckSystemEsist(char * sys)
 *      Look for sys in the tree. If it is there, return a pointer to its info,
 *      otherwise NULL.
 */

#include    <stdio.h>
#include    "mem.h"
#include    <string.h>
#include    "hdbstat.h"

typedef struct systree
{
  sysrep_t Node;
  struct systree *L;
  struct systree *R;
} systree_t;

#define	TNULL	(systree_t *) NULL

static FlistHead SysFlist =
{
  0, 0, 0
};

static systree_t *Root = TNULL;

static sysrep_t *
SysTree (tree, sys, insert_flag)
     systree_t **tree;
     char *sys;
     int insert_flag;

{
  int cmpres;

  if (*tree == TNULL)
    if (insert_flag)
      {
        register sysrep_t *sr;
        int idx;

        if (SysFlist.size == 0)
          MemInit (&SysFlist, sizeof (systree_t), 20, 5);
        *tree = (systree_t *) new (&SysFlist);
        (*tree)->L = (*tree)->R = TNULL;
        sr = &((*tree)->Node);
        sr->System = strdup (sys);
        sr->Killed = FALSE;
        sr->FilesOut = sr->FilesIn = 0;
        sr->BytesOut = sr->BytesIn = 0.0;
        sr->TimeOut = sr->TimeIn = sr->TimeConnect = 0.0;
        sr->Calls = sr->CallsOK = sr->CallsFAIL = sr->CallsSTOPPED = 0;
        sr->CallsIn = sr->CallsOut = 0;
        sr->Commands = (Tcommrep_t) NULL;
        sr->History.FilesOut = sr->History.FilesIn = 0;
        sr->History.BytesOut = sr->History.BytesIn = 0.0;
        sr->History.TimeOut = sr->History.TimeIn = 0.0;
        for (idx = 0; idx <= 11; idx++)
          sr->History.MonthlyActivity[idx] = -1.0;
        for (idx = 0; idx < PHONE_PRICING_TB; idx++)
          sr->PhoneCost[idx] = 0.0;
        sr->History.LastMonthProcessed = -1;
        return (&(*tree)->Node);
      }
    else
      return (sysrep_t *) NULL;
  else if ((cmpres = strcmp (sys, (*tree)->Node.System)) < 0)
    return SysTree (&(*tree)->L, sys, insert_flag);
  else if (cmpres > 0)
    return SysTree (&(*tree)->R, sys, insert_flag);
  else
    return (&(*tree)->Node);
}

sysrep_t *
InsertSys (sys)
     char *sys;

{
  return SysTree (&Root, sys, TRUE);
}

void
KillSys (sys)
     char *sys;

{
  SysTree (&Root, sys, TRUE)->Killed = TRUE;
}

static void
ProcSysTree (tree, funct)
     systree_t *tree;
     void (*funct) ();

{
  if (tree != TNULL)
    {
      ProcSysTree (tree->L, funct);
      if (!(tree->Node.Killed))
	(*funct) (tree->Node);
      ProcSysTree (tree->R, funct);
    }
}

void
EnquirySys (funct)
     void (*funct) ();

{
  ProcSysTree (Root, funct);
}

sysrep_t *
CheckSystemEsist(sys)
     char * sys;

{
  return (SysTree(&Root, sys, FALSE));
}
 
