/* $Id: procuuxqt.c,v 3.3 1991/09/01 14:02:39 piggy Rel $
 * Read an process /usr/spool/uucp/.Log/uuxqt/*
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * int	ProcUuxqt()
 *	Process uuxqt log and update the commands trees.
 *
 */

#include    <stdio.h>
#include    <string.h>
#include    "hdbstat.h"

#if defined(DIRENT)
#include <dirent.h>
typedef struct dirent DIRECT;
#else
#if defined(NDIR)
#include    <sys/ndir.h>
typedef struct direct DIRECT;
#else
error:"You need the directory package!"
#endif
#endif

#define	DNULL	(DIRECT *)NULL

int 
ProcUuxqt ()
{
  DIR *dirfp;
  DIRECT *direntry;
  char dirname[LPNMAX];

  if (DoCommandReport)
    {
      sprintf (dirname, "%s/%s", PrefixPath, UUXQT_DIR);
      if ((dirfp = opendir (dirname)) == (DIR *) NULL)
        {
          perror("ProcUuxqt(opendir)");
          return (ERROR);
        }
      
      if (VerboseOutput)
        fputs("\nProcessing uuxqt logs:", stderr);
      while ((direntry = readdir (dirfp)) != DNULL)
        {
          FILE *XqtFp;
          char PathName[LPNMAX];
          char System[15];
          static void ProcUuxqtEntry PROTO( (FILE *, char *) );
                  
          if (*direntry->d_name == '.')
            continue;
#if defined(DIRENT)
          sprintf (System, "%s", direntry->d_name);
#else
          sprintf (System, "%.*s", direntry->d_namlen, direntry->d_name);
#endif
          if (JustSomeSystem &&
              (CheckSystemEsist(System) == (sysrep_t *) NULL))
            continue;
                  
          sprintf (PathName, "%s/%s/%s", PrefixPath, UUXQT_DIR, System);
          if ((XqtFp = fopen (PathName, "r")) == (FILE *) NULL)
            {
              perror("ProcUuxqt(fopen)");
              return ERROR;
            }
                  
          ProcUuxqtEntry (XqtFp, System);
          fclose (XqtFp);
        }
    }
  return OK;
}

static void 
ProcUuxqtEntry (fp, sys)
     FILE *fp;
     char *sys;

{
  char line[256];
  sysrep_t *sr = InsertSys (sys);
  int LineNumber = 0;

  if (!sr->Killed)
    {
      while (fgets (line, 256, fp) != NULL)
	{
	  commrep_t *cr;
	  dailyrep_t *dr;
	  int Month, Day, atoi ();
	  char *command;

	  if (VerboseOutput && (++LineNumber % 50) == 0)
	    fprintf(stderr, "\r%6d", LineNumber);
	  (void) strtok (line, "(");
	  Month = atoi (strtok (NULL, "/"));
	  Day = atoi (strtok (NULL, "-"));
	  dr = InsertDay ((short) Month, (short) Day);
	  (void) strtok (NULL, ";");	/* Throw away the initial */
	  /* stuff, I need only the */
	  /* command */
	  command = strtok (NULL, ")") + 1;	/* Skip the initial space */
	  cr = InsertComm (&sr->Commands, command);
	  cr->Number++;
	  cr = InsertComm (&dr->Commands, command);
	  cr->Number++;
	}
      if (VerboseOutput)
        fprintf(stderr, "\r%6d\n", LineNumber);
    }
}
