/* $Id: procdaily.c,v 3.3 1991/09/01 14:02:17 piggy Rel $
 * Process the "day-by-day" report.
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * struct dailyrep * InsertDay(int month, int day)
 *	Look for the day: if it is not there, insert it, otherwise return
 *      its infos.
 *
 * void EnquiryDaily(void (*funct)(struct dailyrep))
 *	Make the report, calling the function for each "worked" day.
 *
 */

#define	FALSE 0
#define TRUE  1

#include    <stdio.h>		/* for NULL definition */
#include    "hdbstat.h"

static dailyrep_t Calendar[13][32] =
{0};

dailyrep_t *
InsertDay (month, day)
     short month, day;
{
  register dailyrep_t *dr = &Calendar[month > 12 ? 0 : month][day > 31 ? 0 : day];

  if (dr->Used)
    return dr;
  else
    {
      dr->Used = TRUE;
      dr->Month = month;
      dr->Day = day;
      dr->FilesOut = dr->FilesIn = 0;
      dr->BytesOut = dr->BytesIn = 0.0;
      dr->TimeOut = dr->TimeIn = 0.0;
      dr->Commands = (Tcommrep_t) NULL;
      return dr;
    }
}

void 
EnquiryDay (funct)
     void (*funct) ();

{
  register short month, day;	/* {2} */

  for (month = 1; month < 13; month++)
    for (day = 1; day < 32; day++)
      {
	if (Calendar[month][day].Used)
	  (*funct) (Calendar[month][day]);
      }
}
