/**
*** Name ...... :	mem.h
*** Purpose ... :	Fixed blocks allocation
*** Author ....	:	...sigh! I lost it!
*** Note ...... :	from "The C User Journal"
*** Rcs_id .... :	$Id: mem.h,v 3.3 1991/09/01 14:02:14 piggy Rel $
**/

/*
 * Use:
 *	Initialize a FlistHead struct with
 *	    MemInit(&StructName, dimension, firstalloc, succalloc)
 *
 *	where firstalloc is the number of objects initially allocated,
 * succalloc is the number of objects to allocate whenever you fill
 * the current space.
 *
 *      With new(&StructName) you get a pointer to a new object.
 *
 *	With delete(&NomeStruct, object) you destroy that object from
 * the list, freeing space for the next allocations.
 *
 */

#if defined(M_I286) || defined(COHERENT)	/* Per un difetto, il compilatore 286 non */
#define	VOID	char		/* accetta 'void *' */
#else
#define	VOID	void
#endif

union freelist
{
    union freelist *next;
    char            memory;
    int             align;
};

typedef struct
{
    int             size;
    int             bytes;
    union freelist *freelist;
}               FlistHead;

#if defined(__STDC__) && !defined (NO_PROTOTYPE)
VOID           *new(FlistHead *);
void            delete(FlistHead *, void *);
void            MemInit(FlistHead *, int, int, int);

#else

VOID           *new();
void            delete();
void            MemInit();

#endif

