/* $Id: hdbstat.h,v 3.3 1991/09/01 14:02:08 piggy Rel $
 * Constants and structs definition, functions prototype.
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <sys/types.h>


#define OK	    0
#define ERROR	    1

#if !defined	(TRUE)
#define FALSE 0
#define TRUE 1
#endif

#define TIMESLICES  ((60 / 3) * 24)	    /* A sample every 20 mins */

typedef float HourlyAct_t[TIMESLICES];

typedef struct portact			    /* Port's activity */
{
    char	    *Port;		    /* Port's name */
    short	    Killed;
    HourlyAct_t	    Activity;
} portact_t;

struct xferentry			    /* xferstats entry */
{
    char            System[15];		    /* System's name */
    char            User[15];		    /* User's name */
    short           Month;
    short           Day;
    short           Hour;
    short           Min;
    short           Sec;
    short           DayOfWeek;
    char	    PortName[15];
    char            Direction;		    /* S: sent, R: received */
    float           Bytes;		    /* Bytes moved */
    float           Time;		    /* Time it takes */
                                            /* (corrected) */
};

typedef struct syshist			    /* System's history info */
{
    short           FilesOut;
    short           FilesIn;	
    float           BytesOut;	
    float           BytesIn;
    float           TimeOut;
    float           TimeIn;
    float           MonthlyActivity[12]; /* Last 12 months activity */
    short           LastMonthProcessed;
}               syshist_t;

typedef struct commrep			    /* Command's tree node */
{
    char           *Command;		    /* Command's name */
    short           Number;		    /* # of invocation */
}               commrep_t;

typedef struct commreptree
{
    commrep_t       Node;
    struct commreptree *L;
    struct commreptree *R;
}              *Tcommrep_t, commreptree_t;

typedef struct dailyrep                     /* Daily table */
{
    short           Used;		    /* TRUE if used */
    short           Month;
    short           Day;
    short           FilesOut;
    short           FilesIn;
    float           BytesOut;
    float           BytesIn;
    float           TimeOut;
    float           TimeIn;
    Tcommrep_t      Commands;		    /* This day commands */
}               dailyrep_t;

typedef struct sysrep
{
    char        *System;        /* System's name */
    short       Killed;         /* TRUE: do not print this system */
    short       FilesOut;
    short       FilesIn;
    float       BytesOut;
    float       BytesIn;
    float       TimeOut;
    float       TimeIn;
    float       TimeConnect;
    float       PhoneCost[PHONE_PRICING_TB];
    short       Calls;          /* # of calls */
    short       CallsIn;        /* # of inbound calls */
    short       CallsOut;       /* # of outboud calls */
    short       CallsOK;        /* Correctly finished ones */
    short       CallsFAIL;      /*
                                 * # of calls that did not reached the
                                 * login phase.
                                 */
    short       CallsSTOPPED;   /* Uncorrectly finished ones */
    time_t      LastConnection;
    syshist_t   History;    /* System's historical datas */
    Tcommrep_t  Commands;
}               sysrep_t;

typedef struct userrep
{
    char           *User;		    /* User's name */
    short           Killed;		    /* TRUE: do not print this */
                                            /* user */
    short           FilesOut;
    float           BytesOut;
    float           TimeOut;
    Tcommrep_t      Commands;
}               userrep_t;

#if defined(HDB_ERR_FACT)
extern float    ERRFACT;		    /* Correction factor for */
                                            /* buggy HDB */
#endif

extern int      DoCommandReport;

extern int      SeparatedCommLog;	    /* Build a separated */
                                            /* commands report */

extern int      JustSomeSystem;             /* Show just some system in
                                             * the reports */

extern char    *PrefixPath;		    /* Prefix dir for the logs */
extern char     SystemName[];		    /* Name of the system */
                                            /* where tua is running */
extern char    *CurrentTime;
extern char     TheEpoc[];
extern char    *Since;
extern int      CurrentMonth;

extern int      ChartSize;
extern int      VerboseOutput;

extern time_t   StatStartingTime;  /* When really the log began */
extern int	DaysSinceLastClean;
extern char    *PhoneCategoryNames[PHONE_PRICING_TB];

#if defined (__STDC__) && !defined (NO_PROTOTYPE) 
#define PROTO(proto)    proto
#else
#define PROTO(proto)	()
#endif

extern void     KillSys PROTO((char *));
extern void     KillUser PROTO((char *));
extern void	KillPort PROTO((char *));
extern commrep_t *InsertComm PROTO((Tcommrep_t *, char *));
extern userrep_t *InsertUser PROTO((char *));
extern sysrep_t *InsertSys PROTO((char *));
extern dailyrep_t *InsertDay PROTO((int, int));
extern portact_t *InsertPort PROTO((char *));
extern void     EnquirySys PROTO((void(*)(sysrep_t)));
extern void     EnquiryUser PROTO((void(*)(userrep_t)));
extern void     EnquiryComm PROTO((Tcommrep_t, void(*)(commrep_t)));
extern void     EnquiryDay PROTO((void(*)(dailyrep_t)));
extern void	EnquiryPort PROTO((void(*)(portact_t)));
extern int      GetXferEntry PROTO((struct xferentry *));
extern int      ProcXferstats PROTO((void));
extern int      ProcUucico PROTO((void));
extern int      ProcUuxqt PROTO((void));
extern int      ProcUucp PROTO((void));
extern int      ProcUux PROTO((void));
extern void     SystemsReport PROTO((void));
extern void     UsersReport PROTO((void));
extern void     DailyReport PROTO((void));
extern void     SystemsCommandReport PROTO((void));
extern void     UsersCommandReport PROTO((void));
extern void     DailyCommandReport PROTO((void));
extern void     SystemSummary PROTO((void));
extern void     SystemSummaryTable PROTO((void));
extern void     SystemHistoryTable PROTO((void));
extern void     HourlyActivityCharts PROTO((void));
extern void	GlobalHourlyActivityChart PROTO((void));
extern int      ReadHistory PROTO((void));
extern int      WriteHistory PROTO((int));
extern time_t   get_date PROTO((char *));
extern void     MonthlyHistoryTable PROTO((void));
extern int      GetPhonePrice PROTO((int, int, int));
extern sysrep_t * CheckSystemEsist PROTO( (char *) );     
#ifdef USG     
extern int      gethostname PROTO((char *, int));
#endif     
#ifdef STRDUP_MISSING
extern char *   strdup PROTO((char *));
#endif     
