/* $Id: config.h,v 3.3 1991/09/01 14:02:35 piggy Rel $
 * Customizations of the TUA package
 * Follow the comments to adjust the configuration.
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * DIRECTORY PACKAGE:
 * Choose one of these: NDIR for old directory package, as in <sys/ndir.h>
 * for the Xenix box; DIRENT for the Posix Compliant one, as in <dirent.h>
 * If you do not have this package, you can get it from GNU (it is the
 * Gwyn's Directory Package).
 */
/* #define NDIR */		/* For SCO Xenix boxes */
#define DIRENT		/* For USG boxes */

/*
 * MAX PATHNAME LENGTH:
 * Do not define anything for Xenix boxes
 * This is a constant to specify the maximum length of a pathname.
 */
#define LPNMAX 128	/* For all the other but Xenix */

/*
 * HDB-Uucp CORRECTION FACTOR:
 * HDB-Uucp, as implemented by SCO, has a bug: it fails calculating the
 * connection and tranfer time. Experimentally, I found in 2.5 the right
 * factor to correct these values.
 * If your HDB is ok, do not define anything. Otherwise uncomment the next
 * line; I hope 2.5 is ok for you. However, if you define this constant, there
 * will be an option ('+hdb-factor') that lets you modify the value at 
 * runtime.
 * PS: For the xenix 386 boxes, there is a SLS that corrects this bug.
 * It was told me that ODT 1.1 and SCO Unix 3.2.2 are ok... at least in
 * this!
 */
/* #define HDB_ERR_FACT 2.5 */	/* For broken hdb */

/* 
 * DIFFTIME FUNCTION:
 * Uncomment the next definition if your system lacks the difftime() function
 * I found it only on SCO Unix, where I initially developed tua.
 */
#define DIFFTIME_MISSING        /* On non-SCO systems */

/*
 * STRDUP FUNCTION:
 * Uncomment the next definition if your system lacks the strdup() function.
 * As far as I know, BSD-like don't have it.
 */
#define STRDUP_MISSING		/* At least on some BSD systems */
  
/*
 * DOMAIN:
 * Write here your exact domain.
 */
#define DOMAIN	".GUN.de"

/*
 * COUNTRY:
 * Define here your country, and comment all the other. I use this in
 * phonesw.c to set up the correct table and function to subdivide the
 * phone costs.
 */
#define ITALY                   /* Pizza & Spaghetti country */
/* #define UK */		/* United Kingdom */

/*
 * PHONE PRICING TIMEBELTS:
 * Specify in how many "slices" your phone costs are divided.
 * The selection is now automatical...
 */
#ifdef ITALY  
#define PHONE_PRICING_TB    4	/* In italy */
#endif
#ifdef UK
#define PHONE_PRICING_TB    3	/* In United Kingdom */
#endif

/*
 * HDB-UUCP LOGS FILENAMES:
 * These are the pathname of the various logs tua reads.
 * They are no absolute, because tua has a flag, for debugging, that
 * sets the root dir for them. If you do not specify that flag,
 * /usr/spool/uucp is used.
 */
#define	XFER_NAME   ".Admin/xferstats"
#define UUCICO_DIR  ".Log/uucico"
#define UUXQT_DIR   ".Log/uuxqt"
#define UUX_DIR	    ".Log/uux"
#define UUCP_DIR    ".Log/uucp"
#define HISTORY	    ".Admin/tua.history"

/*
 * SYSTEM NAME DETERMINATION:
 * Specify in SYSTEMID the file that contain the name of your system if
 * your os uses this way to get it; Xenix can use both /etc/systemid and
 * uname(), but in the latter manner you have to relink the kernel to 
 * put it in.
 * Leave it undefined if you want use uname() instead of a filename.
 */
/* #define SYSTEMID	"/etc/systemid" */		/* For xenix box (if you want!) */
