/* $Id: commtree.c,v 3.3 1991/09/01 14:02:03 piggy Rel $
 * Handle the command trees.
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * int	InsertComm(Tcommrep_t Tree, char * comm);
 *      As usual, look for comm in the tree; if it is already there
 *      return a pointer to it, otherwise insert it and reset its infos.
 *
 * void EnquiryComm(Tcommrep_t Tree, void (*funct)(commrep_t comm))
 *      For each command in the tree, process it through the function.
 *
 */

#include    <stdio.h>
#include    "mem.h"
#include    <string.h>
#include    "hdbstat.h"

#define	TNULL	(Tcommrep_t) NULL

static FlistHead CommFlist =
{
  0, 0, 0
};

commrep_t *
InsertComm (tree, comm)
     Tcommrep_t *tree;
     char *comm;

{
  int cmpres;

  if (*tree == TNULL)
    {
      if (CommFlist.size == 0)
	MemInit (&CommFlist, sizeof (commreptree_t), 100, 50);
      *tree = (Tcommrep_t) new (&CommFlist);
      (*tree)->L = (*tree)->R = TNULL;
      (*tree)->Node.Command = strdup (comm);
      (*tree)->Node.Number = 0;
      return (&(*tree)->Node);
    }
  else if ((cmpres = strcmp (comm, (*tree)->Node.Command)) < 0)
    return InsertComm (&(*tree)->L, comm);
  else if (cmpres > 0)
    return InsertComm (&(*tree)->R, comm);
  else
    return (&(*tree)->Node);
}


void 
EnquiryComm (tree, funct)
     Tcommrep_t tree;
     void (*funct) ();

{
  if (tree != TNULL)
    {
      EnquiryComm (tree->L, funct);
      (*funct) (tree->Node);
      EnquiryComm (tree->R, funct);
    }
}
