/*

File	: vp_frame.c
Purpose	: Make v*printf calls in Mark Williams C 
	  under Coherent 3.10
Date	: 11/02/92
By	: Noud van Klinken

*/


#include <varargs.h>
/* The varargs.h header is not standard available for Coherent
   But you can download one from piggy.ucsb.edu
*/
#include <stdio.h>


/* 
----------------------------------------------------------------------------
  Routine that builds a new argument_list
*/

va_list vp_frame (fmt, arg_ptr)
char *fmt;
va_list arg_ptr;
{
   int i;
   char *c;
   va_list ret;

   for (c=fmt, i=0; *c ; c++)
      if (*c=='%') i++;

   ret = (va_list) malloc (sizeof(char *) + i*sizeof(double));
   if (!ret)
      return (NULL);

   memcpy (ret, &fmt, sizeof(char *));
   memcpy (ret+sizeof(char *), arg_ptr, i*sizeof(double));
   return ret;
}
