/*
 * varargs.h -- varargs definitions for Mark Williams C under Coherent 3.10
 *
 * This is for compatibility/ porting purposes.
 *
 * By David Fenyes,   Dec. 1990.
*/

/* Be aware that the (char) type is passed as a 16-bit word, and the (float)
 * type is passed as eight bytes (like (double)), so it may be
 * better to retrieve (char) variables as 
 *
 * x_char = (char) va_arg(args,short);
 *
 * and floats as
 *
 * x_float = (float) va_arg(args,double);
 *
 * the same goes for any (char)-based type or (float) -based type.
 *
 * The promotion of odd-sized types such as char to even-sized stack
 * increments can be accomplished by #define'ing VARGS_NO_UPGRADE_CHAR as 0.
 * this uses a different set of definitions for va_arg, which, with a 
 * good optimizer, should produce equivalently efficient assembly.
 * This still doesn't fix the (float) to (double) passing problem,
 * however, and the above casting may be the best solution.
 *
 * The default is VARGS_NO_UPGRADE_CHAR is 0. 
 * To disable the automatic upgrading of odd-sized types, set
 * VARGS__NO_UPGRADE_CHAR to 1.
 */

#if !defined(VARARG_H) && !defined(va_dcl)

#ifndef VARGS__NO_UPGRADE_CHAR
# define VARGS_NO_UPGRADE_CHAR 0
#endif
#if VARGS_NO_UPGRADE_CHAR
# define va_arg(ptr,type) * ( ((type *) ptr)++)
#else
# define rsizeof(x) (sizeof(x) + (sizeof(x) & 1))
# define va_arg(ptr,type) ( \
    ptr = (char *) ((int)ptr + rsizeof (type)), \
     * ((type *) ((int) ptr - rsizeof (type))) \
  )
#endif /*VARGS_NO_UPGRADE_CHAR*/

#define va_dcl char va_alist;
#define va_start(ptr) (ptr = &va_alist);
#define va_end(ptr)

typedef char *va_list;


#define VARARG_H 1

#endif /* !defined (VARARG_H) */

