/*

File	: rsprintf.c
Purpose	: make recursive formats from Mark Williams C under 
	  Coherent 3.10 available to other UNIX systems
	  Use prpatch.h as include in your export programs.
Date	: Feb 13 '92
By	: Noud van Klinken
Email	: noud@dutentc.et.tudelft.nl
WARNING	: The following is rather nasty and ugly. 

*/

#include <varargs.h>
#include <stdio.h>
#include <ctype.h>
#include "rprintf.h"		/* prototypes for functions here defined */

#define True 1
#define False 0

/* Uncomment this for testing purposes*/
/*
#define DBG
*/

char fmt_buf[1024];		/* hoping its enough */

/* Recursive expansion is made in rvprintf and rvsprintf calling
   vprintf and vsprintf for each partial expanded format.
   rprintf and rsprintf call rvprintf and rvsprintf
*/

int rvsprintf (ostr,fmt,pstrt)
char *ostr,*fmt;
va_list pstrt;
{
   va_list	i;		/* used for tracking parameters used
				   in vprintf */
   va_list	parms;		/* parameter block of recursive call */
   char		*p;		/* iterator for format string */
   char		*fmt_ptr;	/* pointer to copy partial format to */
   int		fmt_mode;	/* interpreting a format specification */
   int		first_fmt;	/* we have the first char of a fmt spec */
   int		tot_bytes;	/* total bytes printed so far (returns) */
   int		cur_bytes;	/* bytes printed by a (r)vprintf call */
   int		idummy;		/* dummys for loading parameters */
   long		ldummy;
   double	fdummy;
         
   for (fmt_mode = 0,		/* scanner not in format mode */
        first_fmt = 0,		/* not the first character of format */
        fmt_ptr = fmt_buf,	/* beginning of format buffer */
        p = fmt,		/* scanner at the beginning of fmt */
	i = pstrt,		/* argument scanner at begin of args */
	tot_bytes = 0;		/* no bytes outputted */

	*p != '\0';		/* do as long as chars in fmt */

	p++) {		/* next fmt char */

      if (!fmt_mode) {

         if (*p == '%') {	/* if format sign (%) -> format mode */
	    first_fmt = True;	/* remembering a (%) still must be copied */
	    fmt_mode = True;
	 }
	 else {
	    *(fmt_ptr++) = *p;	/* Copy to format buffer */
#ifdef DBG
	    printf ("!%c",*p);
#endif
	 }
      }
      else {
	 switch (*p) {		/* depending on char in fmt. spec. do : */

	case 'd':		/* word size parameters */
	case 'u':
	case 'c':
	case 'x':
	case 'o':
	idummy = va_arg(i,int);	/* release a wordsize parameter */
	if (first_fmt) {
	   *(fmt_ptr++) = '%';	/* copy '%' to format if not done yet */
#ifdef DBG
	   printf ("~%%");
#endif
	   first_fmt = False;	/* copying '%' done */
	}
	*(fmt_ptr++) = *p;	/* copy current char also */
#ifdef DBG
	printf ("~%c(%d)\n",*p,idummy);
#endif
	fmt_mode = False;	/* Not in format mode any more */
	break;



	case 'l':		/* long prefix */
	if (first_fmt) {
	   *(fmt_ptr++) = '%';
#ifdef DBG
	   printf ("~%%");
#endif
	   first_fmt = False;
	}
	*(fmt_ptr++) = *(p++);	/* Copy prefix char, advance char ptr */
#ifdef DBG
	printf ("~%c",*p);
#endif
				/* NO break -> do actions for long para */

	case 'D':		/* long size parameters */
	case 'U':
	case 'X':
	case 'O':	
	ldummy = va_arg(i,long); /* Release a double word parameter */
	if (first_fmt) {
	   *(fmt_ptr++) = '%';
#ifdef DBG
	   printf ("~%%");
#endif
	   first_fmt = False;
	}
	fmt_mode = False;
	if (isupper(*p)) {	        /* Convert D U X and O formats to */
	   *(fmt_ptr++) = 'l';          /* ld lu lx and lo formats */
	   *(fmt_ptr++) = tolower(*p);
	}
	else
	   *(fmt_ptr++) = *p;
#ifdef DBG
	printf ("~%c(%lu)\n",*p,ldummy);
#endif
	break;



	case 'g':			/* double formats */
	case 'f':
	fdummy = va_arg(i,double);	/* Release a double */
	if (first_fmt) {
	   *(fmt_ptr++) = '%';
#ifdef DBG
	   printf ("~%%");
#endif
	   first_fmt = False;
	}
	*(fmt_ptr++) = *p;
#ifdef DBG
	printf ("~%c(%f)",*p,(double)fdummy);
#endif
	fmt_mode = False;
	break;




	case 's':			/* pointer formats */
	case 'p':
	if (first_fmt) {
	   *(fmt_ptr++) = '%';
#ifdef DBG
	   printf ("~%%");
#endif
	   first_fmt = False;
	}
	*(fmt_ptr++) = *p;

	if (sizeof(char *) == 2) {	/* releasing a pointer */
	   idummy = va_arg(i,int);	/* depends on model (far or near) */
#ifdef DBG
	   printf ("~%c(%04x)\n",*p,idummy);
#endif
	}
	else {
	   ldummy = va_arg(i,long);
#ifdef DBG
	   printf ("~%c(%04x:%04x)\n",*p,ldummy);
#endif
	}
	fmt_mode = False;
	break;

					/* default actions : char is
					not a fmt. spec. terminator, just
					copy this char to the format buf */
	default :
	if (first_fmt) {
	   *(fmt_ptr++) = '%';
#ifdef DBG
	   printf ("~%%");
#endif
	   first_fmt = False;
	}
	*(fmt_ptr++) = *p;
#ifdef DBG
	printf ("~%c",*p);
#endif
	break;


		/* This is what's it all about...
		A "%r" format means that the supplied parameter holds a
		pointer to a block of para's for a new rvsprintf call.
		All other cases in this switch statement keeped track of
		their supplied parameter, so this parameter block pointer
		is the next one to retrieve. But first a call to vprintf
		must be made to flush the builded ("%r"-less) format string
		supplied with the old parameter block. Then a new format
		string is retrieved out of the new par.block ptr. This
		format string, supplied with the remaining parameter block
		will be used for a recursive call to rvsprintf. After this
		interpreting of the current format string must be setup
		again. This is done by resetting fmt_ptr to the buffer
		start, and setting the start of the parameters to the
		current parameter. (What a story).

		In addition to rvprintf,
		after each call to (r)vsprintf the pointer to the output
		string must be advanced to its end */


	case 'r' :
	*(fmt_ptr++) = '\0';		/* finish format */
#ifdef DBG
	printf ("\nFormat :\"%s\"\n\n",fmt_buf);
#endif

	vsprintf (ostr, fmt_buf, pstrt);	/* flush it */
        cur_bytes = strlen(ostr);               /* Sun3 hack vsprintf geeft niet
						   het aantal weggeschreven chars */
	if (cur_bytes == EOF)
	   return (EOF);
        
#ifdef DBG
        printf ("flush ostr :\"%s\" (%d , %d chars)\n", ostr, cur_bytes, strlen(ostr));
#endif

	tot_bytes += cur_bytes;			/* keep track of bytes */
	ostr += cur_bytes;			/* Set ostr to its end */

	parms = va_arg(i,va_list);		/* retrieve new par. block */

#ifdef DBG
	printf ("\nParmPtr %p\n",parms);
#endif                                          /* retrieve new format str.*/
	fmt_ptr = va_arg(parms,char *);		/* out of new par.block */

#ifdef DBG
	printf ("fmt_ptr %p\n",fmt_ptr);
	printf ("fmt str %s\n",fmt_ptr);
#endif

	cur_bytes = rvsprintf (ostr, fmt_ptr, parms);
						/* recursive call with new */
	if (cur_bytes == EOF)			/* parameters */
	   return (EOF);

#ifdef DBG
        printf ("flush ostr :\"%s\" (%d , %d chars)\n", ostr, cur_bytes, strlen(ostr));
#endif


	tot_bytes += cur_bytes;
	ostr += cur_bytes;

	pstrt = i;			/* Set pstrt to current parameter */
	fmt_ptr = fmt_buf;		/* Reset fmt_ptr to buffer start */
	first_fmt = False;		/* Ready for the rest of fmt */
	fmt_mode = False;
	
         } /* switch */
      } /* else */
   } /* for */

#ifdef DBG
   if (fmt_mode || first_fmt)
      fprintf (stderr,"\nError in mode or first \n");
#endif

   /* Do last flush if a partial format remained */

   if (fmt_ptr != fmt_buf) {
      *(fmt_ptr++) = '\0';		/* finish format string */

#ifdef DBG
      printf ("\nFormat :\"%s\"\n\n",fmt_buf);
#endif

      vsprintf (ostr, fmt_buf, pstrt);	/* flush it */
      cur_bytes = strlen(ostr);               /* Sun3 hack vsprintf geeft niet
						   het aantal weggeschreven chars */

#ifdef DBG
        printf ("flush ostr :\"%s\" (%d , %d chars)\n", ostr, cur_bytes, strlen(ostr));
#endif


      tot_bytes += cur_bytes;	/* Keep track of outputted bytes */
   }
   return (tot_bytes);		/* Return total outputted bytes */
} /* rvsprintf */






int rsprintf (ostr,fmt,va_alist)
char *ostr;
char *fmt;
va_dcl
{
   va_list args;
#ifdef DBG
   int tot_bytes;
   va_start (args);
   if ((tot_bytes = rvsprintf (ostr, fmt, args))==EOF)
      printf ("rvsprintf returns EOF\n");

   return (tot_bytes);
#else
   va_start (args);
   return (rvsprintf (ostr, fmt, args));
#endif
}

/*
=============================================================================
*/

