/*

File	: rprintf.test.c
Purpose	: Tests the family of r*printf functions (example from rprintf.doc)
Date	: Feb 12 '92
By	: Noud van Klinken

*/

#include <stdio.h>
#include <varargs.h>
/*
#include "rprintf.h"
*/

/*
-------------------------------------------------------------------------------
  Example routines from rprintf.doc
*/

embrace_it (va_alist)
va_dcl
{
   va_list par_block;
   va_start (par_block);
   rprintf ("Does it work %c (%r)\n", '?', par_block);
   va_end (par_block);
}


between_char (x, va_alist)
char x;
va_dcl
{
   va_list par_block;
   va_start (par_block);
   embrace_it (" %c %r %c ", x, par_block, x);
   va_end (par_block);
}


/*
-------------------------------------------------------------------------------
   additional test routine
*/

char buffer[1024];

void rsfvprintf_test (fmt)
char *fmt;
{
   int bytes;
   printf ("\nResult of rprintf and rvprintf :\n");

   bytes =
   rprintf ("Char     : %c   \nInt      : %d   \nLong     : %lu   \nHex      : %04x \nString   : %s   \nRecursive: %r   \nInt nr 2 : %d   \n",
	'A', 1024, 102400l, 0xabcd, "Greetings", &fmt, 12345);

   printf ("Outputted %u chars.\n",bytes);

   bytes =
   rsprintf (buffer,
	     "Char     : %c   \nInt      : %d   \nLong     : %U   \nHex      : %04x \nString   : %s   \nRecursive: %r   \nInt nr 2 : %d   \n",
	'A', 1024, 102400l, 0xabcd, "Greetings", &fmt, 12345);

   printf ("\nResult of rsprintf and rvsprintf :\n%s",buffer);
   printf ("Outputted %u chars.\n",bytes);


   printf ("\nResult of rfprintf and rvfprintf :\n");
   bytes =
   rfprintf (stdout,
	     "Char     : %c   \nInt      : %d   \nLong     : %U   \nHex      : %04x \nString   : %s   \nRecursive: %r   \nInt nr 2 : %d   \n",
	'A', 1024, 102400l, 0xabcd, "Greetings", &fmt, 12345);

   printf ("Outputted %u chars.\n",bytes);
}

/*
-------------------------------------------------------------------------------
   main (invokes as in rprintf.doc)
*/

main ()
{
   printf ("From the example in \"rprintf.doc\"\n");
   between_char ('!', "YES (%d)", 5474 + 6871);
   embrace_it ("This will all be embraced. %c%s...", 'Y',"es it works");
   printf ("\n\nAdditional tests :\n");

   rsfvprintf_test ("Hallo allemaal... dag allemaal %d %s %d",
		    12,
		    "hoi",
		    6);

   exit (0);
}
