/*
 * use.c
 *
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 *
 * Credit should be given to the following autors:
 *	  Tim Stoehr (tims@zeus.TEK.COM) autor of the rogue-clone II
 *	  J. Erwied  translation to german version III.g
 * There may be more, I don't know. I've requested it from the german
 * UNIDO file server and made the following additions:
 *	Bug fixed in dynamic memory allocation
 *	Ported to Coherent 3.2
 *	Ported to SCO UNIX
 *	Additional conditional compiling for BBS, where all users login
 *	on the same account.
 * Udo Munk (udo@umunk.GUN.de)
 */

#include "rogue.h"

short halluc = 0;
short blind = 0;
short confused = 0;
short levitate = 0;
short haste_self = 0;
boolean see_invisible = 0;
boolean detect_monster = 0;
boolean con_mon = 0;
char *strange_feeling = "Du hast fuer kurze Zeit ein komisches Gefuehl";

extern short bear_trap;
extern char hunger_str[];
extern short cur_room;
extern long level_points[];
extern boolean being_held;
extern char *fruit, *you_can_move_again;
extern boolean sustain_strength;

quaff()
{
	char buf[80];
	object *potion;

	if (!(potion = user_obj("Was einnehmen?", POTION, (char) 0))) {
		return;
	}
	if (potion->what_is != POTION) {
		message("Das kannst Du nicht einnehmen", 0);
		return;
	}
	switch(potion->which_kind) {
		case INCREASE_STRENGTH:
			message("Du fuehlst dich staerker, was fuer herrliche Muskeln!", 0);
			rogue.str_current++;
			if (rogue.str_current > rogue.str_max) {
				rogue.str_max = rogue.str_current;
			}
			break;
		case RESTORE_STRENGTH:
			rogue.str_current = rogue.str_max;
			message("Es schmeckt grossartig, Du fuehlst dich wohlig warm", 0);
			break;
		case HEALING:
			message("Du beginnst dich besser zu fuehlen", 0);
			potion_heal(0);
			break;
		case EXTRA_HEALING:
			message("Du fuehlst dich sehr viel besser", 0);
			potion_heal(1);
			break;
		case POISON:
			if (!sustain_strength) {
				rogue.str_current -= get_rand(1, 3);
				if (rogue.str_current < 1) {
					rogue.str_current = 1;
				}
			}
			message("Du fuehlst dich fuerchterlich", 0);
			if (halluc) {
				unhallucinate();
			}
			break;
		case RAISE_LEVEL:
			rogue.exp_points = level_points[rogue.exp - 1];
			message("Du fuehlst dich ploetzlich erfahrener", 0);
			add_exp(1, 1);
			break;
		case BLINDNESS:
			go_blind();
			break;
		case HALLUCINATION:
			message("Wahnsinn, diese herrlich bunten, schillernden Farben", 0);
			halluc += get_rand(500, 800);
			break;
		case DETECT_MONSTER:
			show_monsters();
			if (!(level_monsters.next_monster)) {
				message(strange_feeling, 0);
			}
			break;
		case DETECT_OBJECTS:
			if (level_objects.next_object) {
				if (!blind) {
					show_objects();
				}
			} else {
				message(strange_feeling, 0);
			}
			break;
		case CONFUSION:
			message((halluc ?	"Was fuer ein befluegelndes Gefuehl" :
								"Du scheinst durcheinander zu sein"), 0);
			cnfs();
			break;
		case LEVITATION:
			message("Du beginnst zu schweben", 0);
			levitate += get_rand(15, 30);
			being_held = bear_trap = 0;
			break;
		case HASTE_SELF:
			message("Du bewegst dich auf einmal viel schneller", 0);
			haste_self += get_rand(12, 22);
			break;
		case SEE_INVISIBLE:
			sprintf(buf, "hmm, diese Arznei schmeckt wie %ssaft", fruit);
			message(buf, 0);
			if (blind) {
				unblind();
			}
			see_invisible = 1;
			relight();
			break;
	}
	print_stats((STAT_STRENGTH | STAT_HP));
	if (id_potions[potion->which_kind].id_status != CALLED) {
		id_potions[potion->which_kind].id_status = IDENTIFIED;
	}
	vanish(potion, 1, &rogue.pack);
}

read_scroll()
{
	object *obj;
	char msg[DCOLS];

	if (!(obj = user_obj("Was lesen?", SCROL, (char) 0))) {
		return;
	}
	if (obj->what_is != SCROL) {
		message("Du kannst das nicht lesen", 0);
		return;
	}
	switch(obj->which_kind) {
		case SCARE_MONSTER:
			message("Du hoerst einen wahnsinnigen Lacher im Hintergrund",
			0);
			break;
		case HOLD_MONSTER:
			hold_monster();
			break;
		case ENCH_WEAPON:
			if (rogue.weapon) {
				if (rogue.weapon->what_is == WEAPON) {
					sprintf(msg, "Dein %s wird von einem %sn Leuchten fuer einen Augenblick umspielt",
					name_of(rogue.weapon),
					get_ench_color()),
					message(msg, 0);
					if (coin_toss()) {
						rogue.weapon->hit_enchant++;
					} else {
						rogue.weapon->d_enchant++;
					}
				}
				rogue.weapon->is_cursed = 0;
			} else {
				message("Deine Haende kribbeln", 0);
			}
			break;
		case ENCH_ARMOR:
			if (rogue.armor) {
				sprintf(msg, "Deine Ruestung wird von einem %sn Leuchten umspielt",
				get_ench_color());
				message(msg, 0);
				rogue.armor->d_enchant++;
				rogue.armor->is_cursed = 0;
				print_stats(STAT_ARMOR);
			} else {
				message("Du bekommst eine Gaensehaut", 0);
			}
			break;
		case IDENTIFY:
			message("Mit dieser Schriftrolle kannst du etwas identifizieren", 0);
			obj->identified = 1;
			id_scrolls[obj->which_kind].id_status = IDENTIFIED;
			idntfy();
			break;
		case TELEPORT:
			tele();
			break;
		case SLEEP:
			message("Du schlaefst ein", 0);
			take_a_nap();
			break;
		case PROTECT_ARMOR:
			if (rogue.armor) {
				message( "Deine Ruestung wird von einem schimmernden Goldschild belegt",0);
				rogue.armor->is_protected = 1;
				rogue.armor->is_cursed = 0;
			} else {
				message("Deine Pickel scheinen weg zu sein", 0);
			}
			break;
		case REMOVE_CURSE:
				message((!halluc) ?
					"Du fuehlst, dass dich irgendjemand beschuetzen will" :
					"Du fuehlst die Beruehrung mit der universellen Einheit", 0);
			uncurse_all();
			break;
		case CREATE_MONSTER:
			create_monster();
			break;
		case AGGRAVATE_MONSTER:
			aggravate();
			break;
		case MAGIC_MAPPING:
			message("Diese Schriftrolle ist eine Karte", 0);
			draw_magic_map();
			break;
		case CON_MON:
			con_mon = 1;
			sprintf(msg, "Fuer einen Augenblick hast Du %s Haende", get_ench_color());
			message(msg, 0);
			break;
	}
	if (id_scrolls[obj->which_kind].id_status != CALLED) {
		id_scrolls[obj->which_kind].id_status = IDENTIFIED;
	}
	vanish(obj, (obj->which_kind != SLEEP), &rogue.pack);
}

/* vanish() does NOT handle a quiver of weapons with more than one
 *  arrow (or whatever) in the quiver.  It will only decrement the count.
 */

vanish(obj, rm, pack)
object *obj;
short rm;
object *pack;
{
	if (obj->quantity > 1) {
		obj->quantity--;
	} else {
		if (obj->in_use_flags & BEING_WIELDED) {
			unwield(obj);
		} else if (obj->in_use_flags & BEING_WORN) {
			unwear(obj);
		} else if (obj->in_use_flags & ON_EITHER_HAND) {
			un_put_on(obj);
		}
		take_from_pack(obj, pack);
		free_object(obj);
	}
	if (rm) {
		(void) reg_move();
	}
}

potion_heal(extra)
{
	float ratio;
	short add;

	rogue.hp_current += rogue.exp;

	ratio = ((float)rogue.hp_current) / rogue.hp_max;

	if (ratio >= 1.00) {
		rogue.hp_max += (extra ? 2 : 1);
		rogue.hp_current = rogue.hp_max;
	} else if (ratio >= 0.90) {
		rogue.hp_max += (extra ? 1 : 0);
		rogue.hp_current = rogue.hp_max;
	} else {
		if (ratio < 0.33) {
			ratio = 0.33;
		}
		if (extra) {
			ratio += ratio;
		}
		add = (short)(ratio * ((float)rogue.hp_max - rogue.hp_current));
		rogue.hp_current += add;
		if (rogue.hp_current > rogue.hp_max) {
			rogue.hp_current = rogue.hp_max;
		}
	}
	if (blind) {
		unblind();
	}
	if (confused && extra) {
			unconfuse();
	} else if (confused) {
		confused = (confused / 2) + 1;
	}
	if (halluc && extra) {
		unhallucinate();
	} else if (halluc) {
		halluc = (halluc / 2) + 1;
	}
}

idntfy()
{
	object *obj;
	struct id *id_table;
	char desc[DCOLS];

	while (!(obj = user_obj("Was moechtest Du identifizieren?", ALL_OBJECTS,
															(char) 0))) {
	}
	obj->identified = 1;
	if (obj->what_is & (SCROL | POTION | WEAPON | ARMOR | WAND | RING)) {
		id_table = get_id_table(obj);
		id_table[obj->which_kind].id_status = IDENTIFIED;
	}
	get_desc(obj, desc);
	message(desc, 0);
}

eat()
{
	short moves;
	object *obj;

	if (!(obj = user_obj("Was essen?", FOOD, (char) 0))) {
		return;
	}
	if (obj->what_is != FOOD) {
		message("Das ist reichlich ungeniessbar", 0);
		return;
	}
	if ((obj->which_kind == FRUIT) || rand_percent(60)) {
		moves = get_rand(950, 1150);
		if (obj->which_kind == RATION) {
			message("Das war wirklich lecker", 0);
		} else {
			char buf[70];

			sprintf(buf, "Das war aber eine saftige %s", fruit);
			message(buf, 0);
		}
	} else {
		moves = get_rand(750, 950);
		message("Igitt, das schmeckt ja fuerchterlich", 0);
		add_exp(2, 1);
	}
	rogue.moves_left /= 3;
	rogue.moves_left += moves;
	hunger_str[0] = 0;
	print_stats(STAT_HUNGER);

	vanish(obj, 1, &rogue.pack);
}

hold_monster()
{
	short i, j;
	short mcount = 0;
	object *monster;
	short row, col;

	for (i = -2; i <= 2; i++) {
		for (j = -2; j <= 2; j++) {
			row = rogue.row + i;
			col = rogue.col + j;
			if ((row < MIN_ROW) || (row > (DROWS-2)) || (col < 0) ||
				 (col > (DCOLS-1))) {
				continue;
			}
			if (dungeon[row][col] & MONSTER) {
				monster = object_at(&level_monsters, row, col);
				monster->m_flags |= ASLEEP;
				monster->m_flags &= (~WAKENS);
				mcount++;
			}
		}
	}
	if (mcount == 0) {
		message("Du hast das komische Gefuehl, etwas verloren zu haben", 0);
	} else if (mcount == 1) {
		message("Das Monster bleibt stehen", 0);
	} else {
		message("Alle Monster um dich herum erstarren zur Salzsaeule", 0);
	}
}

tele()
{
	mvaddch(rogue.row, rogue.col, get_dungeon_char(rogue.row, rogue.col));

	if (cur_room >= 0) {
		darken_room(cur_room);
	}

	put_player();
	being_held = 0;
	bear_trap = 0;
}

hallucinate()
{
	object *obj, *monster;
	short ch;

	if (blind) return;

	obj = level_objects.next_object;

	while (obj) {
		ch = mvinch(obj->row, obj->col);
		if (((ch < 'A') || (ch > 'Z')) &&
			((obj->row != rogue.row) || (obj->col != rogue.col)))
		if ((ch != ' ') && (ch != '.') && (ch != '#') && (ch != '+')) {
			addch(gr_obj_char());
		}
		obj = obj->next_object;
	}
	monster = level_monsters.next_monster;

	while (monster) {
		ch = mvinch(monster->row, monster->col);
		if ((ch >= 'A') && (ch <= 'Z')) {
			addch(get_rand('A', 'Z'));
		}
		monster = monster->next_monster;
	}
}

unhallucinate()
{
	halluc = 0;
	relight();
	message("alles sieht jetzt sooo langweilig aus...", 1);
}

unblind()
{
	blind = 0;
	message("Der Vorhang der Dunkelheit hebt sich", 1);
	relight();
	if (halluc) {
		hallucinate();
	}
	if (detect_monster) {
		show_monsters();
	}
}

relight()
{
	if (cur_room == PASSAGE) {
		light_passage(rogue.row, rogue.col);
	} else {
		light_up_room(cur_room);
	}
	mvaddch(rogue.row, rogue.col, rogue.fchar);
}

take_a_nap()
{
	short i;

	i = get_rand(2, 5);
	md_sleep(1);

	while (i--) {
		mv_mons();
	}
	md_sleep(1);
	message(you_can_move_again, 0);
}

go_blind()
{
	short i, j;

	if (!blind) {
		if (halluc) {
			message("Oh verdammt! Es ist so dunkel hier", 0);
		} else {
			message("Ein dunkler Umhang faellt auf dich herab", 0);
		}
	}
	blind += get_rand(500, 800);

	if (detect_monster) {
		object *monster;

		monster = level_monsters.next_monster;

		while (monster) {
			mvaddch(monster->row, monster->col, monster->trail_char);
			monster = monster->next_monster;
		}
	}
	if (cur_room >= 0) {
		for (i = rooms[cur_room].top_row + 1;
			 i < rooms[cur_room].bottom_row; i++) {
			for (j = rooms[cur_room].left_col + 1;
				 j < rooms[cur_room].right_col; j++) {
				mvaddch(i, j, ' ');
			}
		}
	}
	mvaddch(rogue.row, rogue.col, rogue.fchar);
}

char *
get_ench_color()
{
	if (halluc) {
		return(id_potions[get_rand(0, POTIONS-1)].title);
	} else if (con_mon) {
		return("rote");
	} 
	return("blaue");
}

cnfs()
{
	confused += get_rand(12, 22);
}

unconfuse()
{
	char msg[80];

	confused = 0;
	sprintf(msg,"Du fuehlst dich jetzt weniger %s", (halluc ? "beschwingt" : "durcheinander"));
	message(msg, 1);
}

uncurse_all()
{
	object *obj;

	obj = rogue.pack.next_object;

	while (obj) {
		obj->is_cursed = 0;
		obj = obj->next_object;
	}
}
