/*
 * inventory.c
 *
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 *
 * Credit should be given to the following autors:
 *	  Tim Stoehr (tims@zeus.TEK.COM) autor of the rogue-clone II
 *	  J. Erwied  translation to german version III.g
 * There may be more, I don't know. I've requested it from the german
 * UNIDO file server and made the following additions:
 *	Bug fixed in dynamic memory allocation
 *	Ported to Coherent 3.2
 *	Ported to SCO UNIX
 *	Additional conditional compiling for BBS, where all users login
 *	on the same account.
 * Udo Munk (udo@umunk.GUN.de)
 */

#include "rogue.h"

boolean is_wood[WANDS];
char *press_space = " -- Leertaste fuer weiter --";

extern char *make_case();

char *wand_materials[WAND_MATERIALS] = {
	"Stahl ",
	"Bronze ",
	"Gold ",
	"Silber ",
	"Kupfer ",
	"Nickel ",
	"Kobalt ",
	"Zinn ",
	"Eisen ",
	"Magnesium ",
	"Chrom ",
	"Kohlenstoff ",
	"Platin ",
	"Silikon ",
	"Titan ",

	"Teak ",
	"Eiche ",
	"Kirsche ",
	"Birke ",
	"Pinie ",
	"Zeder ",
	"Rotholz ",
	"Balsa ",
	"Elfenbein ",
	"Walnuss ",
	"Ahorn ",
	"Mahagoni ",
	"Ulme ",
	"Palme ",
	"Holz "
};

char *gems[GEMS] = {
	"Diamant ",
	"Tantal ",
	"Lapislazuli ",
	"Rubin ",
	"Smaragd ",
	"Saphir ",
	"Amethyst ",
	"Quarz ",
	"Tigerauge ",
	"Opal ",
	"Achat ",
	"Tuerkis ",
	"Perlen ",
	"Granat "
};

char *syllables[MAXSYLLABLES] = {
	"blech ",
	"foo ",
	"barf ",
	"rech ",
	"bar ",
	"blech ",
	"quo ",
	"bloto ",
	"oh ",
	"caca ",
	"blorp ",
	"erp ",
	"festr ",
	"rot ",
	"slie ",
	"snorf ",
	"iky ",
	"yuky ",
	"ooze ",
	"ah ",
	"bahl ",
	"zep ",
	"druhl ",
	"flem ",
	"behil ",
	"arek ",
	"mep ",
	"zihr ",
	"grit ",
	"kona ",
	"kini ",
	"ichi ",
	"tims ",
	"ogr ",
	"oo ",
	"ighr ",
	"coph ",
	"swerr ",
	"mihln ",
	"poxi "
};

#define COMS 47

struct id_com_s {
	short com_char;
	char *com_desc;
};

struct id_com_s com_id_tab[COMS] = {
	'?',	"?       Druckt Hilfe",
	'r',	"r       Schriftrolle lesen",
	'/',	"/       Objekt identifizieren",
	'e',	"e       Nahrung zu sich nehmen",
	'h',	"h       links",
	'w',	"w       Waffe tragen",
	'j',	"j       runter",
	'W',	"W       Ruestung tragen",
	'k',	"k       hoch",
	'T',	"T       Ruestung ablegen",
	'l',	"l       rechts",
	'P',	"P       Ring aufsetzen",
	'y',	"y       links hoch",
	'R',	"R       Ring absetzen",
	'u',	"u       rechts hoch",
	'd',	"d       Objekt wegwerfen",
	'b',	"b       links runter",
	'c',	"c       Objekt benennen",
	'n',	"n       rechts runter",
	'\300',	"<SHIFT><dir>: in Richtung laufen",
	')',	")       aktive Waffe ausgeben",
	'\300',	"<CTRL><dir>: laufen bis Hindernis",
	']',	"]       aktive Ruestung ausgeben",
	'f',	"f<dir>  bis (fast) zum Tod kaempfen",
	'=',	"=       aufgesetzte Ringe ausgeben",
	't',	"t<dir>  etwas werfen",
	'm',	"m<dir>  auf etwas gehen ohne zu nehmen",
	'z',	"z<dir>  in die Richtung zaubern",
	'o',	"o       Optionen aendern/setzen",
	'^',	"^<dir>  Fallentyp identifizieren",
	'\022',	"^R      Bildschirm neu aufbauen",
	'&',	"&       Bildschirm => '~/rogue.screen'",
	's',	"s       Nach Tuer/Falle suchen",
	'\020',	"^P      Letzte Meldung wiederholen",
	'>',	">       Treppe abwaerts",
	'\033',	"^[      Kommando widerrufen",
	'<',	"<       Treppe aufwaerts",
	'S',	"S       Spiel speichern",
	'.',	".       Augenblick warten",
	'Q',	"Q       Spiel beenden",
	',',	",       etwas aufnehmen",
	'!',	"!       Shell aufrufen",
	'i',	"i       Inhaltsverzeichnis",
	'F',	"F<dir>  bis zum Tod kaempfen",
	'I',	"I       Inhaltsverzeichnis, Einzelteil",
	'v',	"v       Version ausgeben",
	'q',	"q       Arznei einnehmen"
};

extern boolean wizard;
extern char *m_names[], *more;

inventory(pack, mask)
object *pack;
unsigned short mask;
{
	object *obj;
	short i = 0, j, maxlen = 0, n;
	char descs[MAX_PACK_COUNT+1][DCOLS];
	short row, col;

	obj = pack->next_object;

	if (!obj) {
		message("Dein Rucksack ist leer", 0);
		return;
	}
	while (obj) {
		if (obj->what_is & mask) {
			descs[i][0] = ' ';
			descs[i][1] = obj->ichar;
			descs[i][2] = ((obj->what_is & ARMOR) && obj->is_protected)
				? '}' : ')';
			descs[i][3] = ' ';
			get_desc(obj, descs[i]+4);
			if ((n = strlen(descs[i])) > maxlen) {
				maxlen = n;
			}
		i++;
		}
		obj = obj->next_object;
	}
	(void) strcpy(descs[i++], press_space);
	if (maxlen < 27) maxlen = 27;
	col = DCOLS - (maxlen + 2);

	for (row = 0; ((row < i) && (row < DROWS)); row++) {
		if (row > 0) {
			for (j = col; j < DCOLS; j++) {
				descs[row-1][j-col] = mvinch(row, j);
			}
			descs[row-1][j-col] = 0;
		}
		mvaddstr(row, col, descs[row]);
		clrtoeol();
	}
	refresh();
	wait_for_ack();

	move(0, 0);
	clrtoeol();

	for (j = 1; ((j < i) && (j < DROWS)); j++) {
		mvaddstr(j, col, descs[j-1]);
	}
}

id_com()
{
	int ch = 0;
	short i, j, k;

	while (ch != CANCEL) {
		(void) check_message();
		message("Hilfe fuer welches Zeichen (* fuer alle):", 0);

		refresh();
		ch = getchar();

		switch(ch) {
		case LIST:
			{
				char save[(((COMS / 2) + (COMS % 2)) + 1)][DCOLS];
				short rows = (((COMS / 2) + (COMS % 2)) + 1);
				boolean need_two_screens;

				if (rows > LINES) {
					need_two_screens = 1;
					rows = LINES;
				}
				k = 0;

				for (i = 0; i < rows; i++) {
					for (j = 0; j < DCOLS; j++) {
						save[i][j] = mvinch(i, j);
					}
				}
MORE:
				for (i = 0; i < rows; i++) {
					move(i, 0);
					clrtoeol();
				}
				for (i = 0; i < (rows-1); i++) {
					if (i < (LINES-1)) {
						if (((i + i) < COMS) && ((i+i+k) < COMS)) {
							mvaddstr(i, 0, com_id_tab[i+i+k].com_desc);
						}
						if (((i + i + 1) < COMS) && ((i+i+k+1) < COMS)) {
							mvaddstr(i, (DCOLS/2),
										com_id_tab[i+i+k+1].com_desc);
						}
					}
				}
				mvaddstr(rows - 1, 0, need_two_screens ? more : press_space);
				refresh();
				wait_for_ack();

				if (need_two_screens) {
					k += ((rows-1) * 2);
					need_two_screens = 0;
					goto MORE;
				}
				for (i = 0; i < rows; i++) {
					move(i, 0);
					for (j = 0; j < DCOLS; j++) {
						addch(save[i][j]);
					}
				}
			}
			break;
		default:
			if (!pr_com_id(ch)) {
				if (!pr_motion_char(ch)) {
					(void) check_message();
					message("unbekanntes Zeichen", 0);
				}
			}
			ch = CANCEL;
			break;
		}
	}
}

pr_com_id(ch)
int ch;
{
	int i;

	if (!get_com_id(&i, ch)) {
		return(0);
	}
	(void) check_message();
	message(com_id_tab[i].com_desc, 0);
	return(1);
}

get_com_id(index, ch)
int *index;
short ch;
{
	short i;

	for (i = 0; i < COMS; i++) {
		if (com_id_tab[i].com_char == ch) {
			*index = i;
			return(1);
		}
	}
	return(0);
}

pr_motion_char(ch)
int ch;
{
	if (	(ch == 'J') ||
			(ch == 'K') ||
			(ch == 'L') ||
			(ch == 'H') ||
			(ch == 'Y') ||
			(ch == 'U') ||
			(ch == 'N') ||
			(ch == 'B') ||
			(ch == '\012') ||
			(ch == '\013') ||
			(ch == '\010') ||
			(ch == '\014') ||
			(ch == '\025') ||
			(ch == '\031') ||
			(ch == '\016') ||
			(ch == '\002')) {
		char until[18], buf[DCOLS];
		int n;

		if (ch <= '\031') {
			ch += 96;
			(void) strcpy(until, "bis zum Hindernis");
		} else {
			ch += 32;
			until[0] = '\0';
		}
		(void) get_com_id(&n, ch);
		sprintf(buf, "%s laufen %s", com_id_tab[n].com_desc + 8, until);
		(void) check_message();
		message(buf, 0);
		return(1);
	} else {
		return(0);
	}
}

mix_colors()
{
	short i, j, k;
	char *t;

	for (i = 0; i <= 32; i++) {
		j = get_rand(0, (POTIONS - 1));
		k = get_rand(0, (POTIONS - 1));
		t = id_potions[j].title;
		id_potions[j].title = id_potions[k].title;
		id_potions[k].title = t;
	}
}

make_scroll_titles()
{
	short i, j, n;
	short sylls, s;

	for (i = 0; i < SCROLS; i++) {
		sylls = get_rand(2, 5);
		(void) strcpy(id_scrolls[i].title, "'");

		for (j = 0; j < sylls; j++) {
			s = get_rand(1, (MAXSYLLABLES-1));
			(void) strcat(id_scrolls[i].title, syllables[s]);
		}
		n = strlen(id_scrolls[i].title);
		(void) strcpy(id_scrolls[i].title+(n-1), "' ");
	}
}

get_desc(obj, desc)
object *obj;
char *desc;
{
	char *item_name;
	struct id *id_table;
	char more_info[32];

	if (obj->what_is == AMULET) {
		(void) strcpy(desc, "Das Amulett von Yendor ");
		return;
	}
	item_name = make_case(name_of(obj),8);

	if (obj->what_is == GOLD) {
		sprintf(desc, "%d Goldstuecke", obj->quantity);
		return;
	}

	if (obj->what_is != ARMOR) {
		if (obj->quantity == 1) {
			(void) strcpy(desc, "\0");
		} else {
			sprintf(desc, "%d ", obj->quantity);
		}
	}
	if (obj->what_is == FOOD) {
		if (obj->which_kind == RATION) {
			if (obj->quantity > 1) {
				sprintf(desc, "%d Portionen ", obj->quantity);
			} else {
				(void) strcpy(desc, "etwas ");
			}
		} else {
			(void) strcpy(desc, "\0");
		}
		(void) strcat(desc, item_name);
		goto ANA;
	}
	id_table = get_id_table(obj);

	if (wizard) {
		goto ID;
	}
	if (obj->what_is & (WEAPON | ARMOR | WAND | RING)) {
		goto CHECK;
	}

	switch(id_table[obj->which_kind].id_status) {
	case UNIDENTIFIED:
CHECK:
		switch(obj->what_is) {
		case SCROL:
			(void) strcat(desc, item_name);
			(void) strcat(desc, "mit Namen: ");
			(void) strcat(desc, id_table[obj->which_kind].title);
			break;
		case POTION:
			(void) strcat(desc, id_table[obj->which_kind].title);
			(void) strcat(desc, item_name);
			break;
		case WAND:
		case RING:
			if (obj->identified ||
			(id_table[obj->which_kind].id_status == IDENTIFIED)) {
				goto ID;
			}
			if (id_table[obj->which_kind].id_status == CALLED) {
				goto CALL;
			}
			(void) strcat(desc, item_name);
			(void) strcat(desc, "aus ");
			(void) strcat(desc, id_table[obj->which_kind].title);
				break;
		case ARMOR:
			if (obj->identified) {
				goto ID;
			}
			(void) strcpy(desc, make_case(id_table[obj->which_kind].title,4));
			break;
		case WEAPON:
			if (obj->identified) {
				goto ID;
			}
			(void) strcat(desc, make_case(name_of(obj),8));
			break;
		}
		break;
	case CALLED:
CALL:	switch(obj->what_is) {
		case SCROL:
		case POTION:
		case WAND:
		case RING:
			(void) strcat(desc, item_name);
			(void) strcat(desc, "mit Namen ");
			(void) strcat(desc, id_table[obj->which_kind].title);
			break;
		}
		break;
	case IDENTIFIED:
ID:		switch(obj->what_is) {
		case SCROL:
		case POTION:
			(void) strcat(desc, item_name);
			(void) strcat(desc, id_table[obj->which_kind].real);
			break;
		case RING:
			if (wizard || obj->identified) {
				if ((obj->which_kind == DEXTERITY) ||
					(obj->which_kind == ADD_STRENGTH)) {
					sprintf(more_info, "%s%d ", ((obj->class > 0) ? "+" : ""),
						obj->class);
					(void) strcat(desc, more_info);
				}
			}
			(void) strcat(desc, item_name);
			(void) strcat(desc, id_table[obj->which_kind].real);
			break;
		case WAND:
			(void) strcat(desc, item_name);
			(void) strcat(desc, id_table[obj->which_kind].real);
			if (wizard || obj->identified) {
				sprintf(more_info, "[%d]", obj->class);
				(void) strcat(desc, more_info);
			}
			break;
		case ARMOR:
			sprintf(desc, "%s%d ", ((obj->d_enchant >= 0) ? "+" : ""),
			obj->d_enchant);
			(void) strcat(desc, make_case(id_table[obj->which_kind].title,8));
			sprintf(more_info, "[%d] ", get_armor_class(obj));
			(void) strcat(desc, more_info);
			break;
		case WEAPON:
			sprintf(desc+strlen(desc), "%s%d,%s%d ",
			((obj->hit_enchant >= 0) ? "+" : ""), obj->hit_enchant,
			((obj->d_enchant >= 0) ? "+" : ""), obj->d_enchant);
			(void) strcat(desc, make_case(name_of(obj),8));
			break;
		}
		break;
	}
ANA:

	if (obj->in_use_flags & BEING_WIELDED) {
		(void) strcat(desc, ", in der Hand");
	} else if (obj->in_use_flags & BEING_WORN) {
		(void) strcat(desc, ", wird getragen");
	} else if (obj->in_use_flags & ON_LEFT_HAND) {
		(void) strcat(desc, ", auf der linken Hand");
	} else if (obj->in_use_flags & ON_RIGHT_HAND) {
		(void) strcat(desc, ", auf der rechten Hand");
	}
}

get_wand_and_ring_materials()
{
	short i, j;
	boolean used[WAND_MATERIALS];

	for (i = 0; i < WAND_MATERIALS; i++) {
		used[i] = 0;
	}
	for (i = 0; i < WANDS; i++) {
		do {
			j = get_rand(0, WAND_MATERIALS-1);
		} while (used[j]);
		used[j] = 1;
		(void) strcpy(id_wands[i].title, wand_materials[j]);
		is_wood[i] = (j > MAX_METAL);
	}
	for (i = 0; i < GEMS; i++) {
		used[i] = 0;
	}
	for (i = 0; i < RINGS; i++) {
		do {
			j = get_rand(0, GEMS-1);
		} while (used[j]);
		used[j] = 1;
		(void) strcpy(id_rings[i].title, gems[j]);
	}
}

single_inv(ichar)
short ichar;
{
	char desc[DCOLS];
	object *obj;

	if (!(obj = user_obj("Inhaltsverzeichnis wofuer?", ALL_OBJECTS, ichar))) {
		return;
	}
	desc[0] = obj->ichar;
	desc[1] = ((obj->what_is & ARMOR) && obj->is_protected) ? '}' : ')';
	desc[2] = ' ';
	desc[3] = 0;
	get_desc(obj, desc+3);
	message(desc, 0);
}

struct id *
get_id_table(obj)
object *obj;
{
	switch(obj->what_is) {
	case SCROL:
		return(id_scrolls);
	case POTION:
		return(id_potions);
	case WAND:
		return(id_wands);
	case RING:
		return(id_rings);
	case WEAPON:
		return(id_weapons);
	case ARMOR:
		return(id_armors);
	}
	return((struct id *) 0);
}

inv_armor_weapon(is_weapon)
boolean is_weapon;
{
	if (is_weapon) {
		if (rogue.weapon) {
			single_inv(rogue.weapon->ichar);
		} else {
			message("keine Waffe in Gebrauch", 0);
		}
	} else {
		if (rogue.armor) {
			single_inv(rogue.armor->ichar);
		} else {
			message("keine Ruestung angelegt", 0);
		}
	}
}

id_type()
{
	char *id;
	int ch;
	char buf[DCOLS];

	message("Was willst du identifizieren?", 0);

	ch = rgetchar();

	if ((ch >= 'A') && (ch <= 'Z')) {
		id = make_case(m_names[ch-'A'],4);
	} else if (ch < 32) {
		(void) check_message();
		return;
	} else {
		switch(ch) {
		case '@':
			id = "Du selbst";
			break;
		case '%':
			id = "Eine Leiter";
			break;
		case '^':
			id = "Eine Falle";
			break;
		case '+':
			id = "Eine Tuer";
			break;
		case '-':
		case '|':
			id = "Die Wand des Raumes";
			break;
		case '.':
			id = "Der Fussboden";
			break;
		case '#':
			id = "Ein Verbindungsgang";
			break;
		case ' ':
			id = "Solider Fels";
			break;
		case '=':
			id = "Ein Ring";
			break;
		case '?':
			id = "Eine Schriftrolle";
			break;
		case '!':
			id = "Eine Arznei";
			break;
		case '/':
			id = "Ein Stock oder Zauberstab";
			break;
		case ')':
			id = "Eine Waffe";
			break;
		case ']':
			id = "Eine Ruestung";
			break;
		case '*':
			id = "Gold";
			break;
		case ':':
			id = "Nahrung";
			break;
		case ',':
			id = "Das Amulett von Yendor";
			break;
		default:
			id = "Unbekanntes Zeichen";
			break;
		}
	}
	(void) check_message();
	sprintf(buf, "'%c': %s", ch, id);
	message(buf, 0);
}

