/******************************************************************************

			UNSW Prolog (version 4)

			Written by Claude Sammut
		     Department of Computer Science
		     University of New South Wales
		   (and St. Joseph's U., Philadelphia)

		   Copyright (c)  1983 - Claude Sammut

******************************************************************************/





	/*	predicates for accesing internals of data structures	*/


#include "pred.h"

extern integer *stack_int;

static
nvars PREDICATE
{
	if (TYPE(arg[0]) != CLAUSE)
		fail("Nvars - first argument must be a clause")
	return(unify(arg[1], frame[1], stack_int, arg[0] -> g.nvars));
}


static
goal PREDICATE
{
	register i, n;
	register clause *p;

	if (! isinteger(arg[0]))
		fail("Goal - first argument must be a integer")
	if (TYPE(arg[1]) != CLAUSE)
		fail("Goal - second argument must be a clause")

	p = (clause *) arg[1];
	n = INT_VAL(0);

	for (i = 0; i <= n; i++)
		if (p -> goal[i] == 0) return(FALSE);
	return(unify(arg[2], frame[2], p -> goal[n], frame[1]));
}


static
offset PREDICATE
{
	if (isvariable(arg[0]))
		return(unify(arg[1], frame[1], stack_int, arg[0] -> v.offset));
	else
		fail("Offset - first argument must be variable")
}

/*

struct
{
	atom *tab_addr;
	char *tab_name;
} tab_info[] =
{
	{p_IO,		"p_IO"},
	{p_access,	"p_access"},
	{p_bag,		"p_bag"},
	{p_basic,	"p_basic"},
	{p_behave,	"p_behave"},
	{p_clause,	"p_clause"},
	{p_files,	"p_files"},
	{p_meta,	"p_meta"},
	{p_unix,	"p_unix"},
	{pred,		"pred"}
};


global PREDICATE
{
	extern pval intern();
	register i, j, n, m;
	register pval p;
	char buf[16];

	n = abs(tab_info[0] - (atom *)(arg[0]));
	j = 0;
	i = 1;
	do {
		m = abs(tab_info[i] -> tab_addr - (atom *)(arg[0]));
		if (m < n) {n = m; j = i}
	} while (tab_info[i++] -> addr != pred);

	sprintf(buf, "%s[%d]", tab_info[j] -> tab_name, n);
	p = intern(buf, strlen(buf) + 1);
	bind(arg[1], frame[1], p, 0);
	return(TRUE);
}

*/


atom_table p_access =
{
	SET_PRED(NONOP, 0, 2, "nvars", nvars),
	SET_PRED(NONOP, 0, 3, "goal", goal),
	SET_PRED(NONOP, 0, 2, "offset", offset),
	END_MARK
};
