/******************************************************************************

			UNSW Prolog (version 4)

			Written by Claude Sammut
		     Department of Computer Science
		     University of New South Wales
		   (and St. Joseph's U., Philadelphia)

		   Copyright (c)  1983 - Claude Sammut

******************************************************************************/





/* 	global declarations		*/


#define FALSE		0
#define TRUE		1
#ifdef vax
#define WORD_LENGTH 	4		/* for VAX */
#else
#define WORD_LENGTH 	2		/* for PDP-11 */
#endif
#define LIB		".prologlib"
#define NEWS		" "
#define DEFAULT_ED	"me"

/*	PRINC_VAR is defined if princial terms are to be unified	*/

#define PRINC_VAR

#define NPRED		-1
#define HASHSIZE	128
#define MAXVAR		100
#define repeat		for(;;)


#define CLAUSE	0
#define FN	1
#define ATOM	2
#define PREDEF	3
#define INT	4
#define VAR	5
#define LIST	6
#define FREE	7

#define XFX	0
#define XFY	1
#define YFX	2
#define FX	3
#define FY	4
#define XF	5
#define YF	6
#define	NONOP	7
#define QATOM	8

typedef char card;
typedef char itemtype;
typedef char optype;


/*	record structures in free space		*/

typedef union pobj *pval;

typedef struct atom
{
	itemtype type;
	optype op_t;
	short pred;
	card traced;
	char lib;
	char *name;
	struct clause *val;
	struct atom *link;
} atom;

typedef struct predef
{
	itemtype type;
	optype op_t;
	short pred;
	card traced;
	card nargs;
	char *name;
	int (*fn)();
	struct atom *link;
} predef;

typedef struct integer {itemtype type; int int_val;} integer;

typedef struct compterm
{
	itemtype type;
	card size;
	pval term[1];
} compterm;		/* KLUDGE */

typedef struct clause
{
	itemtype type;
	card nvars;
	struct clause *rest;
	pval goal[1];
} clause;

typedef struct var
{
	itemtype type;
	card offset;
	struct atom *pname;
} var;

union pobj
{
	struct atom	a;
	struct compterm	c;
	struct predef	p;
	struct integer	i;
	struct var	v;
	struct clause	g;
};



/*	stack records used by interpreter	*/



typedef struct binding
{
	pval termv;
	struct binding *framev;
} binding;

typedef struct environment
{
	pval *cl;
	short tracing;
	short sp;
	clause *clist;
	short parent;
	short tp;
} environment;



/*		type checking macros		*/


#define isinteger(x) (((integer *) x) -> type == INT)

#define isvariable(x) (((var *) x) -> type == VAR)

#define iscompound(x) (((compterm *) x) -> type == FN)

#define islist(x) (((compterm *) x) -> type == LIST)

#define isatom(x)\
(\
	   (((atom *) x) -> type == ATOM)\
	|| (((atom *) x) -> type == PREDEF)\
)

#define TYPE(x)	(((compterm *) x) -> type)
#define SIZE(x) (((compterm *) x) -> size)
#define NAME(x) (((atom *) x) -> name)
#define VAL(x) (((atom *) x) -> val)
#define FVAL(x) (* (x -> p.fn))
#define OFFSET(x) (((var *) x) -> offset)
