
#define SCANNER

/*{{{  #includes*/
#include <ctype.h>
#include <stdio.h>

#include "bool.h"

#include "keys.h"
#include "keybind.h"
#include "scanner.h"
/*}}}  */

int    input=EOF;

/*{{{  keybinding table type and declaration*/
KEY bindings[]=
{
  /*{{{  moving cursor*/
  "backward-character", O_LEFT,  "O_LEFT", O_LEFT,
  "forward-character", O_RIGHT,  "O_RIGHT", O_RIGHT,
  "previous-line", O_UP,  "O_UP", O_UP,
  "next-line", O_DOWN,  "O_DOWN", O_DOWN,
  "beginning-of-line", O_START_OF_LINE,  "O_START_OF_LINE", O_START_OF_LINE,
  "end-of-line", O_END_OF_LINE,  "O_END_OF_LINE", O_END_OF_LINE,
  "previous-word", O_WORD_LEFT,  "O_WORD_LEFT", O_WORD_LEFT,
  "next-word", O_WORD_RIGHT,  "O_WORD_RIGHT", O_WORD_RIGHT,
  "previous-page", O_PAGE_UP,  "O_PAGE_UP", O_PAGE_UP,
  "next-page", O_PAGE_DOWN,  "O_PAGE_DOWN", O_PAGE_DOWN,
  "beginning-of-fold", O_TOP_OF_FOLD,  "O_TOP_OF_FOLD", O_TOP_OF_FOLD,
  "end-of-fold", O_BOT_OF_FOLD,  "O_BOT_OF_FOLD", O_BOT_OF_FOLD,
  "goto-line", O_GOTO_LINE,  "O_GOTO_LINE", O_GOTO_LINE,
  "previous-line-and-scroll-down", O_LINE_UP,  "O_LINE_UP", O_LINE_UP,
  "next-line-and-scroll-up", O_LINE_DOWN,  "O_LINE_DOWN", O_LINE_DOWN,
  /*}}}  */
  /*{{{  folding*/
  "open-fold", O_OPEN_FOLD,  "O_OPEN_FOLD", O_OPEN_FOLD,
  "close-fold", O_CLOSE_FOLD,  "O_CLOSE_FOLD", O_CLOSE_FOLD,
  "enter-fold", O_ENTER_FOLD,  "O_ENTER_FOLD", O_ENTER_FOLD,
  "exit-fold", O_EXIT_FOLD,  "O_EXIT_FOLD", O_EXIT_FOLD,
  "unfold-fold", O_REMOVE_FOLD,  "O_REMOVE_FOLD", O_REMOVE_FOLD,
  "create-fold", O_CREATE_FOLD,  "O_CREATE_FOLD", O_CREATE_FOLD,
  "create-auto-fold", O_AUTO_FOLD,  "O_AUTO_FOLD", O_AUTO_FOLD,
  "auto-header", O_FIRST_LINE_TO_FOLD_HEADER,
       "O_FIRST_LINE_TO_FOLD_HEADER", O_FIRST_LINE_TO_FOLD_HEADER,
  "toggle-create-file-fold", O_FILE_FOLD,  "O_FILE_FOLD", O_FILE_FOLD,
  "open-file-fold", O_ATTACH_FILE,  "O_ATTACH_FILE", O_ATTACH_FILE,
  /*}}}  */
  /*{{{  editing*/
  "delete-to-end-of-line", O_DELTO_EOL,  "O_DEL_TO_EOL", O_DELTO_EOL,
  "delete-line", O_DEL_LINE,  "O_DEL_LINE", O_DEL_LINE,
  "undo-delete-line", O_UNDEL_LINE,  "O_UNDEL_LINE", O_UNDEL_LINE,
  "delete-character", O_DEL_CHAR_R,  "O_DEL_CHAR_RIGHT", O_DEL_CHAR_R,
  "delete-previous-character", O_DELETE,  "O_DELETE", O_DELETE,
  "undo-delete-character", O_UNDEL_CHAR,  "O_UNDEL_CHAR", O_UNDEL_CHAR,
  "transpose-characters", O_TRANSPOSE_CHARACTERS,
  "case-word-capitalize", O_CAPITALIZE_WORD,
  "case-word-upper", O_UPPERCASE_WORD,
  "case-word-lower", O_LOWERCASE_WORD,
  "newline-and-indent", O_RETURN,  "O_RETURN", O_RETURN,
  "kill-line", O_PICK,  "O_PICK", O_PICK,
  "copy-to-kill-buffer", O_COPY_PICK,  "O_COPY_PICK", O_COPY_PICK,
  "fold-kill-buffer", O_PUT_PICK,  "O_PUT_PICK", O_PUT_PICK,
  "move-line", O_MOVE,  "O_MOVE", O_MOVE,
  "double-line", O_COPY,  "O_COPY", O_COPY,
  /*}}}  */
  /*{{{  search & replace*/
  "search-forward-same", O_FIND_NEXT,  "O_FIND_NEXT", O_FIND_NEXT,
  "search-forward", O_FIND,  "O_FIND", O_FIND,
  "search-reverse", O_FIND_REVERSE, "O_FIND_REVERSE", O_FIND_REVERSE,
  "replace-string", O_REPLACE,
  "query-replace-string", O_QUERY_REPLACE,
  /*}}}  */
  /*{{{  files*/
  "read-file", O_OPEN_NEW_FILE,  "O_OPEN_NEW_FILE", O_OPEN_NEW_FILE,
  "save-file", O_SAVE_FILE,  "O_SAVE_FILE", O_SAVE_FILE,
  "write-file", O_WRITE_FILE,
  "insert-file", O_INSERT_FILE,  "O_INSERT_FILE", O_INSERT_FILE,
  /*}}}  */
  /*{{{  macros*/
  "define-macro", O_DEF_MACRO,  "O_DEFINE_MACRO", O_DEF_MACRO,
  "execute-macro-32", O_CALL_FIX_32,
  "execute-macro-31", O_CALL_FIX_31,
  "execute-macro-30", O_CALL_FIX_30,
  "execute-macro-29", O_CALL_FIX_29,
  "execute-macro-28", O_CALL_FIX_28,
  "execute-macro-27", O_CALL_FIX_27,
  "execute-macro-26", O_CALL_FIX_26,
  "execute-macro-25", O_CALL_FIX_25,
  "execute-macro-24", O_CALL_FIX_24,
  "execute-macro-23", O_CALL_FIX_23,
  "execute-macro-22", O_CALL_FIX_22,
  "execute-macro-21", O_CALL_FIX_21,
  "execute-macro-20", O_CALL_FIX_20,
  "execute-macro-19", O_CALL_FIX_19,
  "execute-macro-18", O_CALL_FIX_18,
  "execute-macro-17", O_CALL_FIX_17,
  "execute-macro-16", O_CALL_FIX_16,
  "execute-macro-15", O_CALL_FIX_15,
  "execute-macro-14", O_CALL_FIX_14,
  "execute-macro-13", O_CALL_FIX_13,
  "execute-macro-12", O_CALL_FIX_12,
  "execute-macro-11", O_CALL_FIX_11,
  "execute-macro-10", O_CALL_FIX_10,
  "execute-macro-9", O_CALL_FIX_9,
  "execute-macro-8", O_CALL_FIX_8,
  "execute-macro-7", O_CALL_FIX_7,
  "execute-macro-6", O_CALL_FIX_6,
  "execute-macro-5", O_CALL_FIX_5,
  "execute-macro-4", O_CALL_FIX_4,
  "execute-macro-3", O_CALL_FIX_3,
  "execute-macro-2", O_CALL_FIX_2,
  "execute-macro-1", O_CALL_FIX_1,
  "execute-macro", O_EXE_MACRO,  "O_EXECUTE_MACRO", O_EXE_MACRO,
  "O_DEFINE_FIX", O_DEF_FIX,
  /*}}}  */
  /*{{{  shell commands*/
  "i-shell", O_SUSPEND,  "O_SUSPEND", O_SUSPEND,
  "shell-command", O_SHELL_COMMAND,
  /*}}}  */
  /*{{{  special commands*/
  "redraw-display", O_REFRESH,  "O_REFRESH", O_REFRESH,
  "help", O_HELP,  "O_HELP", O_HELP,
  "describe-bindings", O_DESCRIBE_BINDINGS,
  "set-language", O_LANGUAGE,  "O_LANGUAGE", O_LANGUAGE,
  "describe-fold", O_FOLD_INFO,  "O_FOLD_INFO", O_FOLD_INFO,
  "toggle-viewmode", O_BROWSE,  "O_BROWSE", O_BROWSE,
  /*}}}  */
  /*{{{  how to get out*/
  "quick-exit", O_FINISH,  "O_FINISH", O_FINISH,
  "exit-origami", O_QUIT,  "O_QUIT", O_QUIT,
  /*}}}  */
  "", 0
};
/*}}}  */
/*{{{  keywords*/
keywords keytab[]={
  "defbinding", BINDNAME,
  "keybind",    KEYDEF,
  "alias",      KEYALIAS,
  "deffun",     DEFMACRO,
  "initfun",    INITMACRO,
  "forward",    FORWARD,
  "defmac",     DEFOP,
  "repeat",     REPEAT,
  "case",       CASE,
  "esac",       ESAC,
  "do",         DO,
  "while",      WHILE,
  "if",         IF,
  "else",       ELSE,
  "fi",         FI,
  "and",        AND,
  "or",         OR,
  "not",        NOT,
  "test-filed", TEST_FILED,
  "test-fold-line",  TEST_FOLD_LINE,
  "test-begin-fold", TEST_BEGIN_FOLD,
  "test-end-fold",   TEST_END_FOLD,
  "test-text",  TEST_TEXT,
  "test-top",   TEST_TOP,
  "test-bottom",TEST_BOTTOM,
  "test-char",  TEST_CHAR,
  "counter-0",  COUNTER_NULL,
  "counter>0",  C_POSITIV,
  "test-begin-line", TEST_BEGIN_LINE,
  "test-end-line",   TEST_END_LINE,
  "set-counter",     SET_COUNTER,
  "add-counter",     ADD_COUNTER,
  "sum-counter",     SUM_COUNTER,
  "inv-counter",     INV_COUNTER,
  "test-behind-counter",TEST_BEHIND_COUNTER,
  "goto",            GOTO_X,
  "goto-counter",    GOTO_COUNTER,
  "store-pos",       STORE_X,
  "store-line",      STORE_Y,
  "goto-line-counter",GOTO_Y,
  "exit",            EXIT,
  "message-exit",    MES_EXIT,
  NULL, ERROR,
};
/*}}}  */

/*{{{  list all keywords/operations*/
sc_list_keys()
{
  /*{{{  all operations known in origami*/
  { KEY *key=bindings;
    while (key->num) printf("%s\n",(key++)->name);
  }
  /*}}}  */
  /*{{{  all keywords known from keybind*/
  { keywords *key=keytab;
    while (key->value) printf("%s\n",(key++)->name);
  }
  /*}}}  */
}
/*}}}  */
/*{{{  create an operation entry*/
creat_op(name,mode,lg,code,place)
  char *name;int lg,place; TOKEN *code; bool mode;

/* arguments are:
  name - name of the macro/function
  mode - the code is defined (forward)
  lg   - number of tokens
  code - the tokenlist
  place- the number of the used origami-macro-buffer or 0 for defmac
*/
{
  OP **act=new_op;

  while (*act!=NULL) act++;
  *act=(OP*)malloc(sizeof(OP));
  (*act)->op_name=(char*)malloc(strlen(name)+1);
  strcpy((*act)->op_name,name);
  (*act)->length=lg;
  (*act)->defined=mode;
  (*act)->place=place;
  (*act)->ops=(int*)malloc((1+lg)*sizeof(int));
  memcpy((*act)->ops,code,lg*sizeof(int));
  ((*act)->ops)[lg]=0;
  /*{{{  verbose-handling*/
  if (verbose) {
    if (place)
      fprintf(stderr,"and belongs to %s.\n",name);
    else
      fprintf(stderr,"operation %s uses %d tokens.\n",name,lg);
  }
  /*}}}  */
}
/*}}}  */
/*{{{  create an variable entry*/
creat_var(name) char *name;
{
  VARS **act=vars;

  while (*act!=NULL) act++;
  *act=(VARS*)malloc(sizeof(VARS));
  (*act)->var_name=(char*)malloc(strlen(name)+1);
  strcpy((*act)->var_name,name);
  (*act)->no=int_no++;
}
/*}}}  */
/*{{{  create an alias entry*/
creat_alias(name,code) char *name,*code;
{
  ALIAS **act= func_key;

  while (*act!=NULL) act++;
  *act=(ALIAS*)malloc(sizeof(ALIAS));
  (*act)->key_name=(char*)malloc(strlen(name)+1);
  strcpy((*act)->key_name,name);
  (*act)->code=(char*)malloc(strlen(code)+1);
  strcpy((*act)->code,code);
}
/*}}}  */
/*{{{  init alias list*/
/*{{{  void init_default_alias()*/
void init_default_alias()
{
  creat_alias("esc","\033");
  creat_alias("tab","\t");
  creat_alias("return","\r");
}
/*}}}  */
/*{{{  void init_termcap_alias()*/
static char termcap_area[400];

void init_termcap_alias()
{
  char bp[1024];
  char *terminal, *pointer, *cap;

  if ((terminal=getenv("TERM"))==NULL) return;
  if (tgetent(bp,terminal)<=0) return;
  pointer = termcap_area;
  if ((cap=tgetstr("kb",&pointer))!=NULL) creat_alias("backspace",cap);
  if ((cap=tgetstr("ku",&pointer))!=NULL) creat_alias("up",cap);
  if ((cap=tgetstr("kd",&pointer))!=NULL) creat_alias("down",cap);
  if ((cap=tgetstr("kl",&pointer))!=NULL) creat_alias("left",cap);
  if ((cap=tgetstr("kr",&pointer))!=NULL) creat_alias("right",cap);
  if ((cap=tgetstr("kD",&pointer))!=NULL) creat_alias("rubout",cap);
  if ((cap=tgetstr("kN",&pointer))!=NULL) creat_alias("next_page",cap);
  if ((cap=tgetstr("kP",&pointer))!=NULL) creat_alias("prev_page",cap);
  return;
}
/*}}}  */
/*{{{  void init_alias()*/
void init_alias()
{
  init_default_alias();
  init_termcap_alias();
}
/*}}}  */
/*}}}  */
/*{{{  read a character from input, count lines*/
int read_in()
{
  input=getc(in);
  if (input=='\n') line_no++;
  return(input);
}
/*}}}  */
/*{{{  get a token from input*/
tokens get_token(code) bool code;
{
  /*{{{  skip comments, spaces...*/
  while (input=='\n' || input==' ' || input==';') {
    if (input==';') {
      while (input!='\n' && input!=EOF) read_in();
    }
    read_in();
  }
  /*}}}  */

  switch (input) {
    /*{{{  single char tokens*/
    case EOF: {read_in();return(ENDFILE);}
    case '(': {read_in();return(BEGIN);}
    case ')': {read_in();return(END);}
    case ',': {read_in();return(COMMA);}
    /*}}}  */
    default :
      if (code) {
        /*{{{  code-parser*/
        switch (input) {
          /*{{{  Meta-handling*/
          case 'M': {
            read_in();
            if (input!='-') {
              fprintf(stderr,"incorrect meta-key in line %d.\n",line_no);
              return(ERROR);
            }
            read_in();
            return(META);
          }
          /*}}}  */
          /*{{{  Control-handling*/
          case 'C': {
            /*{{{  read -" and error-check*/
            read_in();
            if (input!='-') {
              fprintf(stderr,"incorrect control-sequence in line %d.\n",line_no);
              return(ERROR);
            }
            /*}}}  */
            read_in();
            if (input=='?') tk_char=127;
            else tk_char=toupper(input)-'A'+1;
            read_in();
            return(CHAR);
          }
          /*}}}  */
          /*{{{  Char-handling*/
          case '"': {
            tk_char=read_in();
            if (input<' ' || input>127) {
              fprintf(stderr,"incorrect char-definition in line %d.",line_no);
              return(ERROR);
            }
            read_in();
            return(CHAR);
            break;
          }
          /*}}}  */
          /*{{{  Alias-handling*/
          case '$': {
            char *s=tk_string;
            ALIAS **a=func_key;
          
            read_in();
            /*{{{  read aliasname*/
            while (input!=' ' && input!='\n'
                   && input!='=' && input!=EOF && input!=')') {
              *s++=input;
              read_in();
            }
            *s='\0';
            /*}}}  */
            while (*a!=NULL &&
                   strcmp((*a)->key_name,tk_string)) a++;
            if (*a!=NULL) { tk_alias = *a; return(DOLLAR); }
            fprintf(stderr,"unknown alias in line %d.\n",line_no);
            return(ERROR);
          }
          /*}}}  */
          /*{{{  default=error*/
          default : {
            fprintf(stderr,"incorrect codedefinition in line %d.\n",line_no);
            return(ERROR);
          }
          /*}}}  */
        }
        /*}}}  */
      } else {
        /*{{{  macro-parser*/
        switch (input) {
          /*{{{  string-handling*/
          case '"': {
            int *t=tk_macro;
          
            read_in();
            do {
              /*{{{  Test auf < ' ' oder EOF*/
              if (input<' ') {
                fprintf(stderr,"control key or eof in macro string in line %d.\n",line_no);
                return(ERROR);
              }
              /*}}}  */
              *t++ = input;
              read_in();
            }
            while (input!=' ' && input!='\n'
                   && input!=')' && input!=EOF && input!='"');
            *t=0;
            return(MACRO);
            break;
          }
          /*}}}  */
          /*{{{  opcode or keyword handling*/
          default : {
            char *s=tk_string;
            keywords *key=keytab;
            OP **a=new_op;
            VARS **v=vars;
          
            while (input!=' ' && input!='\n' && input!=')' && input!=','
                    && input!='=' && input!=EOF && input!='(')
              { *s++=input;read_in(); }
            *s='\0';
            /*{{{  search as keyword*/
            while (key->name!=NULL && strcmp(key->name,tk_string)) key++;
            if (key->value!=ERROR) return(key->value);
            /*}}}  */
            /*{{{  search as opcode*/
            tk_key=bindings;
            while (*tk_key->name!='\0' && strcmp(tk_key->name,tk_string))
              tk_key++;
            if (*tk_key->name!='\0') return(OPCODE);
            /*}}}  */
            /*{{{  search as operation*/
            while (*a!=NULL &&
                   strcmp((*a)->op_name,tk_string)) a++;
            if (*a!=NULL) { tk_operation = *a; return(OPERATION); }
            /*}}}  */
            /*{{{  search as variable*/
            while (*v!=NULL &&
                   strcmp((*v)->var_name,tk_string)) v++;
            if (*v!=NULL) { tk_var = *v; return(VARIABLE); }
            /*}}}  */
            return(NAME);
          }
          /*}}}  */
        }
        /*}}}  */
      }
  }
}
/*}}}  */
