#include <sys/types.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>

#include "bool.h"

#include "short.h"

#include "globals.h"
#define PROCEXIT_G
#include "origami.h"
#include "macros.h"

extern int bfile_no;
extern buffer buff;

#ifdef STD_C
PRIVATE void write_b(uchar b,LOC_proc *LINK)
#else
PRIVATE void write_b(b, LINK)
uchar b;
LOC_proc *LINK;
#endif /* STD_C */
{
  buff[bfile_no] = b;
  bfile_no++;
  if (bfile_no != 512)
  return;
  bfile_no = fwrite((char *)buff, 1, sizeof(uchar) * 512, LINK->tdsfile);
  P_ioresult = 0;
  bfile_no = 0;
}

#ifdef STD_C
PRIVATE void write_tag(int tag,int value,LOC_proc *LINK)
#else
PRIVATE void write_tag(tag, value, LINK)
int tag, value;
LOC_proc *LINK;
#endif /* STD_C */
{
  if (value > 63)
  write_b((uchar)(((unsigned)value) >> 6) + 192, LINK);
  write_b((uchar)((tag << 6) + (value & 63)), LINK);
}

#ifdef STD_C
PRIVATE void write_string(char *s,LOC_proc *LINK)
#else
PRIVATE void write_string(s, LINK)
char *s;
LOC_proc *LINK;
#endif /* STD_C */
{
  int i, FORLIM;

  write_tag(0, strlen(s), LINK);
  FORLIM = strlen(s);
  for (i = 0; i < FORLIM; i++)
  write_b((uchar)s[i], LINK);
}

#ifdef STD_C
PRIVATE void write_header(LOC_proc *LINK)
#else
PRIVATE void write_header(LINK)
LOC_proc *LINK;
#endif /* STD_C */
{
  write_tag(2, 0, LINK);   /*startlist*/
  write_string(LINK->dsp_line, LINK);
  write_tag(1, (int)LINK->p->UU.U1.fold_type, LINK);
  write_tag(1, (int)LINK->p->UU.U1.fold_contents, LINK);
  write_tag(1, (int)LINK->p->UU.U1.fold_indent, LINK);
  write_tag(2, 1, LINK);   /*endlist*/
}

#ifdef STD_C
PRIVATE void move_on_full(element **p)
#else
PRIVATE void move_on_full(p)
element **p;
#endif /* STD_C */
{
  if (filed_or_fold(*p))
  *p = (*p)->fold;
  else
  *p = (*p)->next;
}

#ifdef STD_C
PRIVATE void write_a_list(LOC_proc *LINK)
#else
PRIVATE void write_a_list(LINK)
LOC_proc *LINK;
#endif /* STD_C */
{
  char STR1[MAX_FIELD_SIZE + 1];

  write_tag(2, 0, LINK);
  while (LINK->pn->foldline != END_FOLD) {
    LINK->p = LINK->pn;
    move_on_full(&LINK->pn);
    copy_parts_to_line(LINK->p, LINK->dsp_line);
    trailing_spaces(LINK->dsp_line);
    if (LINK->p->foldline == NOT_FOLD) write_string(LINK->dsp_line, LINK);
    if (LINK->p->foldline == START_FOLD || LINK->p->foldline == START_OPEN_FOLD) {
      write_tag(2, 2, LINK);
      write_header(LINK);
      write_a_list(LINK);
      write_tag(2, 3, LINK);   /*endfold*/
      continue;
    }
    if (LINK->p->foldline != START_FILED) continue;
    write_tag(2, 4, LINK);
    write_header(LINK);
    write_string((char *)line_of(STR1, LINK->p->other_end), LINK);
    write_tag(2, 5, LINK);   /*endfiled*/
    move_on_full(&LINK->pn);
  }
  write_tag(2, 1, LINK);
  if (LINK->pn->foldline == END_FOLD)
  move_on_full(&LINK->pn);
}

#ifdef STD_C
PRIVATE void write_tds(LOC_proc *LINK)
#else
PRIVATE void write_tds(LINK)
LOC_proc *LINK;
#endif /* STD_C */
{
  char STR1[MAX_FIELD_SIZE + 1];

  strcpy(LINK->tdsfile_NAME, line_of(STR1, LINK->file_ptr));
  if (LINK->tdsfile != NULL)
  LINK->tdsfile = freopen(LINK->tdsfile_NAME, "w+b", LINK->tdsfile);
  else
  LINK->tdsfile = fopen(LINK->tdsfile_NAME, "w+b");
  if (LINK->tdsfile == NULL) P_ioresult=FileNotFound;
  else P_ioresult=0;
  bfile_no = 0;
  write_a_list(LINK);
  if (bfile_no > 0) {
    bfile_no = fwrite((char *)buff, 1, bfile_no, LINK->tdsfile);
    P_ioresult = 0;
  }
  /* p2c: edtio.pas, line 467:
   * Note: Can't interpret size in BLOCKWRITE [174]
  */
  if (LINK->tdsfile != NULL)
  (void) fclose(LINK->tdsfile);
  LINK->tdsfile = NULL;
}

#ifdef STD_C
void front_hash(char *line)
#else
void front_hash(line)
char *line;
#endif
{
  char *begin=line;

  while (*line==' ') line++;
  if (*line=='#') {
    *line=' ';
    *begin='#';
  }
}

#ifdef STD_C
void proc_exit(element *file_ptr_,element *from_ptr)
#else
void proc_exit(file_ptr_, from_ptr)
element *file_ptr_, *from_ptr;
#endif /* STD_C */
{
  LOC_proc V;
  char filename[128];
  char STR1[72];
  char STR2[MAX_FIELD_SIZE + 1];
  char STR3[MAX_FIELD_SIZE + 1];
  char STR6[MAX_FIELD_SIZE + 1];

  V.file_ptr = file_ptr_;
  V.tdsfile = NULL;
  V.pn = from_ptr;
  move_on(&V.pn);
  current_ind = 0;
  line_of(filename, V.file_ptr);
  if (tstorefile != NULL)
  tstorefile = freopen(filename, "w", tstorefile);
  else tstorefile = fopen(filename, "w");
  if (tstorefile!=NULL)
  {
    sprintf(STR1, "Writing %s ...", filename);
    message(STR1,TRUE);
    if (dialect < NO_LANGUAGES)
    {   /*ie not tds*/
      strcpy(tstorefile_NAME, filename);
      if ((dialect == NO_LANGUAGES - 1) && !fold_out)
      {
        fprintf(tstorefile, "%s{{{}}}%s\n",
        dialect_start[dialect],
        dialect_end[dialect]);
      }
      while (V.pn != from_ptr->other_end)
      {   /*tail*/
        V.p = V.pn;
        copyin(V.dsp_line, V.p, TRUE);
        trailing_spaces(V.dsp_line);
        if (current_ind > 0)
          strinsert(spaces(STR2, current_ind), V.dsp_line, 1);
        if (dialect == fortran_ && (V.p->foldline != NOT_FOLD ||
                                   strpos2(line_of(STR3, V.p), "C ", 1) == 1))
          V.dsp_line[0] = 'C';
        if (c_hash_front) front_hash(V.dsp_line);
        fprintf(tstorefile, "%s\n", V.dsp_line);
        if (filed_or_fold(V.p))
        current_ind += total_indent(V.p);
        if (filed_or_fold(V.p) || V.p->foldline == START_OPEN_FOLD)
        {
          if (dialect >= 0)
          {
            sprintf(V.dsp_line, "%s%s:::",
            spaces(STR2, current_ind), dialect_start[dialect]);
            if (dialect == fortran_)
            V.dsp_line[0] = 'C';
            if (!normal_att(V.p))
            {
              fprintf(tstorefile, "%sA %2d %d%s\n",
              V.dsp_line, V.p->UU.U1.fold_type,
              V.p->UU.U1.fold_contents,
              dialect_end[dialect]);
            }
            if (V.p->foldline == START_FILED)
            {
              fprintf(tstorefile, "%sF %s%s\n",
              V.dsp_line, line_of(STR3, V.p->other_end),
              dialect_end[dialect]);
            }
          }
          if (V.p->UU.U1.fold_type == 1 && V.p->foldline == START_FILED)
          {
            current_ind -= total_indent(V.p);
            V.pn = V.p->other_end;
          }
        }
        move_on_full(&V.pn);
        if (V.p->foldline == END_FOLD)
        {
          if (filed_or_fold(V.p->other_end))
          current_ind -= total_indent(V.p->other_end);
        }
      }
      if (tstorefile != NULL)
      (void) fclose(tstorefile);
      tstorefile = NULL;
    }
    else write_tds(&V);
    sprintf(STR1, "%s written", filename);
    message(STR1,TRUE);
  }
  else
  {
    sprintf(STR6, "Can't write %s", filename);
    message(STR6,TRUE);
  }
  if (V.tdsfile != NULL)
  (void) fclose(V.tdsfile);
}
